/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera.gl;

import android.opengl.GLES20;
import com.skype.android.video.hw.codec.encoder.camera.gl.GLException;
import com.skype.android.video.hw.utils.Log;
import java.io.Closeable;

class Shader
implements Closeable {
    private int id;
    private static String simpleClassName = Shader.class.getSimpleName();

    public Shader(int type, String source) throws GLException {
        try {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + ": Creating new shader");
            }
            if ((this.id = GLES20.glCreateShader((int)type)) == 0) {
                throw new GLException("Failed to create shader.", GLES20.glGetError());
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + ": Shader " + this.id + " created");
            }
            this.loadSourceCode(source);
            this.compile();
        }
        catch (GLException e) {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + ": Constructor failed");
            }
            this.close();
            throw e;
        }
    }

    @Override
    public void close() {
        if (this.id != 0) {
            int error;
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + ": Deleting shader " + this.id);
            }
            GLES20.glDeleteShader((int)this.id);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + ": Shader " + this.id + " deleted");
            }
            if ((error = GLES20.glGetError()) != 0 && Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", simpleClassName + ": Failed to delete shader " + this.id);
            }
            this.id = 0;
        }
    }

    public int getId() {
        return this.id;
    }

    private void loadSourceCode(String source) throws GLException {
        int error;
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Loading shader " + this.id + " source code\n" + source);
        }
        GLES20.glShaderSource((int)this.id, (String)source);
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Shader " + this.id + " source code loaded");
        }
        if ((error = GLES20.glGetError()) != 0) {
            throw new GLException("Failed to load shader code.", error);
        }
    }

    private void compile() throws GLException {
        int error;
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Compiling shader " + this.id);
        }
        GLES20.glCompileShader((int)this.id);
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassName + ": Shader " + this.id + " compiled");
        }
        if ((error = GLES20.glGetError()) != 0) {
            throw new GLException("Failed to compile shader.", error);
        }
    }
}

