/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.camera.gl;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.util.SparseArray;
import com.skype.android.video.hw.codec.encoder.camera.gl.AbstractRenderingTarget;
import com.skype.android.video.hw.codec.encoder.camera.gl.BufferRenderingTarget;
import com.skype.android.video.hw.codec.encoder.camera.gl.ChannelPushFrame;
import com.skype.android.video.hw.codec.encoder.camera.gl.Context;
import com.skype.android.video.hw.codec.encoder.camera.gl.EncoderRenderingTarget;
import com.skype.android.video.hw.codec.encoder.camera.gl.GLException;
import com.skype.android.video.hw.codec.encoder.camera.gl.ScreenRenderingTarget;
import com.skype.android.video.hw.codec.encoder.camera.gl.SurfaceTextureRenderer;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.utils.CodecUtils;
import com.skype.android.video.hw.utils.FrameRateController;
import com.skype.android.video.hw.utils.Log;
import com.skype.android.video.hw.utils.Systrace;
import java.io.Closeable;
import java.util.Locale;
import java.util.concurrent.TimeoutException;

public class SurfaceTextureChannel
implements ChannelPushFrame,
Closeable {
    private static final int[] EGL_SHARED_CONTEXT_ATTRIBUTES = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12344};
    private final Object newFrameArrivedEvent = new Object();
    private final SparseArray<AbstractRenderingTarget> renderingTargets = new SparseArray();
    private EGLDisplay eglDisplay = EGL14.EGL_NO_DISPLAY;
    private Context sharedContext;
    private SurfaceTextureRenderer renderer;
    private AbstractRenderingTarget defaultRenderingTarget;
    private SurfaceTexture sourceTexture;
    private Resolution sourceResolution;
    private boolean isFirstFrame = true;
    private boolean isBroadComChip = false;
    private final boolean isPreEncodingRC;
    private boolean dropFrame = false;
    private FrameRateController frameRateController;
    private volatile SourceState sourceState = SourceState.WAITING_FOR_FRAME;
    private static String simpleClassName = SurfaceTextureChannel.class.getSimpleName();

    public SurfaceTextureChannel(boolean isPreEncodingRC) throws GLException {
        Log.i("SLIQ", simpleClassName + ": Constructing");
        this.isPreEncodingRC = isPreEncodingRC;
        try {
            this.frameRateController = new FrameRateController(30.0f);
            this.eglDisplay = SurfaceTextureChannel.createEGLDisplay();
            this.sharedContext = new Context(this.eglDisplay, EGL_SHARED_CONTEXT_ATTRIBUTES);
            this.defaultRenderingTarget = new BufferRenderingTarget(this.sharedContext, null);
            this.defaultRenderingTarget.setSurface(null, new Resolution(320, 240));
            this.renderer = new SurfaceTextureRenderer();
            this.sourceTexture = new SurfaceTexture(this.renderer.getSourceTextureId());
            this.sourceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)new SourceFrameAvailableListener());
        }
        catch (GLException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", simpleClassName + ": Initialization failed. Closing");
            }
            this.close();
            throw e;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", simpleClassName + ": Initialization failed. Closing");
            }
            this.close();
            throw e;
        }
        String[] encoderNames = CodecUtils.enumEncoders();
        for (int i = 0; i < encoderNames.length; ++i) {
            String name = encoderNames[i];
            if (!name.toLowerCase(Locale.ROOT).contains("brcm") && !name.toLowerCase(Locale.ROOT).contains("broadcom")) continue;
            this.isBroadComChip = true;
            break;
        }
    }

    public Object getSharedMutex() {
        return this.renderingTargets;
    }

    public boolean hasTarget(int id) {
        return this.renderingTargets.indexOfKey(id) >= 0;
    }

    public void allocateOutput(OutputType type, int id, AbstractRenderingTarget.Events eventsListener) throws GLException {
        int index = this.renderingTargets.indexOfKey(id);
        if (index >= 0) {
            throw new IllegalArgumentException("another target " + id + "/" + (Object)((Object)type) + " exists");
        }
        this.renderingTargets.append(id, (Object)this.createRenderingTarget(type, eventsListener));
    }

    public void deallocateOutput(int id) {
        int index = this.renderingTargets.indexOfKey(id);
        if (index < 0) {
            return;
        }
        AbstractRenderingTarget target = (AbstractRenderingTarget)this.renderingTargets.valueAt(index);
        if (target != null) {
            target.close();
        }
        this.renderingTargets.removeAt(index);
    }

    public boolean isOutputAttached(int id) {
        if (this.renderingTargets == null) {
            throw new IllegalStateException("closed");
        }
        return ((AbstractRenderingTarget)this.renderingTargets.get(id)).hasSurface();
    }

    public boolean isOutputAttached(int id, Object surface, Resolution resolution) {
        if (this.renderingTargets == null) {
            throw new IllegalStateException("closed");
        }
        AbstractRenderingTarget target = (AbstractRenderingTarget)this.renderingTargets.get(id);
        return target.hasSurface() && target.getSurface() == surface && (resolution == null && target.getResolution() == null || resolution != null && resolution.equals(target.getResolution()));
    }

    public void attachOutput(int id, Object surface, Resolution resolution) throws GLException {
        if (this.renderingTargets == null) {
            throw new IllegalStateException("closed");
        }
        ((AbstractRenderingTarget)this.renderingTargets.get(id)).setSurface(surface, resolution);
    }

    public void detachOutput(int id) {
        if (this.renderingTargets == null) {
            throw new IllegalStateException("closed");
        }
        ((AbstractRenderingTarget)this.renderingTargets.get(id)).unsetSurface();
    }

    public void setParameters(int id, boolean isEnabled, int rotationAngle, float fitFactor, boolean isHorizFlipped, boolean isVertFlipped, float targetFrameRate) {
        if (this.renderingTargets == null) {
            throw new IllegalStateException("closed");
        }
        AbstractRenderingTarget target = (AbstractRenderingTarget)this.renderingTargets.get(id);
        target.setEnabled(isEnabled);
        target.setRotationAngle(rotationAngle);
        target.setFlipped(isHorizFlipped, isVertFlipped);
        target.setFitFactor(fitFactor);
        target.setTargetFrameRate(targetFrameRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Interrupting");
        }
        Object object = this.newFrameArrivedEvent;
        synchronized (object) {
            this.sourceState = SourceState.INTERRUPTED;
            this.newFrameArrivedEvent.notify();
        }
    }

    public long acquireFrame(long timeoutMs) throws GLException, InterruptedException, TimeoutException {
        if (this.sourceTexture == null || this.renderingTargets == null || this.renderer == null) {
            throw new IllegalStateException("closed");
        }
        switch (this.awaitNewFrame(timeoutMs)) {
            case WAITING_FOR_FRAME: {
                if (Log.isLoggable("SLIQ", 6)) {
                    Log.e("SLIQ", simpleClassName + ": Could not get a frame withing " + timeoutMs + " ms. Timeouyt elapsed");
                }
                throw new TimeoutException();
            }
            case INTERRUPTED: {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", simpleClassName + ": Wait for a frame interrupted");
                }
                throw new InterruptedException();
            }
        }
        this.defaultRenderingTarget.bind();
        try {
            Log.i("SLIQ", simpleClassName + ": Updating source texture image");
            this.sourceTexture.updateTexImage();
        }
        catch (RuntimeException e) {
            throw new GLException("Failed to update texture image", e);
        }
        return this.getTimestamp(this.sourceTexture);
    }

    public void pushAndRenderFrame(long timestampNs) throws GLException {
        this.updateFrameRateContoller(timestampNs);
        if (this.isPreEncodingRC) {
            this.renderPreviewAndSignalFrameReady(timestampNs);
        } else {
            this.pushFrameToAllTargets(timestampNs);
        }
    }

    private void renderPreviewAndSignalFrameReady(long timestampNs) throws GLException {
        int num = this.renderingTargets.size();
        for (int i = 0; i < num; ++i) {
            AbstractRenderingTarget target = (AbstractRenderingTarget)this.renderingTargets.valueAt(i);
            if (!target.isEnabled() || !target.hasSurface() || target.getResolution() == null) continue;
            if (target instanceof ScreenRenderingTarget) {
                this.pushFrameToSingleTarget(timestampNs, target);
            } else {
                target.setDelayedTimestmap(timestampNs);
            }
            target.onFrameReady(timestampNs);
        }
    }

    private void pushFrameToAllTargets(long timestampNs) throws GLException {
        int num = this.renderingTargets.size();
        for (int i = 0; i < num; ++i) {
            AbstractRenderingTarget target = (AbstractRenderingTarget)this.renderingTargets.valueAt(i);
            if (target instanceof ScreenRenderingTarget) {
                this.pushFrameToSingleTarget(System.nanoTime(), target);
            } else {
                this.pushFrameToSingleTarget(timestampNs, target);
            }
            target.onFrameReady(timestampNs);
        }
    }

    @Override
    public boolean executePushFrame(int Id) throws GLException {
        if (!this.isPreEncodingRC) {
            return false;
        }
        long timestampNs = ((AbstractRenderingTarget)this.renderingTargets.get(Id)).getDelayedTimestamp();
        this.pushFrameToSingleTarget(timestampNs, (AbstractRenderingTarget)this.renderingTargets.get(Id));
        return this.dropFrame;
    }

    private void updateFrameRateContoller(long timestampNs) {
        long timestampMs = timestampNs / 1000000L;
        Log.i("SLIQ", simpleClassName + " timestampMs " + timestampMs + " ms timestampNs " + timestampNs + " ns");
        AbstractRenderingTarget target = null;
        int num = this.renderingTargets.size();
        for (int i = 0; !(i >= num || (target = (AbstractRenderingTarget)this.renderingTargets.valueAt(i)).isEnabled() && target.hasSurface() && target.getResolution() != null && target instanceof EncoderRenderingTarget); ++i) {
        }
        if (target != null) {
            float targetFps = target.getTargetFrameRate();
            if (targetFps > 0.0f && this.frameRateController.GetTargetFps() != targetFps) {
                this.frameRateController.Reset(targetFps, timestampMs, targetFps > this.frameRateController.GetTargetFps() + 1.0f);
            }
            boolean bl = this.dropFrame = targetFps > 0.0f && this.frameRateController.GetDropFlag(timestampMs);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassName + (this.dropFrame ? ": drop " : ": encode ") + "current Frame");
            }
            if (!this.dropFrame && targetFps > 0.0f) {
                this.frameRateController.Update(timestampMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushFrameToSingleTarget(long timestampNs, AbstractRenderingTarget target) throws GLException {
        if (target.isEnabled() && target.hasSurface() && target.getResolution() != null) {
            if (target instanceof ScreenRenderingTarget) {
                Systrace.begin(Systrace.Section.RenderVideoPreview);
                try {
                    this.render(System.nanoTime(), target);
                }
                finally {
                    Systrace.end();
                }
            }
            if (!this.dropFrame) {
                Systrace.begin(Systrace.Section.RenderVideoTarget);
                try {
                    this.render(timestampNs, target);
                    if (this.isFirstFrame && this.isBroadComChip) {
                        this.isFirstFrame = false;
                        this.render(timestampNs + 1000L, target);
                    }
                }
                finally {
                    Systrace.end();
                }
            }
        }
    }

    private void render(long timestampNs, AbstractRenderingTarget target) throws GLException {
        target.bind();
        this.renderer.draw(this.sourceTexture, this.sourceResolution, target.getResolution(), target.getFitFactor(), target.getRotationAngle(), target.isHorizFlipped(), target.isVertFlipped());
        target.setTimestamp(timestampNs);
        target.swapBuffers();
    }

    public void freeContext() throws GLException {
        this.defaultRenderingTarget.unbind();
    }

    public SurfaceTexture getInput() {
        return this.sourceTexture;
    }

    public void setInputResolution(Resolution resolution) {
        this.sourceResolution = resolution;
    }

    @Override
    public void close() {
        int num = this.renderingTargets.size();
        for (int i = 0; i < num; ++i) {
            ((AbstractRenderingTarget)this.renderingTargets.valueAt(i)).close();
        }
        this.renderingTargets.clear();
        if (this.sourceTexture != null) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", simpleClassName + ": Releasing surface texture 0x" + Integer.toHexString(System.identityHashCode(this.sourceTexture)));
            }
            this.sourceTexture.release();
            this.sourceTexture = null;
        }
        if (this.renderer != null) {
            this.renderer.close();
            this.renderer = null;
        }
        if (this.defaultRenderingTarget != null) {
            this.defaultRenderingTarget.close();
            this.defaultRenderingTarget = null;
        }
        if (this.sharedContext != null) {
            this.sharedContext.close();
            this.sharedContext = null;
        }
        if (this.eglDisplay != null) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", simpleClassName + ": Terminating EGL");
            }
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
            this.eglDisplay = EGL14.EGL_NO_DISPLAY;
        }
    }

    protected long getTimestamp(SurfaceTexture st) {
        return st.getTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceState awaitNewFrame(long timeoutMs) throws InterruptedException, GLException {
        Object object = this.newFrameArrivedEvent;
        synchronized (object) {
            if (this.sourceState == SourceState.WAITING_FOR_FRAME) {
                this.newFrameArrivedEvent.wait(timeoutMs);
            }
            Systrace.begin(Systrace.Section.CaptureVideo);
            SourceState initialState = this.sourceState;
            this.sourceState = SourceState.WAITING_FOR_FRAME;
            return initialState;
        }
    }

    private AbstractRenderingTarget createRenderingTarget(OutputType type, AbstractRenderingTarget.Events eventsListener) throws GLException {
        switch (type) {
            case ENCODER: {
                return new EncoderRenderingTarget(this.sharedContext, eventsListener);
            }
            case SCREEN: {
                return new ScreenRenderingTarget(this.sharedContext, eventsListener);
            }
        }
        throw new IllegalArgumentException("unknown rendering target type " + (Object)((Object)type));
    }

    private static EGLDisplay createEGLDisplay() throws GLException {
        int[] eglVersion;
        EGLDisplay eglDisplay;
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Creating EGL display");
        }
        if ((eglDisplay = EGL14.eglGetDisplay((int)0)) == EGL14.EGL_NO_DISPLAY) {
            throw new GLException("Failed to get EGL14 display.", EGL14.eglGetError());
        }
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": Initializing EGL");
        }
        if (!EGL14.eglInitialize((EGLDisplay)eglDisplay, (int[])(eglVersion = new int[2]), (int)0, (int[])eglVersion, (int)1)) {
            throw new GLException("Failed to initialize EGL.", EGL14.eglGetError());
        }
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", simpleClassName + ": EGL initialized: version " + eglVersion[0] + "." + eglVersion[1]);
        }
        return eglDisplay;
    }

    private class SourceFrameAvailableListener
    implements SurfaceTexture.OnFrameAvailableListener {
        private SourceFrameAvailableListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            Object object = SurfaceTextureChannel.this.newFrameArrivedEvent;
            synchronized (object) {
                SurfaceTextureChannel.this.sourceState = SourceState.FRAME_AVAILABLE;
                SurfaceTextureChannel.this.newFrameArrivedEvent.notifyAll();
            }
        }
    }

    public static enum OutputType {
        SCREEN,
        ENCODER;

    }

    private static enum SourceState {
        WAITING_FOR_FRAME,
        FRAME_AVAILABLE,
        INTERRUPTED;

    }
}

