/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.codec.encoder.control;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Bundle;
import com.skype.android.video.hw.codec.OmxWrapper;
import com.skype.android.video.hw.codec.encoder.control.VideoEncoderControl;
import com.skype.android.video.hw.format.H264Profile;
import com.skype.android.video.hw.format.VideoFormat;
import com.skype.android.video.hw.utils.Log;

public abstract class AbstractVideoEncoderControl
implements VideoEncoderControl {
    private final MediaCodec mediaCodec;
    private final Bundle setBitrateRequest = new Bundle();
    private final Bundle syncFrameRequest = new Bundle();
    private final Bundle suspendRequest = new Bundle();
    private final String simpleClassName = this.getClass().getSimpleName();

    public AbstractVideoEncoderControl(MediaCodec mediaCodec, OmxWrapper omxWrapper) {
        this.mediaCodec = mediaCodec;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void setBitrate(int bitrate) {
        this.setBitrateRequest.putInt("video-bitrate", bitrate);
        this.mediaCodec.setParameters(this.setBitrateRequest);
    }

    @SuppressLint(value={"NewApi"})
    public void requestSyncFrame() {
        this.syncFrameRequest.putInt("request-sync", 0);
        this.mediaCodec.setParameters(this.syncFrameRequest);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void suspend() {
        this.suspendRequest.putInt("drop-input-frames", 1);
        this.mediaCodec.setParameters(this.suspendRequest);
    }

    @Override
    public void doConfigureMediaFormat(MediaFormat mediaFormat, VideoFormat format) {
        mediaFormat.setInteger("color-format", format.getColorFormat().getOmxValue().intValue());
        if (format.getBitrate() > 0) {
            mediaFormat.setInteger("bitrate", format.getBitrate());
        } else {
            int defaultBitrate = 500000;
            if (Log.isLoggable("SLIQ", 5)) {
                Log.i("SLIQ", this.simpleClassName + ": Bad init bitrate " + format.getBitrate() + "bps. Setting default bitrate " + defaultBitrate + "bps on " + this.mediaCodec + " to prevent crash");
            }
            mediaFormat.setInteger("bitrate", defaultBitrate);
        }
        if (format.getFrameRate() >= 0) {
            mediaFormat.setInteger("frame-rate", format.getFrameRate());
        }
        if (format.getiFrameInterval() >= 0) {
            mediaFormat.setInteger("i-frame-interval", format.getiFrameInterval());
        }
        if (format.getProfile() == H264Profile.HIGH) {
            mediaFormat.setInteger("profile", H264Profile.HIGH.getOmxValue().intValue());
        } else {
            mediaFormat.setInteger("profile", H264Profile.BASELINE.getOmxValue().intValue());
        }
        mediaFormat.setInteger("level", format.getLevel().getOmxValue().intValue());
    }
}

