/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.extension.encoder;

import android.media.MediaFormat;
import android.os.Build;
import com.skype.android.video.hw.codec.AbstractMediaCodec;
import com.skype.android.video.hw.codec.encoder.AbstractVideoEncoder;
import com.skype.android.video.hw.codec.encoder.camera.SurfaceObserver;
import com.skype.android.video.hw.codec.encoder.camera.capture.CapturerException;
import com.skype.android.video.hw.extension.JniCodecUtils;
import com.skype.android.video.hw.extension.encoder.VideoEncoderExtension;
import com.skype.android.video.hw.format.Capabilities;
import com.skype.android.video.hw.format.ColorFormat;
import com.skype.android.video.hw.format.H264Level;
import com.skype.android.video.hw.format.H264Profile;
import com.skype.android.video.hw.format.RateControlMode;
import com.skype.android.video.hw.format.Resolution;
import com.skype.android.video.hw.format.VideoFormat;
import com.skype.android.video.hw.frame.OutputFrame;
import com.skype.android.video.hw.utils.CodecUtils;
import com.skype.android.video.hw.utils.DebugUtils;
import com.skype.android.video.hw.utils.EncoderAttributes;
import com.skype.android.video.hw.utils.Log;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.regex.Pattern;

public abstract class AbstractVideoEncoderExtension<Encoder extends AbstractVideoEncoder>
implements VideoEncoderExtension {
    private static final H264Level DEFAULT_H264_LEVEL = H264Level.L31;
    private static final H264Profile DEFAULT_H264_PROFILE = H264Profile.BASELINE;
    private static final int DEFAULT_FRAMERATE = 30;
    private static final int DEFAULT_I_FRAME_INTERVAL = 420;
    private static final int OUTPUT_FRAME_POOL_SIZE = 2;
    private static final int COMPRESSION_RATIO_ESTIMATION = 100;
    private final String simpleClassName = this.getClass().getSimpleName();
    private final String encoderName;
    private Encoder encoder;
    private long initialTimestamp;
    private int rawFrameSize;
    private WeakReference<SurfaceObserver> weakRefSurfaceObserver;
    private int consecutiveTimeOut;
    private boolean isFirstFrame = true;
    private boolean isFastAsyncMode = false;

    protected abstract Encoder doCreateEncoder(String var1);

    protected abstract void doCloseEncoder();

    protected abstract OutputFrame doEncodeFrame(long var1, long var3, long var5, boolean var7);

    protected AbstractVideoEncoderExtension(int encoderIndex) {
        this.encoderName = CodecUtils.enumEncoders()[encoderIndex];
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + " with h/w encoder #" + encoderIndex + " (" + this.encoderName + ") created");
        }
    }

    public static boolean getCapabilities(String encoderName, long capabilitiesNativeObj) {
        String simpleClassNameStatic = AbstractVideoEncoderExtension.class.getSimpleName();
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", simpleClassNameStatic + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Build.VERSION.SDK_INT < 19) {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassNameStatic + '#' + DebugUtils.getMethodName() + "() don't query capability on API level " + Build.VERSION.SDK_INT);
            }
            return false;
        }
        try {
            AbstractVideoEncoderExtension.passCapabilitiesToNative(capabilitiesNativeObj, CodecUtils.getEncoderCapabilities(encoderName));
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassNameStatic + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return true;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", simpleClassNameStatic + '#' + DebugUtils.getMethodName() + "() failed");
            }
            return false;
        }
    }

    protected int initInternal(EncoderAttributes attributes, boolean isReinitializing, boolean isFastAsyncMode, Object userData) throws EncoderAttributes.AttributeException {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called: isReinitializing " + isReinitializing + " isFastAsyncMode " + isFastAsyncMode);
        }
        this.initialTimestamp = Integer.toUnsignedLong(attributes.getInteger("ts"));
        this.weakRefSurfaceObserver = userData == null ? null : new WeakReference<SurfaceObserver>((SurfaceObserver)userData);
        VideoFormat videoFormat = AbstractVideoEncoderExtension.getVideoFormatFromAttributes(attributes);
        Log.i("SLIQ", "video format " + videoFormat.toString());
        if (!CodecUtils.getEncoderCapabilities(this.encoderName).getProfiles().contains(videoFormat.getProfile())) {
            throw new EncoderAttributes.AttributeException("encoder " + this.encoderName + " does not support " + videoFormat.getProfile());
        }
        int width = videoFormat.getOrgResolution().getWidth() > 0 ? videoFormat.getOrgResolution().getWidth() : videoFormat.getResolution().getWidth();
        int height = videoFormat.getOrgResolution().getHeight() > 0 ? videoFormat.getOrgResolution().getHeight() : videoFormat.getResolution().getHeight();
        this.rawFrameSize = width * height * videoFormat.getColorFormat().getBitsPerPixel() / 8;
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + ": Creating encoder " + this.encoderName + " with " + videoFormat + " and " + userData + " initTs " + Long.toUnsignedString(this.initialTimestamp));
        }
        this.isFirstFrame = true;
        if (!isReinitializing) {
            this.encoder = this.doCreateEncoder(this.encoderName);
        }
        boolean specific_realwear = attributes.getInteger("limited-config-for-realwear", 0) != 0;
        String extPrefix = ((AbstractMediaCodec)this.encoder).getExtPrefix();
        if (Build.VERSION.SDK_INT >= 28 && ((AbstractMediaCodec)this.encoder).isUseQCAfterNougatExtension().booleanValue() && extPrefix.contains("qti") && !specific_realwear) {
            if (videoFormat.getProfile().getName().toLowerCase(Locale.ROOT).contains("baseline")) {
                videoFormat.setProfile(H264Profile.CONSTRAINEDBASELINE);
            } else if (videoFormat.getProfile().getName().toLowerCase(Locale.ROOT).contains("high")) {
                videoFormat.setProfile(H264Profile.CONSTRAINEDHIGH);
            }
        }
        Log.i("SLIQ", "video format " + videoFormat.toString() + " realwear flag " + specific_realwear);
        boolean checkDriverVersion = !isReinitializing && 1 == attributes.getInteger("check-android-hw-api-version", 0);
        ((AbstractMediaCodec)this.encoder).configure(userData, videoFormat, checkDriverVersion);
        ((AbstractMediaCodec)this.encoder).start();
        ((AbstractMediaCodec)this.encoder).configureDynamic(videoFormat);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            if (Log.isLoggable("SLIQ", 5)) {
                Log.w("SLIQ", this.simpleClassName + ": Interrupted", e);
            }
            return -1;
        }
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
        }
        return 0;
    }

    @Override
    public int uninit(boolean isReinitializing) {
        if (Log.isLoggable("SLIQ", 4)) {
            Log.i("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called: isReinitializing " + isReinitializing);
        }
        try {
            if (this.encoder != null) {
                ((AbstractMediaCodec)this.encoder).stop();
                if (!isReinitializing) {
                    this.doCloseEncoder();
                    this.encoder = null;
                }
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_UNKNOWN");
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int processFrame(long timeoutUs, long nativeCallbackObj, long nativeFrameContext, long ts, boolean isReinitializing) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        SurfaceObserver surfaceObserver = this.weakRefSurfaceObserver != null ? (SurfaceObserver)this.weakRefSurfaceObserver.get() : null;
        try {
            if (surfaceObserver != null && !isReinitializing) {
                if (surfaceObserver.pushFrame()) {
                    if (Log.isLoggable("SLIQ", 4)) {
                        Log.i("SLIQ", this.simpleClassName + ": Drop frame from Capturer");
                    }
                    AbstractVideoEncoderExtension.bitstreamReady(nativeCallbackObj, false, null, 0, 0, ts, false, false, false);
                    return 0;
                }
                if (this.isFirstFrame && this.isFastAsyncMode) {
                    surfaceObserver.pushFrame();
                }
            }
            if (isReinitializing) {
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", this.simpleClassName + ": Skipping the frame due to reinitialization");
                }
                AbstractVideoEncoderExtension.bitstreamReady(nativeCallbackObj, false, null, 0, 0, ts, false, false, false);
            } else {
                boolean isCodecConfig = false;
                if (this.isFirstFrame) {
                    timeoutUs = 200000L;
                    this.isFirstFrame = false;
                }
                do {
                    OutputFrame outputFrame;
                    block25: {
                        outputFrame = this.doEncodeFrame(timeoutUs, nativeFrameContext, ts, isCodecConfig);
                        isCodecConfig = outputFrame.isCodecConfig();
                        while (outputFrame.hasBuffers()) {
                            OutputFrame.FrameBuffer frameBuffer = outputFrame.popBuffer();
                            boolean isIncomplete = outputFrame.hasBuffers() || isCodecConfig;
                            try {
                                AbstractVideoEncoderExtension.bitstreamReady(nativeCallbackObj, isIncomplete, frameBuffer.getData(), frameBuffer.getOffset(), frameBuffer.getSize(), ts, outputFrame.isEndOfStream(), outputFrame.isTimedOut(), outputFrame.isOutputFormatChanged());
                            }
                            finally {
                                frameBuffer.releaseFrameBuffer();
                                frameBuffer.close();
                            }
                        }
                        if (outputFrame.isTimedOut()) {
                            ++this.consecutiveTimeOut;
                            if (this.consecutiveTimeOut < 151) {
                                AbstractVideoEncoderExtension.bitstreamReady(nativeCallbackObj, false, null, 0, 0, ts, outputFrame.isEndOfStream(), outputFrame.isTimedOut(), outputFrame.isOutputFormatChanged());
                                break block25;
                            } else {
                                if (Log.isLoggable("SLIQ", 3)) {
                                    Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() HW encoder should not drop continuouse for 5 seconds, it is a timeout");
                                }
                                return 0;
                            }
                        }
                        this.consecutiveTimeOut = 0;
                    }
                    outputFrame.close();
                } while (isCodecConfig);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_UNKNOWN");
            }
            return -1;
        }
        catch (CapturerException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", this.simpleClassName + '#' + "Push frame has failed", e);
            }
            return -1;
        }
    }

    @Override
    public int flushFrames() {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
        }
        return 0;
    }

    @Override
    public int h264SetQp(int qp) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            ((AbstractVideoEncoder)this.encoder).setQp(qp);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (AbstractVideoEncoder.APINotImplementedException e) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", e.getFailedApiName() + "(" + e.toString() + ")");
            }
            return -10;
        }
    }

    @Override
    public int setNumTempLayers(int numTempLayers) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            ((AbstractVideoEncoder)this.encoder).setNumTempLayers(numTempLayers);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (AbstractVideoEncoder.APINotImplementedException e) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", e.getFailedApiName() + "(" + e.toString() + ")");
            }
            return -10;
        }
    }

    @Override
    public int cleanFrameParams() {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            ((AbstractVideoEncoder)this.encoder).cleanFrameParams();
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (AbstractVideoEncoder.APINotImplementedException e) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", e.getFailedApiName() + "(" + e.toString() + ")");
            }
            return -10;
        }
    }

    @Override
    public int markParamsTimestamp(long timestamp) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called with timestamp: " + timestamp + " tsMs: " + (timestamp - this.getInitialTimestamp()));
        }
        try {
            ((AbstractVideoEncoder)this.encoder).markParamsTimestamp(timestamp - this.getInitialTimestamp());
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (AbstractVideoEncoder.APINotImplementedException e) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", e.getFailedApiName() + "(" + e.toString() + ")");
            }
            return -10;
        }
    }

    @Override
    public int configureFrameParams() {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            ((AbstractVideoEncoder)this.encoder).configureFrameParams();
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (AbstractVideoEncoder.APINotImplementedException e) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", e.getFailedApiName() + "(" + e.toString() + ")");
            }
            return -10;
        }
    }

    @Override
    public int setBaseLayerPID(int baseLayerPID) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            ((AbstractVideoEncoder)this.encoder).setBaseLayerPID(baseLayerPID);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (AbstractVideoEncoder.APINotImplementedException e) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", e.getFailedApiName() + "(" + e.toString() + ")");
            }
            return -10;
        }
    }

    @Override
    public int setBitrate(int bitratekbps) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called bitrate:" + bitratekbps + "kbps");
        }
        if (Build.VERSION.SDK_INT < 19) {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_NOT_IMPLEMENTED in API " + Build.VERSION.SDK_INT);
            }
            return -10;
        }
        try {
            ((AbstractVideoEncoder)this.encoder).setBitrate(bitratekbps * 1000);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (IllegalArgumentException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Illegal argument value", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_INCORRECT_PARAM");
            }
            return -9;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_UNKNOWN");
            }
            return -1;
        }
    }

    @Override
    public int forceIdr() {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Build.VERSION.SDK_INT < 19) {
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_NOT_IMPLEMENTED in API " + Build.VERSION.SDK_INT);
            }
            return -10;
        }
        try {
            ((AbstractVideoEncoder)this.encoder).requestSyncFrame();
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_UNKNOWN");
            }
            return -1;
        }
    }

    @Override
    public int dropNextNFrames(int n) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_NOT_IMPLEMENTED");
        }
        return -10;
    }

    @Override
    public int setFPS(float fps) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            SurfaceObserver surfaceObserver;
            SurfaceObserver surfaceObserver2 = surfaceObserver = this.weakRefSurfaceObserver != null ? (SurfaceObserver)this.weakRefSurfaceObserver.get() : null;
            if (surfaceObserver != null) {
                if (Log.isLoggable("SLIQ", 3)) {
                    Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() set targetFps to " + fps);
                }
                surfaceObserver.setTargetFrameRate(fps);
                if (Log.isLoggable("SLIQ", 3)) {
                    Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
                }
            }
            return 0;
        }
        catch (RuntimeException e) {
            if (Log.isLoggable("SLIQ", 6)) {
                Log.e("SLIQ", "Unexpected exception caught", e);
            }
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_UNKNOWN");
            }
            return -1;
        }
    }

    @Override
    public int restartEncoder(int bitratekbps, float fps) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_NOT_IMPLEMENTED");
        }
        return -10;
    }

    @Override
    public int setSliceSize(int size, int mode) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_NOT_IMPLEMENTED");
        }
        return -10;
    }

    @Override
    public int setMaxNumRefFrames(int maxNumRefFrames) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_NOT_IMPLEMENTED");
        }
        return -10;
    }

    @Override
    public int setProvideMADMetric(boolean provideMAD) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_NOT_IMPLEMENTED");
        }
        return -10;
    }

    @Override
    public int getMaxQp() {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_NOT_IMPLEMENTED");
        }
        return -10;
    }

    @Override
    public int setLTRBufferControl(int numLTR, boolean doNotTrust) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_NOT_IMPLEMENTED");
        }
        return -10;
    }

    @Override
    public int markLTRFrame(int longTermFrameIdx) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            ((AbstractVideoEncoder)this.encoder).markLtrFrame(longTermFrameIdx);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (AbstractVideoEncoder.APINotImplementedException e) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", e.getFailedApiName() + "(" + e.toString() + ")");
            }
            return -10;
        }
    }

    @Override
    public int useLTRFrame(int useLTRFrameIdxBitMap, boolean constrainedMode) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            ((AbstractVideoEncoder)this.encoder).useLTRFrame(useLTRFrameIdxBitMap);
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
            }
            return 0;
        }
        catch (AbstractVideoEncoder.APINotImplementedException e) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", e.getFailedApiName() + "(" + e.toString() + ")");
            }
            return -10;
        }
    }

    @Override
    public int enhanceROI(int left, int top, int right, int bottom, int deltaQP) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() failed: SLIQ_ERROR_NOT_IMPLEMENTED");
        }
        return -10;
    }

    @Override
    public int hintRcFrameRate(float inputFps, float targetFps) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() called");
        }
        try {
            SurfaceObserver surfaceObserver;
            ((AbstractVideoEncoder)this.encoder).setRcFrameRate(inputFps);
            SurfaceObserver surfaceObserver2 = surfaceObserver = this.weakRefSurfaceObserver != null ? (SurfaceObserver)this.weakRefSurfaceObserver.get() : null;
            if (surfaceObserver != null) {
                if (Log.isLoggable("SLIQ", 3)) {
                    Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() set targetFps to " + targetFps);
                }
                surfaceObserver.setTargetFrameRate(targetFps);
                if (Log.isLoggable("SLIQ", 3)) {
                    Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + "() succeeded");
                }
            }
            return 0;
        }
        catch (AbstractVideoEncoder.APINotImplementedException e) {
            if (Log.isLoggable("SLIQ", 4)) {
                Log.i("SLIQ", e.getFailedApiName() + "(" + e.toString() + ")");
            }
            return -10;
        }
    }

    protected int getRawFrameSize() {
        return this.rawFrameSize;
    }

    protected long getInitialTimestamp() {
        return this.initialTimestamp;
    }

    protected Encoder getEncoder() {
        return this.encoder;
    }

    private static VideoFormat getVideoFormatFromAttributes(EncoderAttributes attributes) throws EncoderAttributes.AttributeException {
        int bitrate;
        int width = attributes.getInteger("width");
        if (width <= 0) {
            throw new EncoderAttributes.AttributeException("width is illegal: " + width);
        }
        int height = attributes.getInteger("height");
        if (height <= 0) {
            throw new EncoderAttributes.AttributeException("height is illegal: " + width);
        }
        int orgwidth = attributes.getInteger("org-width", 0);
        int orgheight = attributes.getInteger("org-height", 0);
        int hrd_max_rate = attributes.getInteger("hrd-max-rate", 0);
        int n = bitrate = hrd_max_rate > 0 ? hrd_max_rate : attributes.getInteger("bitrate");
        if (bitrate > 2147483 || bitrate < 0) {
            throw new EncoderAttributes.AttributeException("bitrate out of range: " + bitrate);
        }
        int rcMode = attributes.getInteger("android-rc-mode", 2);
        VideoFormat format = new VideoFormat();
        format.setResolution(new Resolution(width, height));
        format.setOrgResolution(new Resolution(orgwidth, orgheight));
        format.setBitrate(1000 * bitrate);
        format.setColorFormat(ColorFormat.fromSliq(attributes.getInteger("color-space-format")));
        format.setProfile(H264Profile.valueOf(attributes.getString("h264-profile", DEFAULT_H264_PROFILE.getName()).toUpperCase(Locale.ROOT)));
        format.setLevel(H264Level.fromName(attributes.getString("h264-level-idc", DEFAULT_H264_LEVEL.getName())));
        format.setFrameRate((int)attributes.getFloat("fps", 30.0));
        format.setiFrameInterval(420);
        format.setRCMode(RateControlMode.values()[rcMode]);
        format.setRefCount(attributes.getInteger("ref-count", 1));
        format.setNumLayers(attributes.getInteger("num-channels", 1));
        format.setBaseLayerPriorityId(attributes.getInteger("base-priority-id", 0));
        format.setMinNumSlices(attributes.getInteger("min-num-slices", 1));
        format.setSvcAlways(attributes.getInteger("mlvec-svc", 0) != 0);
        return format;
    }

    private static void passCapabilitiesToNative(long capabilitiesNativeObj, Capabilities capabilities) {
        MediaFormat extCaps;
        int[] profiles = new int[capabilities.getProfiles().size()];
        int i = 0;
        for (H264Profile h264Profile : capabilities.getProfiles()) {
            profiles[i++] = h264Profile.getSliqValue();
        }
        int maxLevel = -1;
        for (H264Level h264Level : capabilities.getLevels()) {
            maxLevel = Math.max(maxLevel, h264Level.getSliqValue());
        }
        int[] nArray = new int[capabilities.getColorFormats().size()];
        i = 0;
        for (ColorFormat cf : capabilities.getColorFormats()) {
            nArray[i++] = cf.getSliqValue();
        }
        Buffer buffer = null;
        long driverVersion = 0L;
        boolean driverVersionIsValid = false;
        int minBitrate = null != capabilities.getBitrateRange() ? (Integer)capabilities.getBitrateRange().getLower() : 0;
        int maxBitrate = null != capabilities.getBitrateRange() ? (Integer)capabilities.getBitrateRange().getUpper() : 0;
        int minWidth = null != capabilities.getWidthRange() ? (Integer)capabilities.getWidthRange().getLower() : 0;
        int maxWidth = null != capabilities.getWidthRange() ? (Integer)capabilities.getWidthRange().getUpper() : 0;
        int minHeight = null != capabilities.getHeightRange() ? (Integer)capabilities.getHeightRange().getLower() : 0;
        int maxHeight = null != capabilities.getHeightRange() ? (Integer)capabilities.getHeightRange().getUpper() : 0;
        boolean fullQcExtensionSupport = false;
        int qcMaxNumLtr = 0;
        boolean qpControlSupport = false;
        String codecCertifiedVersion = null;
        boolean isCodecCertified = false;
        if (capabilities.isQCExtensionSupported()) {
            extCaps = capabilities.getExtCapabilities();
            Integer ver = extCaps.getString("vt-version") == null ? 0 : 1;
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", "getExtCapabilities: " + (extCaps == null ? "null" : extCaps));
                if (extCaps != null) {
                    Log.d("SLIQ", "!!!!!!!!!!!!!!");
                    Log.d("SLIQ", "getVersion() =>                     " + extCaps.getString("vt-version"));
                    Log.d("SLIQ", "isLowLatencySupported() =>          " + extCaps.getString("vt-low-latency"));
                    Log.d("SLIQ", "getMaxInstances() =>                " + extCaps.getString("vt-max-instances"));
                    Log.d("SLIQ", "getMaxTemporalLayerCount() =>       " + extCaps.getString("vt-max-temporal-layer-count"));
                    Log.d("SLIQ", "getMaxRefFrames() =>                " + extCaps.getString("vt-max-ref-frames"));
                    Log.d("SLIQ", "getMaxLTRFrames() =>                " + extCaps.getString("vt-max-ltr-frames"));
                    Log.d("SLIQ", "getMaxLevel() =>                    " + extCaps.getString("vt-max-level"));
                    Log.d("SLIQ", "getSliceControlModesBM() =>         " + extCaps.getString("vt-slice-control-modes-bitmask"));
                    Log.d("SLIQ", "getMaxMacroblockProcessingRate() => " + extCaps.getString("vt-max-macroblock-processing-rate"));
                    Log.d("SLIQ", "getSupportedDownScaleFactor() =>    " + extCaps.getString("vt-down-scale-factor"));
                    Log.d("SLIQ", "getMinScaleFactor() =>              " + extCaps.getString("vt-min-scale-factor"));
                }
            }
            qcMaxNumLtr = Integer.valueOf(extCaps.getString("vt-max-ltr-frames"));
            driverVersion = ver != null ? (long)ver.intValue() : 0L;
            driverVersionIsValid = ver != null;
            fullQcExtensionSupport = true;
        }
        if (capabilities.isQCAfterNougatExtensionsSupported()) {
            extCaps = capabilities.getExtCapabilities();
            if (Log.isLoggable("SLIQ", 3)) {
                Log.d("SLIQ", "getExtCapabilities: " + (extCaps == null ? "null" : extCaps));
            }
            if (extCaps != null) {
                driverVersion = extCaps.getInteger(capabilities.getExtPrefix() + "-ext-enc-caps-vt-driver-version.number");
                qcMaxNumLtr = extCaps.getInteger(capabilities.getExtPrefix() + "-ext-enc-caps-ltr.max-count");
                codecCertifiedVersion = extCaps.getString(capabilities.getExtPrefix() + "-ext-enc-caps-vt-certified-version.number");
                if (Log.isLoggable("SLIQ", 4)) {
                    Log.i("SLIQ", "[Ext] driver version: " + driverVersion);
                    Log.i("SLIQ", "[Ext] maxnums of ltr frame: " + qcMaxNumLtr);
                    Log.i("SLIQ", "[Ext] encoder certified version: " + codecCertifiedVersion);
                }
                driverVersionIsValid = driverVersion != 0L;
                fullQcExtensionSupport = true;
                isCodecCertified = codecCertifiedVersion != null && Pattern.matches("^\\d+\\.\\d+\\.\\d{4}\\.R\\d+", codecCertifiedVersion);
            }
        }
        JniCodecUtils.returnCapabilitiesBuffer(capabilitiesNativeObj, capabilities.getCodecName(), profiles, maxLevel, nArray, buffer, driverVersion, driverVersionIsValid, 1, minWidth, maxWidth, minHeight, maxHeight, minBitrate, maxBitrate, fullQcExtensionSupport, qcMaxNumLtr, qpControlSupport, isCodecCertified);
    }

    private static native void bitstreamReady(long var0, boolean var2, ByteBuffer var3, int var4, int var5, long var6, boolean var8, boolean var9, boolean var10);
}

