/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.format;

import com.skype.android.video.hw.format.FormatMapper;
import com.skype.android.video.hw.format.SliqOmxMapping;

public enum ColorFormat implements SliqOmxMapping<Integer, Integer>
{
    I420("I420", 19, 12),
    NV12("NV12", 21, 12),
    YUY2("YUY2", 25, 16),
    UYVY("UYVY", 27, 16),
    YVYU("YVYU", 26, 16),
    OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar32m(2141391876, 2141391876, 0),
    Android_COLOR_FormatYUV420Flexible(2135033992, 2135033992, 0),
    SURFACE(2130708361, 2130708361, 32);

    private final String name;
    private final int bitsPerPixel;
    private final int sliqValue;
    private final int omxValue;
    private static FormatMapper<Integer, Integer, ColorFormat> mapper;

    private ColorFormat(int fourcc, int omxValue, int bitsPerPixel) {
        this.name = "0x" + Integer.toHexString(fourcc);
        this.bitsPerPixel = bitsPerPixel;
        this.sliqValue = fourcc;
        this.omxValue = omxValue;
    }

    private ColorFormat(String name, int omxValue, int bitsPerPixel) {
        this.name = name;
        this.bitsPerPixel = bitsPerPixel;
        this.sliqValue = ColorFormat.fourcc(name);
        this.omxValue = omxValue;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getSliqValue() {
        return this.sliqValue;
    }

    @Override
    public Integer getOmxValue() {
        return this.omxValue;
    }

    public static ColorFormat fromSliq(int value) {
        return ColorFormat.getMapper().fromSliq(value);
    }

    public static ColorFormat fromOmx(int value) {
        return ColorFormat.getMapper().fromOmx(value);
    }

    public static ColorFormat fromName(String name) {
        return ColorFormat.getMapper().fromName(name);
    }

    private static synchronized FormatMapper<Integer, Integer, ColorFormat> getMapper() {
        if (mapper == null) {
            mapper = new FormatMapper((Enum[])ColorFormat.values());
        }
        return mapper;
    }

    private static int fourcc(CharSequence s) {
        if (s.length() != 4) {
            throw new IllegalArgumentException("four chars expected");
        }
        int n = 0;
        for (int i = 3; i >= 0; --i) {
            n = n << 8 | s.charAt(i) & 0xFF;
        }
        return n;
    }
}

