/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.format;

import com.skype.android.video.hw.format.FormatMapper;
import com.skype.android.video.hw.format.SliqOmxMapping;

public enum H264Profile implements SliqOmxMapping<Integer, Integer>
{
    CONSTRAINEDBASELINE("constrainedbaseline", 65536, 0),
    BASELINE("baseline", 1, 1),
    EXTENDEND("extended", 4, 2),
    MAIN("main", 2, 3),
    CONSTRAINEDHIGH("constrainedhigh", 524288, 4),
    HIGH("high", 8, 6),
    HIGH10("high10", 16, 8),
    HIGH422("high422", 32, 10),
    HIGH444("high444", 64, 13);

    private final String name;
    private final int omxValue;
    private final int sliqValue;
    private static FormatMapper<Integer, Integer, H264Profile> mapper;

    private H264Profile(String name, int omxValue, int sliqValue) {
        this.name = name;
        this.omxValue = omxValue;
        this.sliqValue = sliqValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getOmxValue() {
        return this.omxValue;
    }

    @Override
    public Integer getSliqValue() {
        return this.sliqValue;
    }

    public static H264Profile fromSliq(int value) {
        return H264Profile.getMapper().fromSliq(value);
    }

    public static H264Profile fromOmx(int value) {
        return H264Profile.getMapper().fromOmx(value);
    }

    public static H264Profile fromName(String name) {
        return H264Profile.getMapper().fromName(name);
    }

    private static synchronized FormatMapper<Integer, Integer, H264Profile> getMapper() {
        if (mapper == null) {
            mapper = new FormatMapper((Enum[])H264Profile.values());
        }
        return mapper;
    }
}

