/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.frame;

import android.util.Log;
import java.io.Closeable;
import java.nio.ByteBuffer;

public class OutputFrame
implements Closeable {
    private final FrameEvents frameEventsHandler;
    private final FrameBufferQueue queue = new FrameBufferQueue();
    private boolean isOpen = false;
    private long timestamp;
    private boolean isTimedOut;
    private boolean isOutputFormatChanged;
    private boolean isEndOfStream;
    private boolean isCodecConfig;
    private long nativeBufferLockObj;
    private static String simpleClassName = OutputFrame.class.getSimpleName();

    OutputFrame(FrameEvents frameEventsHandler, long nativeBufferLockObj) {
        this.frameEventsHandler = frameEventsHandler;
        this.nativeBufferLockObj = nativeBufferLockObj;
    }

    public long getNativeLockingObj() {
        return this.nativeBufferLockObj;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }

    public void setTimedOut(boolean isTimedOut) {
        this.isTimedOut = isTimedOut;
    }

    public boolean isOutputFormatChanged() {
        return this.isOutputFormatChanged;
    }

    public void setOutputFormatChanged(boolean isOutputFormatChanged) {
        this.isOutputFormatChanged = isOutputFormatChanged;
    }

    public boolean isCodecConfig() {
        return this.isCodecConfig;
    }

    public void setCodecConfig(boolean isCodecConfig) {
        this.isCodecConfig = isCodecConfig;
    }

    public boolean isEndOfStream() {
        return this.isEndOfStream;
    }

    public void setEndOfStream(boolean isEndOfStream) {
        this.isEndOfStream = isEndOfStream;
    }

    public boolean hasBuffers() {
        return !this.queue.isEmpty();
    }

    public void pushBuffer(int id, ByteBuffer data, int offset, int size) {
        this.queue.push(id, data, offset, size);
    }

    public FrameBuffer popBuffer() {
        return this.queue.pop();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void open() {
        if (this.isOpen) {
            throw new IllegalStateException("not closed");
        }
        this.isOpen = true;
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            throw new IllegalStateException("already closed");
        }
        while (!this.queue.isEmpty()) {
            FrameBuffer buf = this.queue.pop();
            if (Log.isLoggable((String)"SLIQ", (int)5)) {
                Log.w((String)"SLIQ", (String)(simpleClassName + ": A buffer was not closed: " + buf));
            }
            buf.close();
        }
        this.frameEventsHandler.onFrameReleased(this);
        this.isOpen = false;
        this.timestamp = 0L;
        this.isTimedOut = false;
        this.isOutputFormatChanged = false;
        this.isCodecConfig = false;
        this.isEndOfStream = false;
    }

    public String toString() {
        return simpleClassName + " [isOpen=" + this.isOpen + ", timestamp=" + this.timestamp + ", queue=" + this.queue + "]";
    }

    private class FrameBufferQueue {
        private FrameBuffer[] buffers;
        private int headIndex;
        private int tailIndex;
        private int size;

        public FrameBufferQueue() {
            this.allocate(1);
        }

        public void push(int id, ByteBuffer data, int dataOffset, int dataSize) {
            if (this.size == this.buffers.length) {
                this.allocate(this.buffers.length * 2);
            }
            this.buffers[this.tailIndex].assign(id, data, dataOffset, dataSize);
            this.tailIndex = this.advance(this.tailIndex);
            ++this.size;
        }

        public FrameBuffer pop() {
            if (this.isEmpty()) {
                return null;
            }
            FrameBuffer buf = this.buffers[this.headIndex];
            this.headIndex = this.advance(this.headIndex);
            --this.size;
            return buf;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        private int advance(int pos) {
            if (++pos == this.buffers.length) {
                pos = 0;
            }
            return pos;
        }

        private void allocate(int capacity) {
            if (capacity <= this.size) {
                throw new IllegalArgumentException("capacity must be greater than actual size");
            }
            if (Log.isLoggable((String)"SLIQ", (int)3)) {
                Log.d((String)"SLIQ", (String)(simpleClassName + ": Allocating space for " + capacity + " frames, current size: " + this.size));
            }
            FrameBuffer[] newBuffers = new FrameBuffer[capacity];
            int i = this.headIndex;
            for (int j = 0; j < this.size; ++j) {
                newBuffers[j] = this.buffers[i];
                i = this.advance(i);
            }
            for (int j = this.size; j < capacity; ++j) {
                newBuffers[j] = new FrameBuffer();
            }
            this.buffers = newBuffers;
            this.headIndex = 0;
            this.tailIndex = this.size;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(simpleClassName);
            str.append(" [");
            int i = this.headIndex;
            int j = 0;
            while (j < this.size) {
                str.append(this.buffers[i].toString());
                i = this.advance(i);
            }
            str.append("]");
            return str.toString();
        }
    }

    public class FrameBuffer
    implements Closeable {
        private int id = -1;
        private ByteBuffer data;
        private int offset = -1;
        private int size = -1;

        void assign(int id, ByteBuffer data, int offset, int size) {
            if (this.id >= 0) {
                throw new IllegalStateException("not closed");
            }
            this.id = id;
            this.data = data;
            this.offset = offset;
            this.size = size;
        }

        public ByteBuffer getData() {
            return this.data;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getSize() {
            return this.size;
        }

        public int getId() {
            return this.id;
        }

        public void releaseFrameBuffer() {
            OutputFrame.this.frameEventsHandler.onBufferReleased(this.id);
        }

        @Override
        public void close() {
            if (this.id < 0) {
                throw new IllegalStateException("closed");
            }
            this.id = -1;
            this.data = null;
            this.offset = -1;
            this.size = -1;
        }

        public String toString() {
            return simpleClassName + " [id=" + this.id + ", size=" + this.size + "]";
        }
    }

    public static interface FrameEvents {
        public void onBufferReleased(int var1);

        public void onFrameReleased(OutputFrame var1);
    }
}

