/*
 * Decompiled with CFR 0.152.
 */
package com.skype.android.video.hw.frame;

import android.media.MediaCodec;
import com.skype.android.video.hw.frame.OutputFrame;
import com.skype.android.video.hw.utils.DebugUtils;
import com.skype.android.video.hw.utils.Log;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class OutputFramePool
implements Closeable {
    private final WeakReference<MediaCodec> weakMediaCodec;
    private final Queue<OutputFrame> frames;
    private long nativeObj = this.createNativeObj(this);
    private boolean reconfig = false;
    private boolean isTextureDecoder = false;
    private final String simpleClassName = this.getClass().getSimpleName();
    private final OutputFrame.FrameEvents frameEventsHandler = new OutputFrame.FrameEvents(){

        @Override
        public void onFrameReleased(OutputFrame frame) {
            if (!OutputFramePool.this.frames.add(frame)) {
                throw new IllegalStateException("frame pool is full");
            }
        }

        @Override
        public void onBufferReleased(int id) {
            MediaCodec mediaCodec = (MediaCodec)OutputFramePool.this.weakMediaCodec.get();
            if (mediaCodec != null) {
                try {
                    mediaCodec.releaseOutputBuffer(id, OutputFramePool.this.isTextureDecoder);
                }
                catch (Exception e) {
                    Log.e("SLIQ", OutputFramePool.this.simpleClassName + '#' + DebugUtils.getMethodName() + " ReleaseBuffer " + id + "failed with info " + e);
                }
            }
        }
    };

    private native long createNativeObj(OutputFramePool var1);

    private native void deleteNativeObj(long var1);

    public void setReconfigFlag(boolean rec) {
        this.reconfig = rec;
    }

    public void setDecoderType(boolean type) {
        this.isTextureDecoder = type;
    }

    public OutputFramePool(int poolSize, MediaCodec mediaCodec) {
        this.weakMediaCodec = new WeakReference<MediaCodec>(mediaCodec);
        this.frames = new ArrayBlockingQueue<OutputFrame>(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            this.frames.add(new OutputFrame(this.frameEventsHandler, this.nativeObj));
        }
    }

    public OutputFrame poll() {
        OutputFrame frame = this.frames.poll();
        if (frame != null) {
            frame.open();
        }
        return frame;
    }

    public int releaseBuffer(int id) {
        if (Log.isLoggable("SLIQ", 3)) {
            Log.d("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + " ReleaseBuffer " + id);
        }
        if (this.reconfig) {
            this.reconfig = false;
        } else {
            MediaCodec mediaCodec = (MediaCodec)this.weakMediaCodec.get();
            if (mediaCodec != null) {
                try {
                    mediaCodec.releaseOutputBuffer(id, this.isTextureDecoder);
                }
                catch (Exception e) {
                    Log.e("SLIQ", this.simpleClassName + '#' + DebugUtils.getMethodName() + " ReleaseBuffer " + id + "failed with info " + e);
                    return -1;
                }
            }
        }
        return 0;
    }

    public String toString() {
        return this.simpleClassName + " [frames=" + this.frames + "]";
    }

    @Override
    public void close() throws IOException {
        this.deleteNativeObj(this.nativeObj);
    }
}

