/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat;

import android.content.Context;
import com.azure.android.communication.chat.ChatThreadAsyncClient;
import com.azure.android.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.android.communication.chat.implementation.CFBackedPageAsyncStream;
import com.azure.android.communication.chat.implementation.ChatImpl;
import com.azure.android.communication.chat.implementation.converters.CommunicationErrorResponseExceptionConverter;
import com.azure.android.communication.chat.implementation.converters.CreateChatThreadOptionsConverter;
import com.azure.android.communication.chat.implementation.converters.CreateChatThreadResultConverter;
import com.azure.android.communication.chat.implementation.models.CreateChatThreadResult;
import com.azure.android.communication.chat.implementation.notifications.fcm.PushNotificationClient;
import com.azure.android.communication.chat.implementation.notifications.signaling.CommunicationSignalingClient;
import com.azure.android.communication.chat.implementation.notifications.signaling.SignalingClient;
import com.azure.android.communication.chat.models.ChatEvent;
import com.azure.android.communication.chat.models.ChatEventType;
import com.azure.android.communication.chat.models.ChatPushNotification;
import com.azure.android.communication.chat.models.ChatThreadItem;
import com.azure.android.communication.chat.models.CreateChatThreadOptions;
import com.azure.android.communication.chat.models.ListChatThreadsOptions;
import com.azure.android.communication.chat.models.RealTimeNotificationCallback;
import com.azure.android.communication.common.CommunicationTokenCredential;
import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.rest.Response;
import com.azure.android.core.rest.SimpleResponse;
import com.azure.android.core.rest.util.paging.PagedAsyncStream;
import com.azure.android.core.rest.util.paging.PagedResponse;
import com.azure.android.core.util.Function;
import com.azure.android.core.util.Predicate;
import com.azure.android.core.util.RequestContext;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Consumer;

public final class ChatAsyncClient {
    private final ClientLogger logger = new ClientLogger(ChatAsyncClient.class);
    private final AzureCommunicationChatServiceImpl chatServiceClient;
    private final SignalingClient signalingClient;
    private final PushNotificationClient pushNotificationClient;
    private final ChatImpl chatClient;

    ChatAsyncClient(AzureCommunicationChatServiceImpl chatServiceClient, CommunicationTokenCredential communicationTokenCredential) {
        this.chatServiceClient = chatServiceClient;
        this.signalingClient = new CommunicationSignalingClient(communicationTokenCredential, chatServiceClient.getEndpoint(), chatServiceClient.getHttpPipeline());
        this.chatClient = chatServiceClient.getChatClient();
        this.pushNotificationClient = new PushNotificationClient(communicationTokenCredential);
    }

    public ChatThreadAsyncClient getChatThreadClient(String chatThreadId) {
        if (chatThreadId == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'chatThreadId' cannot be null."));
        }
        return new ChatThreadAsyncClient(this.chatServiceClient, chatThreadId);
    }

    public CompletableFuture<com.azure.android.communication.chat.models.CreateChatThreadResult> createChatThread(CreateChatThreadOptions options) {
        if (options == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'options' cannot be null."));
        }
        return this.createChatThread(options, null).thenApply(response -> (com.azure.android.communication.chat.models.CreateChatThreadResult)response.getValue());
    }

    public CompletableFuture<Response<com.azure.android.communication.chat.models.CreateChatThreadResult>> createChatThreadWithResponse(CreateChatThreadOptions options, RequestContext requestContext) {
        if (options == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'options' cannot be null."));
        }
        return this.createChatThread(options, requestContext);
    }

    CompletableFuture<Response<com.azure.android.communication.chat.models.CreateChatThreadResult>> createChatThread(CreateChatThreadOptions options, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatClient.createChatThreadWithResponseAsync(CreateChatThreadOptionsConverter.convert(options, this.logger), options.getIdempotencyToken(), requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(result -> new SimpleResponse(result, (Object)CreateChatThreadResultConverter.convert((CreateChatThreadResult)result.getValue(), this.logger)));
    }

    public PagedAsyncStream<ChatThreadItem> listChatThreads() {
        return this.listChatThreads(new ListChatThreadsOptions(), RequestContext.NONE);
    }

    public PagedAsyncStream<ChatThreadItem> listChatThreads(ListChatThreadsOptions listThreadsOptions, RequestContext requestContext) {
        Function pageRetriever = pageId -> {
            if (pageId == null) {
                return this.getChatThreadsFirstPage(listThreadsOptions, requestContext);
            }
            return this.getChatThreadsNextPage((String)pageId, requestContext);
        };
        Function streamRetriever = pageId -> new CFBackedPageAsyncStream(pageRetriever, (Predicate<String>)((Predicate)id -> id != null), (String)pageId, this.logger);
        return new PagedAsyncStream(streamRetriever, this.logger);
    }

    CompletableFuture<PagedResponse<ChatThreadItem>> getChatThreadsFirstPage(ListChatThreadsOptions listThreadsOptions, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatClient.listChatThreadsSinglePageAsync(listThreadsOptions.getMaxPageSize(), listThreadsOptions.getStartTime(), requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        });
    }

    CompletableFuture<PagedResponse<ChatThreadItem>> getChatThreadsNextPage(String nextLink, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatClient.listChatThreadsNextSinglePageAsync(nextLink, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        });
    }

    public CompletableFuture<Void> deleteChatThread(String chatThreadId) {
        if (chatThreadId == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'chatThreadId' cannot be null."));
        }
        return this.deleteChatThread(chatThreadId, null).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Response<Void>> deleteChatThreadWithResponse(String chatThreadId, RequestContext requestContext) {
        if (chatThreadId == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'chatThreadId' cannot be null."));
        }
        return this.deleteChatThread(chatThreadId, requestContext);
    }

    CompletableFuture<Response<Void>> deleteChatThread(String chatThreadId, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatClient.deleteChatThreadWithResponseAsync(chatThreadId, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        });
    }

    public void startRealtimeNotifications(Context context, Consumer<Throwable> errorHandler) {
        if (this.signalingClient.hasStarted()) {
            return;
        }
        this.signalingClient.start(context, errorHandler);
    }

    @Deprecated
    public void startRealtimeNotifications(String skypeUserToken, Context context) {
        if (this.signalingClient.hasStarted()) {
            return;
        }
        this.signalingClient.start(skypeUserToken, context);
    }

    public void stopRealtimeNotifications() {
        this.signalingClient.stop();
    }

    @Deprecated
    public void startPushNotifications(String deviceRegistrationToken, Consumer<Throwable> errorHandler) {
        if (this.pushNotificationClient.hasStarted()) {
            return;
        }
        this.pushNotificationClient.startPushNotifications(deviceRegistrationToken, errorHandler);
    }

    public void startPushNotifications(String deviceRegistrationToken) {
        if (this.pushNotificationClient.hasStarted()) {
            return;
        }
        this.pushNotificationClient.startPushNotifications(deviceRegistrationToken);
    }

    public void stopPushNotifications() {
        this.pushNotificationClient.stopPushNotifications();
    }

    public boolean handlePushNotification(ChatPushNotification pushNotification) {
        return this.pushNotificationClient.handlePushNotification(pushNotification);
    }

    public void addPushNotificationHandler(ChatEventType chatEventType, Consumer<ChatEvent> listener) {
        if (!this.pushNotificationClient.hasStarted()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("You must call startPushNotifications(String) before you can subscribe to push notifications."));
        }
        this.pushNotificationClient.addPushNotificationHandler(chatEventType, listener);
    }

    public void removePushNotificationHandler(ChatEventType chatEventType, Consumer<ChatEvent> listener) {
        this.pushNotificationClient.removePushNotificationHandler(chatEventType, listener);
    }

    public void addEventHandler(ChatEventType chatEventType, RealTimeNotificationCallback listener) {
        if (!this.signalingClient.hasStarted()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("You must call startRealtimeNotifications(Context) before you can subscribe to events."));
        }
        this.signalingClient.on(chatEventType, listener);
    }

    public void removeEventHandler(ChatEventType chatEventType, RealTimeNotificationCallback listener) {
        this.signalingClient.off(chatEventType, listener);
    }
}

