/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat;

import android.content.Context;
import com.azure.android.communication.chat.ChatAsyncClient;
import com.azure.android.communication.chat.ChatThreadAsyncClient;
import com.azure.android.communication.chat.ChatThreadClient;
import com.azure.android.communication.chat.models.ChatEvent;
import com.azure.android.communication.chat.models.ChatEventType;
import com.azure.android.communication.chat.models.ChatPushNotification;
import com.azure.android.communication.chat.models.ChatThreadItem;
import com.azure.android.communication.chat.models.CreateChatThreadOptions;
import com.azure.android.communication.chat.models.CreateChatThreadResult;
import com.azure.android.communication.chat.models.ListChatThreadsOptions;
import com.azure.android.communication.chat.models.RealTimeNotificationCallback;
import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.rest.Response;
import com.azure.android.core.rest.SimpleResponse;
import com.azure.android.core.rest.util.paging.PagedIterable;
import com.azure.android.core.rest.util.paging.PagedResponse;
import com.azure.android.core.util.Function;
import com.azure.android.core.util.RequestContext;
import java.util.concurrent.ExecutionException;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Consumer;

public final class ChatClient {
    private final ClientLogger logger = new ClientLogger(ChatClient.class);
    private final ChatAsyncClient client;

    ChatClient(ChatAsyncClient client) {
        this.client = client;
    }

    public ChatThreadClient getChatThreadClient(String chatThreadId) {
        ChatThreadAsyncClient chatThreadAsyncClient = this.client.getChatThreadClient(chatThreadId);
        return new ChatThreadClient(chatThreadAsyncClient);
    }

    public CreateChatThreadResult createChatThread(CreateChatThreadOptions options) {
        return this.block(this.client.createChatThread(options));
    }

    public Response<CreateChatThreadResult> createChatThreadWithResponse(CreateChatThreadOptions options, RequestContext requestContext) {
        return (Response)this.block(this.client.createChatThread(options, requestContext).thenApply(result -> new SimpleResponse(result, (Object)((CreateChatThreadResult)result.getValue()))));
    }

    public void deleteChatThread(String chatThreadId) {
        this.block(this.client.deleteChatThread(chatThreadId));
    }

    public Response<Void> deleteChatThreadWithResponse(String chatThreadId, RequestContext requestContext) {
        return this.block(this.client.deleteChatThread(chatThreadId, requestContext));
    }

    public PagedIterable<ChatThreadItem> listChatThreads() {
        return this.listChatThreads(new ListChatThreadsOptions(), RequestContext.NONE);
    }

    public PagedIterable<ChatThreadItem> listChatThreads(ListChatThreadsOptions listThreadsOptions, RequestContext requestContext) {
        Function pageRetriever = pageId -> {
            if (pageId == null) {
                return this.getChatThreadsFirstPageWithResponse(listThreadsOptions, requestContext);
            }
            return this.getChatThreadsNextPageWithResponse((String)pageId, requestContext);
        };
        return new PagedIterable(pageRetriever, pageId -> pageId != null, this.logger);
    }

    private PagedResponse<ChatThreadItem> getChatThreadsFirstPageWithResponse(ListChatThreadsOptions listThreadsOptions, RequestContext requestContext) {
        return this.block(this.client.getChatThreadsFirstPage(listThreadsOptions, requestContext));
    }

    private PagedResponse<ChatThreadItem> getChatThreadsNextPageWithResponse(String nextLink, RequestContext requestContext) {
        return this.block(this.client.getChatThreadsNextPage(nextLink, requestContext));
    }

    public void startRealtimeNotifications(Context context, Consumer<Throwable> errorHandler) {
        this.client.startRealtimeNotifications(context, errorHandler);
    }

    @Deprecated
    public void startRealtimeNotifications(String skypeUserToken, Context context) {
        this.client.startRealtimeNotifications(skypeUserToken, context);
    }

    public void stopRealtimeNotifications() {
        this.client.stopRealtimeNotifications();
    }

    @Deprecated
    public void startPushNotifications(String deviceRegistrationToken, Consumer<Throwable> errorHandler) {
        this.client.startPushNotifications(deviceRegistrationToken, errorHandler);
    }

    public void startPushNotifications(String deviceRegistrationToken) {
        this.client.startPushNotifications(deviceRegistrationToken);
    }

    public void stopPushNotifications() {
        this.client.stopPushNotifications();
    }

    public boolean handlePushNotification(ChatPushNotification pushNotification) {
        return this.client.handlePushNotification(pushNotification);
    }

    public void addPushNotificationHandler(ChatEventType chatEventType, Consumer<ChatEvent> listener) {
        this.client.addPushNotificationHandler(chatEventType, listener);
    }

    public void removePushNotificationHandler(ChatEventType chatEventType, Consumer<ChatEvent> listener) {
        this.client.removePushNotificationHandler(chatEventType, listener);
    }

    public void addEventHandler(ChatEventType chatEventType, RealTimeNotificationCallback listener) {
        this.client.addEventHandler(chatEventType, listener);
    }

    public void removeEventHandler(ChatEventType chatEventType, RealTimeNotificationCallback listener) {
        this.client.removeEventHandler(chatEventType, listener);
    }

    private <T> T block(CompletableFuture<T> completableFuture) {
        try {
            return (T)completableFuture.get();
        }
        catch (InterruptedException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        catch (ExecutionException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }
}

