/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat;

import com.azure.android.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.android.communication.chat.implementation.CFBackedPageAsyncStream;
import com.azure.android.communication.chat.implementation.ChatThreadImpl;
import com.azure.android.communication.chat.implementation.converters.AddChatParticipantsOptionsConverter;
import com.azure.android.communication.chat.implementation.converters.AddChatParticipantsResultConverter;
import com.azure.android.communication.chat.implementation.converters.ChatMessageConverter;
import com.azure.android.communication.chat.implementation.converters.ChatMessageReadReceiptConverter;
import com.azure.android.communication.chat.implementation.converters.ChatParticipantConverter;
import com.azure.android.communication.chat.implementation.converters.ChatThreadPropertiesConverter;
import com.azure.android.communication.chat.implementation.converters.CommunicationErrorResponseExceptionConverter;
import com.azure.android.communication.chat.implementation.converters.CommunicationIdentifierConverter;
import com.azure.android.communication.chat.implementation.models.AddChatParticipantsResult;
import com.azure.android.communication.chat.implementation.models.ChatThreadProperties;
import com.azure.android.communication.chat.implementation.models.SendReadReceiptRequest;
import com.azure.android.communication.chat.models.ChatError;
import com.azure.android.communication.chat.models.ChatMessage;
import com.azure.android.communication.chat.models.ChatMessageReadReceipt;
import com.azure.android.communication.chat.models.ChatParticipant;
import com.azure.android.communication.chat.models.InvalidParticipantException;
import com.azure.android.communication.chat.models.ListChatMessagesOptions;
import com.azure.android.communication.chat.models.ListParticipantsOptions;
import com.azure.android.communication.chat.models.ListReadReceiptOptions;
import com.azure.android.communication.chat.models.SendChatMessageOptions;
import com.azure.android.communication.chat.models.SendChatMessageResult;
import com.azure.android.communication.chat.models.TypingNotificationOptions;
import com.azure.android.communication.chat.models.UpdateChatMessageOptions;
import com.azure.android.communication.chat.models.UpdateChatThreadOptions;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.rest.Response;
import com.azure.android.core.rest.SimpleResponse;
import com.azure.android.core.rest.util.paging.PagedAsyncStream;
import com.azure.android.core.rest.util.paging.PagedResponse;
import com.azure.android.core.rest.util.paging.PagedResponseBase;
import com.azure.android.core.util.Function;
import com.azure.android.core.util.Predicate;
import com.azure.android.core.util.RequestContext;
import java.util.ArrayList;
import java.util.Collections;
import java9.util.concurrent.CompletableFuture;

public final class ChatThreadAsyncClient {
    private final ClientLogger logger = new ClientLogger(ChatThreadAsyncClient.class);
    private final ChatThreadImpl chatThreadClient;
    private final String chatThreadId;

    ChatThreadAsyncClient(AzureCommunicationChatServiceImpl chatServiceClient, String chatThreadId) {
        this.chatThreadClient = chatServiceClient.getChatThreadClient();
        this.chatThreadId = chatThreadId;
    }

    public String getChatThreadId() {
        return this.chatThreadId;
    }

    public CompletableFuture<Void> updateTopic(String topic) {
        if (topic == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'topic' cannot be null."));
        }
        return this.updateTopic(topic, null).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Response<Void>> updateTopicWithResponse(String topic, RequestContext requestContext) {
        if (topic == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'topic' cannot be null."));
        }
        return this.updateTopic(topic, requestContext);
    }

    public CompletableFuture<com.azure.android.communication.chat.models.ChatThreadProperties> getProperties() {
        return this.getProperties(null).thenApply(response -> (com.azure.android.communication.chat.models.ChatThreadProperties)response.getValue());
    }

    public CompletableFuture<Response<com.azure.android.communication.chat.models.ChatThreadProperties>> getPropertiesWithResponse(RequestContext requestContext) {
        return this.getProperties(requestContext);
    }

    CompletableFuture<Response<com.azure.android.communication.chat.models.ChatThreadProperties>> getProperties(RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.getChatThreadPropertiesWithResponseAsync(this.chatThreadId, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(result -> new SimpleResponse(result, (Object)ChatThreadPropertiesConverter.convert((ChatThreadProperties)result.getValue(), this.logger)));
    }

    CompletableFuture<Response<Void>> updateTopic(String topic, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.updateChatThreadPropertiesWithResponseAsync(this.chatThreadId, new UpdateChatThreadOptions().setTopic(topic), requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        });
    }

    public CompletableFuture<com.azure.android.communication.chat.models.AddChatParticipantsResult> addParticipants(Iterable<ChatParticipant> participants) {
        if (participants == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'participants' cannot be null."));
        }
        return this.addParticipants(participants, null).thenApply(response -> (com.azure.android.communication.chat.models.AddChatParticipantsResult)response.getValue());
    }

    public CompletableFuture<Response<com.azure.android.communication.chat.models.AddChatParticipantsResult>> addParticipantsWithResponse(Iterable<ChatParticipant> participants, RequestContext requestContext) {
        if (participants == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'participants' cannot be null."));
        }
        return this.addParticipants(participants, requestContext);
    }

    public CompletableFuture<Void> addParticipant(ChatParticipant participant) {
        return this.addParticipant(participant, null).thenApply(response -> null);
    }

    public CompletableFuture<Response<Void>> addParticipantWithResponse(ChatParticipant participant, RequestContext requestContext) {
        return this.addParticipant(participant, requestContext);
    }

    CompletableFuture<Response<Void>> addParticipant(ChatParticipant participant, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.addParticipants(Collections.singletonList(participant), requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(result -> {
            if (((com.azure.android.communication.chat.models.AddChatParticipantsResult)result.getValue()).getInvalidParticipants() != null && ((com.azure.android.communication.chat.models.AddChatParticipantsResult)result.getValue()).getInvalidParticipants().size() > 0) {
                ChatError error = ((com.azure.android.communication.chat.models.AddChatParticipantsResult)result.getValue()).getInvalidParticipants().get(0);
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new InvalidParticipantException(error)));
            }
            return new SimpleResponse(result, null);
        });
    }

    CompletableFuture<Response<com.azure.android.communication.chat.models.AddChatParticipantsResult>> addParticipants(Iterable<ChatParticipant> participants, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.addChatParticipantsWithResponseAsync(this.chatThreadId, AddChatParticipantsOptionsConverter.convert(participants, this.logger), requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(result -> new SimpleResponse(result, (Object)AddChatParticipantsResultConverter.convert((AddChatParticipantsResult)result.getValue(), this.logger)));
    }

    public CompletableFuture<Void> removeParticipant(CommunicationIdentifier identifier) {
        if (identifier == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'identifier' cannot be null."));
        }
        return this.removeParticipant(identifier, null).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Response<Void>> removeParticipantWithResponse(CommunicationIdentifier identifier, RequestContext requestContext) {
        if (identifier == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'identifier' cannot be null."));
        }
        return this.removeParticipant(identifier, requestContext);
    }

    CompletableFuture<Response<Void>> removeParticipant(CommunicationIdentifier identifier, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.removeChatParticipantWithResponseAsync(this.chatThreadId, CommunicationIdentifierConverter.convert(identifier, this.logger), requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        });
    }

    public PagedAsyncStream<ChatParticipant> listParticipants() {
        return this.listParticipants(new ListParticipantsOptions(), RequestContext.NONE);
    }

    public PagedAsyncStream<ChatParticipant> listParticipants(ListParticipantsOptions listParticipantsOptions, RequestContext requestContext) {
        Function pageRetriever = pageId -> {
            if (pageId == null) {
                return this.getParticipantsFirstPage(listParticipantsOptions, requestContext);
            }
            return this.getParticipantsNextPage((String)pageId, requestContext);
        };
        Function streamRetriever = pageId -> new CFBackedPageAsyncStream(pageRetriever, (Predicate<String>)((Predicate)id -> id != null), (String)pageId, this.logger);
        return new PagedAsyncStream(streamRetriever, this.logger);
    }

    CompletableFuture<PagedResponse<ChatParticipant>> getParticipantsFirstPage(ListParticipantsOptions listParticipantsOptions, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.listChatParticipantsSinglePageAsync(this.chatThreadId, listParticipantsOptions.getMaxPageSize(), listParticipantsOptions.getSkip(), requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(response -> {
            ArrayList<ChatParticipant> participants = new ArrayList<ChatParticipant>();
            if (response.getValue() != null) {
                for (com.azure.android.communication.chat.implementation.models.ChatParticipant innerParticipant : response.getValue()) {
                    participants.add(ChatParticipantConverter.convert(innerParticipant, this.logger));
                }
            }
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), participants, (String)response.getContinuationToken(), null);
        });
    }

    CompletableFuture<PagedResponse<ChatParticipant>> getParticipantsNextPage(String nextLink, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.listChatParticipantsNextSinglePageAsync(nextLink, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(response -> {
            ArrayList<ChatParticipant> participants = new ArrayList<ChatParticipant>();
            if (response.getValue() != null) {
                for (com.azure.android.communication.chat.implementation.models.ChatParticipant innerParticipant : response.getValue()) {
                    participants.add(ChatParticipantConverter.convert(innerParticipant, this.logger));
                }
            }
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), participants, (String)response.getContinuationToken(), null);
        });
    }

    public CompletableFuture<SendChatMessageResult> sendMessage(SendChatMessageOptions options) {
        if (options == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'options' cannot be null."));
        }
        return this.sendMessage(options, null).thenApply(response -> (SendChatMessageResult)response.getValue());
    }

    public CompletableFuture<Response<SendChatMessageResult>> sendMessageWithResponse(SendChatMessageOptions options, RequestContext requestContext) {
        if (options == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'options' cannot be null."));
        }
        return this.sendMessage(options, requestContext);
    }

    CompletableFuture<Response<SendChatMessageResult>> sendMessage(SendChatMessageOptions options, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.sendChatMessageWithResponseAsync(this.chatThreadId, options, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        });
    }

    public CompletableFuture<ChatMessage> getMessage(String chatMessageId) {
        if (chatMessageId == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'chatMessageId' cannot be null."));
        }
        return this.getMessage(chatMessageId, null).thenApply(response -> (ChatMessage)response.getValue());
    }

    public CompletableFuture<Response<ChatMessage>> getMessageWithResponse(String chatMessageId, RequestContext requestContext) {
        if (chatMessageId == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'chatMessageId' cannot be null."));
        }
        return this.getMessage(chatMessageId, requestContext);
    }

    CompletableFuture<Response<ChatMessage>> getMessage(String chatMessageId, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.getChatMessageWithResponseAsync(this.chatThreadId, chatMessageId, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(result -> new SimpleResponse(result, (Object)ChatMessageConverter.convert((com.azure.android.communication.chat.implementation.models.ChatMessage)result.getValue(), this.logger)));
    }

    public PagedAsyncStream<ChatMessage> listMessages() {
        return this.listMessages(new ListChatMessagesOptions(), RequestContext.NONE);
    }

    public PagedAsyncStream<ChatMessage> listMessages(ListChatMessagesOptions listMessagesOptions, RequestContext requestContext) {
        Function pageRetriever = pageId -> {
            if (pageId == null) {
                return this.getMessagesFirstPage(listMessagesOptions, requestContext);
            }
            return this.getMessagesNextPage((String)pageId, requestContext);
        };
        Function streamRetriever = pageId -> new CFBackedPageAsyncStream(pageRetriever, (Predicate<String>)((Predicate)id -> id != null), (String)pageId, this.logger);
        return new PagedAsyncStream(streamRetriever, this.logger);
    }

    CompletableFuture<PagedResponse<ChatMessage>> getMessagesFirstPage(ListChatMessagesOptions listChatMessagesOptions, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.listChatMessagesSinglePageAsync(this.chatThreadId, listChatMessagesOptions.getMaxPageSize(), listChatMessagesOptions.getStartTime(), requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(response -> {
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
            if (response.getValue() != null) {
                for (com.azure.android.communication.chat.implementation.models.ChatMessage innerMessage : response.getValue()) {
                    messages.add(ChatMessageConverter.convert(innerMessage, this.logger));
                }
            }
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), messages, (String)response.getContinuationToken(), null);
        });
    }

    CompletableFuture<PagedResponse<ChatMessage>> getMessagesNextPage(String nextLink, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.listChatMessagesNextSinglePageAsync(nextLink, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(response -> {
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
            if (response.getValue() != null) {
                for (com.azure.android.communication.chat.implementation.models.ChatMessage innerMessage : response.getValue()) {
                    messages.add(ChatMessageConverter.convert(innerMessage, this.logger));
                }
            }
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), messages, (String)response.getContinuationToken(), null);
        });
    }

    public CompletableFuture<Void> updateMessage(String chatMessageId, UpdateChatMessageOptions options) {
        if (chatMessageId == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'chatMessageId' cannot be null."));
        }
        if (options == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'options' cannot be null."));
        }
        return this.updateMessage(chatMessageId, options, null).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Response<Void>> updateMessageWithResponse(String chatMessageId, UpdateChatMessageOptions options, RequestContext requestContext) {
        if (chatMessageId == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'chatMessageId' cannot be null."));
        }
        if (options == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'options' cannot be null."));
        }
        return this.updateMessage(chatMessageId, options, requestContext);
    }

    CompletableFuture<Response<Void>> updateMessage(String chatMessageId, UpdateChatMessageOptions options, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.updateChatMessageWithResponseAsync(this.chatThreadId, chatMessageId, options, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        });
    }

    public CompletableFuture<Void> deleteMessage(String chatMessageId) {
        if (chatMessageId == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'chatMessageId' cannot be null."));
        }
        return this.deleteMessage(chatMessageId, null).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Response<Void>> deleteMessageWithResponse(String chatMessageId, RequestContext requestContext) {
        if (chatMessageId == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'chatMessageId' cannot be null."));
        }
        return this.deleteMessage(chatMessageId, requestContext);
    }

    CompletableFuture<Response<Void>> deleteMessage(String chatMessageId, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.deleteChatMessageWithResponseAsync(this.chatThreadId, chatMessageId, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        });
    }

    public CompletableFuture<Void> sendTypingNotification() {
        return this.sendTypingNotification(null, null).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Response<Void>> sendTypingNotificationWithResponse(RequestContext requestContext) {
        return this.sendTypingNotification(null, requestContext);
    }

    public CompletableFuture<Response<Void>> sendTypingNotificationWithResponse(TypingNotificationOptions typingNotificationOptions, RequestContext requestContext) {
        return this.sendTypingNotification(typingNotificationOptions, requestContext);
    }

    CompletableFuture<Response<Void>> sendTypingNotification(TypingNotificationOptions typingNotificationOptions, RequestContext requestContext) {
        typingNotificationOptions = typingNotificationOptions == null ? new TypingNotificationOptions() : typingNotificationOptions;
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.sendTypingNotificationWithResponseAsync(this.chatThreadId, typingNotificationOptions, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        });
    }

    public CompletableFuture<Void> sendReadReceipt(String chatMessageId) {
        if (chatMessageId == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'chatMessageId' cannot be null."));
        }
        return this.sendReadReceipt(chatMessageId, null).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Response<Void>> sendReadReceiptWithResponse(String chatMessageId, RequestContext requestContext) {
        if (chatMessageId == null) {
            return CompletableFuture.failedFuture((Throwable)new NullPointerException("'chatMessageId' cannot be null."));
        }
        return this.sendReadReceipt(chatMessageId, requestContext);
    }

    CompletableFuture<Response<Void>> sendReadReceipt(String chatMessageId, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        SendReadReceiptRequest request = new SendReadReceiptRequest().setChatMessageId(chatMessageId);
        return this.chatThreadClient.sendChatReadReceiptWithResponseAsync(this.chatThreadId, request, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        });
    }

    public PagedAsyncStream<ChatMessageReadReceipt> listReadReceipts() {
        return this.listReadReceipts(new ListReadReceiptOptions(), RequestContext.NONE);
    }

    public PagedAsyncStream<ChatMessageReadReceipt> listReadReceipts(ListReadReceiptOptions listReadReceiptOptions, RequestContext requestContext) {
        Function pageRetriever = pageId -> {
            if (pageId == null) {
                return this.getReadReceiptsFirstPage(listReadReceiptOptions, requestContext);
            }
            return this.getReadReceiptsNextPage((String)pageId, requestContext);
        };
        Function streamRetriever = pageId -> new CFBackedPageAsyncStream(pageRetriever, (Predicate<String>)((Predicate)id -> id != null), (String)pageId, this.logger);
        return new PagedAsyncStream(streamRetriever, this.logger);
    }

    CompletableFuture<PagedResponse<ChatMessageReadReceipt>> getReadReceiptsFirstPage(ListReadReceiptOptions listReadReceiptOptions, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.listChatReadReceiptsSinglePageAsync(this.chatThreadId, listReadReceiptOptions.getMaxPageSize(), listReadReceiptOptions.getSkip(), requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(response -> {
            ArrayList<ChatMessageReadReceipt> receipts = new ArrayList<ChatMessageReadReceipt>();
            if (response.getValue() != null) {
                for (com.azure.android.communication.chat.implementation.models.ChatMessageReadReceipt innerReceipt : response.getValue()) {
                    receipts.add(ChatMessageReadReceiptConverter.convert(innerReceipt, this.logger));
                }
            }
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), receipts, (String)response.getContinuationToken(), null);
        });
    }

    CompletableFuture<PagedResponse<ChatMessageReadReceipt>> getReadReceiptsNextPage(String nextLink, RequestContext requestContext) {
        requestContext = requestContext == null ? RequestContext.NONE : requestContext;
        return this.chatThreadClient.listChatReadReceiptsNextSinglePageAsync(nextLink, requestContext).exceptionally(throwable -> {
            throw this.logger.logExceptionAsError(CommunicationErrorResponseExceptionConverter.convert(throwable));
        }).thenApply(response -> {
            ArrayList<ChatMessageReadReceipt> receipts = new ArrayList<ChatMessageReadReceipt>();
            if (response.getValue() != null) {
                for (com.azure.android.communication.chat.implementation.models.ChatMessageReadReceipt innerReceipt : response.getValue()) {
                    receipts.add(ChatMessageReadReceiptConverter.convert(innerReceipt, this.logger));
                }
            }
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), receipts, (String)response.getContinuationToken(), null);
        });
    }
}

