/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat;

import com.azure.android.communication.chat.ChatThreadAsyncClient;
import com.azure.android.communication.chat.models.AddChatParticipantsResult;
import com.azure.android.communication.chat.models.ChatMessage;
import com.azure.android.communication.chat.models.ChatMessageReadReceipt;
import com.azure.android.communication.chat.models.ChatParticipant;
import com.azure.android.communication.chat.models.ChatThreadProperties;
import com.azure.android.communication.chat.models.ListChatMessagesOptions;
import com.azure.android.communication.chat.models.ListParticipantsOptions;
import com.azure.android.communication.chat.models.ListReadReceiptOptions;
import com.azure.android.communication.chat.models.SendChatMessageOptions;
import com.azure.android.communication.chat.models.SendChatMessageResult;
import com.azure.android.communication.chat.models.TypingNotificationOptions;
import com.azure.android.communication.chat.models.UpdateChatMessageOptions;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.rest.Response;
import com.azure.android.core.rest.util.paging.PagedIterable;
import com.azure.android.core.rest.util.paging.PagedResponse;
import com.azure.android.core.util.Function;
import com.azure.android.core.util.RequestContext;
import java.util.concurrent.ExecutionException;
import java9.util.concurrent.CompletableFuture;

public final class ChatThreadClient {
    private final ClientLogger logger = new ClientLogger(ChatThreadClient.class);
    private final ChatThreadAsyncClient client;
    private final String chatThreadId;

    ChatThreadClient(ChatThreadAsyncClient client) {
        this.client = client;
        this.chatThreadId = client.getChatThreadId();
    }

    public String getChatThreadId() {
        return this.chatThreadId;
    }

    public ChatThreadProperties getProperties() {
        return this.block(this.client.getProperties());
    }

    public Response<ChatThreadProperties> getPropertiesWithResponse(RequestContext requestContext) {
        return this.block(this.client.getProperties(requestContext));
    }

    public void updateTopic(String topic) {
        this.block(this.client.updateTopic(topic));
    }

    public Response<Void> updateTopicWithResponse(String topic, RequestContext requestContext) {
        return this.block(this.client.updateTopic(topic, requestContext));
    }

    public AddChatParticipantsResult addParticipants(Iterable<ChatParticipant> participants) {
        return this.block(this.client.addParticipants(participants));
    }

    public Response<AddChatParticipantsResult> addParticipantsWithResponse(Iterable<ChatParticipant> participants, RequestContext requestContext) {
        return this.block(this.client.addParticipants(participants, requestContext));
    }

    public void addParticipant(ChatParticipant participant) {
        this.block(this.client.addParticipant(participant));
    }

    public Response<Void> addParticipantWithResponse(ChatParticipant participant, RequestContext requestContext) {
        return this.block(this.client.addParticipant(participant, requestContext));
    }

    public Response<Void> removeParticipantWithResponse(CommunicationIdentifier identifier, RequestContext requestContext) {
        return this.block(this.client.removeParticipant(identifier, requestContext));
    }

    public void removeParticipant(CommunicationIdentifier identifier) {
        this.block(this.client.removeParticipant(identifier));
    }

    public PagedIterable<ChatParticipant> listParticipants() {
        return this.listParticipants(new ListParticipantsOptions(), RequestContext.NONE);
    }

    public PagedIterable<ChatParticipant> listParticipants(ListParticipantsOptions listParticipantsOptions, RequestContext requestContext) {
        Function pageRetriever = pageId -> {
            if (pageId == null) {
                return this.getParticipantsFirstPageWithResponse(listParticipantsOptions, requestContext);
            }
            return this.getParticipantsNextPageWithResponse((String)pageId, requestContext);
        };
        return new PagedIterable(pageRetriever, pageId -> pageId != null, this.logger);
    }

    private PagedResponse<ChatParticipant> getParticipantsFirstPageWithResponse(ListParticipantsOptions listParticipantsOptions, RequestContext requestContext) {
        return this.block(this.client.getParticipantsFirstPage(listParticipantsOptions, requestContext));
    }

    private PagedResponse<ChatParticipant> getParticipantsNextPageWithResponse(String nextLink, RequestContext requestContext) {
        return this.block(this.client.getParticipantsNextPage(nextLink, requestContext));
    }

    public Response<SendChatMessageResult> sendMessageWithResponse(SendChatMessageOptions options, RequestContext requestContext) {
        return this.block(this.client.sendMessage(options, requestContext));
    }

    public SendChatMessageResult sendMessage(SendChatMessageOptions options) {
        return this.block(this.client.sendMessage(options));
    }

    public Response<ChatMessage> getMessageWithResponse(String chatMessageId, RequestContext requestContext) {
        return this.block(this.client.getMessage(chatMessageId, requestContext));
    }

    public ChatMessage getMessage(String chatMessageId) {
        return this.block(this.client.getMessage(chatMessageId));
    }

    public PagedIterable<ChatMessage> listMessages() {
        return this.listMessages(new ListChatMessagesOptions(), RequestContext.NONE);
    }

    public PagedIterable<ChatMessage> listMessages(ListChatMessagesOptions listMessagesOptions, RequestContext requestContext) {
        Function pageRetriever = pageId -> {
            if (pageId == null) {
                return this.getMessagesFirstPageWithResponse(listMessagesOptions, requestContext);
            }
            return this.getMessagesNextPageWithResponse((String)pageId, requestContext);
        };
        return new PagedIterable(pageRetriever, pageId -> pageId != null, this.logger);
    }

    private PagedResponse<ChatMessage> getMessagesFirstPageWithResponse(ListChatMessagesOptions listMessagesOptions, RequestContext requestContext) {
        return this.block(this.client.getMessagesFirstPage(listMessagesOptions, requestContext));
    }

    private PagedResponse<ChatMessage> getMessagesNextPageWithResponse(String nextLink, RequestContext requestContext) {
        return this.block(this.client.getMessagesNextPage(nextLink, requestContext));
    }

    public Response<Void> updateMessageWithResponse(String chatMessageId, UpdateChatMessageOptions options, RequestContext requestContext) {
        return this.block(this.client.updateMessage(chatMessageId, options, requestContext));
    }

    public void updateMessage(String chatMessageId, UpdateChatMessageOptions options) {
        this.block(this.client.updateMessage(chatMessageId, options));
    }

    public Response<Void> deleteMessageWithResponse(String chatMessageId, RequestContext requestContext) {
        return this.block(this.client.deleteMessage(chatMessageId, requestContext));
    }

    public void deleteMessage(String chatMessageId) {
        this.block(this.client.deleteMessage(chatMessageId));
    }

    public Response<Void> sendTypingNotificationWithResponse(RequestContext requestContext) {
        return this.block(this.client.sendTypingNotification(null, requestContext));
    }

    public void sendTypingNotification() {
        this.block(this.client.sendTypingNotification());
    }

    public Response<Void> sendTypingNotificationWithResponse(TypingNotificationOptions typingNotificationOptions, RequestContext requestContext) {
        return this.block(this.client.sendTypingNotification(typingNotificationOptions, requestContext));
    }

    public Response<Void> sendReadReceiptWithResponse(String chatMessageId, RequestContext requestContext) {
        return this.block(this.client.sendReadReceipt(chatMessageId, requestContext));
    }

    public void sendReadReceipt(String chatMessageId) {
        this.block(this.client.sendReadReceipt(chatMessageId));
    }

    public PagedIterable<ChatMessageReadReceipt> listReadReceipts() {
        return this.listReadReceipts(new ListReadReceiptOptions(), RequestContext.NONE);
    }

    public PagedIterable<ChatMessageReadReceipt> listReadReceipts(ListReadReceiptOptions listReadReceiptOptions, RequestContext requestContext) {
        Function pageRetriever = pageId -> {
            if (pageId == null) {
                return this.getReadReceiptsFirstPageWithResponse(listReadReceiptOptions, requestContext);
            }
            return this.getReadReceiptsNextPageWithResponse((String)pageId, requestContext);
        };
        return new PagedIterable(pageRetriever, pageId -> pageId != null, this.logger);
    }

    private PagedResponse<ChatMessageReadReceipt> getReadReceiptsFirstPageWithResponse(ListReadReceiptOptions listReadReceiptOptions, RequestContext requestContext) {
        return this.block(this.client.getReadReceiptsFirstPage(listReadReceiptOptions, requestContext));
    }

    private PagedResponse<ChatMessageReadReceipt> getReadReceiptsNextPageWithResponse(String nextLink, RequestContext requestContext) {
        return this.block(this.client.getReadReceiptsNextPage(nextLink, requestContext));
    }

    private <T> T block(CompletableFuture<T> completableFuture) {
        try {
            return (T)completableFuture.get();
        }
        catch (InterruptedException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
        catch (ExecutionException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }
}

