/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat;

import com.azure.android.communication.chat.ChatServiceVersion;
import com.azure.android.communication.chat.ChatThreadAsyncClient;
import com.azure.android.communication.chat.ChatThreadClient;
import com.azure.android.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.android.communication.chat.implementation.AzureCommunicationChatServiceImplBuilder;
import com.azure.android.communication.common.CommunicationAccessToken;
import com.azure.android.communication.common.CommunicationTokenCredential;
import com.azure.android.core.http.HttpClient;
import com.azure.android.core.http.HttpPipeline;
import com.azure.android.core.http.HttpPipelineBuilder;
import com.azure.android.core.http.HttpPipelinePolicy;
import com.azure.android.core.http.HttpRequest;
import com.azure.android.core.http.policy.CookiePolicy;
import com.azure.android.core.http.policy.HttpLogOptions;
import com.azure.android.core.http.policy.HttpLoggingPolicy;
import com.azure.android.core.http.policy.RetryPolicy;
import com.azure.android.core.http.policy.UserAgentPolicy;
import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.rest.annotation.ServiceClientBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java9.util.concurrent.CompletableFuture;

@ServiceClientBuilder(serviceClients={ChatThreadAsyncClient.class, ChatThreadClient.class})
public final class ChatThreadClientBuilder {
    private final ClientLogger logger = new ClientLogger(ChatThreadClientBuilder.class);
    private String chatThreadId;
    private String endpoint;
    private HttpClient httpClient;
    private CommunicationTokenCredential communicationTokenCredential;
    private RetryPolicy retryPolicy;
    private final List<HttpPipelinePolicy> customPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions = new HttpLogOptions();
    private HttpPipeline httpPipeline;
    private ChatServiceVersion serviceVersion;

    public ChatThreadClientBuilder endpoint(String endpoint) {
        if (endpoint == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("endpoint is required."));
        }
        this.endpoint = endpoint;
        return this;
    }

    public ChatThreadClientBuilder httpClient(HttpClient httpClient) {
        if (httpClient == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("httpClient is required."));
        }
        this.httpClient = httpClient;
        return this;
    }

    public ChatThreadClientBuilder credential(CommunicationTokenCredential communicationTokenCredential) {
        if (communicationTokenCredential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("communicationTokenCredential is required."));
        }
        this.communicationTokenCredential = communicationTokenCredential;
        return this;
    }

    public ChatThreadClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        if (pipelinePolicy == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("pipelinePolicy is required."));
        }
        this.customPolicies.add(pipelinePolicy);
        return this;
    }

    public ChatThreadClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        if (retryPolicy == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("retryPolicy is required."));
        }
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ChatThreadClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        if (logOptions == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("logOptions is required."));
        }
        this.logOptions = logOptions;
        return this;
    }

    public ChatThreadClientBuilder serviceVersion(ChatServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public ChatThreadClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        return this;
    }

    public ChatThreadClientBuilder chatThreadId(String chatThreadId) {
        this.chatThreadId = chatThreadId;
        return this;
    }

    public ChatThreadClient buildClient() {
        return new ChatThreadClient(this.buildAsyncClient());
    }

    public ChatThreadAsyncClient buildAsyncClient() {
        if (this.chatThreadId == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'chatThreadId' is required."));
        }
        return new ChatThreadAsyncClient(this.createInternalClient(), this.chatThreadId);
    }

    private AzureCommunicationChatServiceImpl createInternalClient() {
        HttpPipeline pipeline;
        if (this.endpoint == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'endpoint' is required."));
        }
        if (this.httpPipeline != null) {
            pipeline = this.httpPipeline;
        } else {
            if (this.communicationTokenCredential == null) {
                throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("CommunicationTokenCredential is required."));
            }
            HttpPipelinePolicy authorizationPolicy = chain -> {
                CommunicationAccessToken token;
                CompletableFuture tokenFuture = this.communicationTokenCredential.getToken();
                try {
                    token = (CommunicationAccessToken)tokenFuture.get();
                }
                catch (ExecutionException e) {
                    chain.completedError((Throwable)e);
                    return;
                }
                catch (InterruptedException e) {
                    chain.completedError((Throwable)e);
                    return;
                }
                HttpRequest httpRequest = chain.getRequest();
                httpRequest.getHeaders().put("Authorization", "Bearer " + token.getToken());
                chain.processNextPolicy(httpRequest);
            };
            pipeline = this.createHttpPipeline(this.httpClient, authorizationPolicy, this.customPolicies);
        }
        AzureCommunicationChatServiceImplBuilder clientBuilder = new AzureCommunicationChatServiceImplBuilder().apiVersion(this.serviceVersion == null ? ChatServiceVersion.getLatest().getVersion() : this.serviceVersion.getVersion()).endpoint(this.endpoint).pipeline(pipeline);
        return clientBuilder.buildClient();
    }

    private HttpPipeline createHttpPipeline(HttpClient httpClient, HttpPipelinePolicy authorizationPolicy, List<HttpPipelinePolicy> additionalPolicies) {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        this.applyRequiredPolicies(policies, authorizationPolicy);
        if (additionalPolicies != null && additionalPolicies.size() > 0) {
            policies.addAll(additionalPolicies);
        }
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }

    private void applyRequiredPolicies(List<HttpPipelinePolicy> policies, HttpPipelinePolicy authorizationPolicy) {
        policies.add((HttpPipelinePolicy)new UserAgentPolicy(null, "com.azure.android.communication.chat", "2.1.0"));
        policies.add((HttpPipelinePolicy)(this.retryPolicy == null ? RetryPolicy.withExponentialBackoff() : this.retryPolicy));
        policies.add((HttpPipelinePolicy)new CookiePolicy());
        policies.add(authorizationPolicy);
        policies.add((HttpPipelinePolicy)new HttpLoggingPolicy(this.logOptions));
    }
}

