/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation;

import com.azure.android.communication.chat.implementation.ChatImpl;
import com.azure.android.communication.chat.implementation.ChatThreadImpl;
import com.azure.android.core.http.HttpPipeline;
import com.azure.android.core.http.HttpPipelineBuilder;
import com.azure.android.core.http.HttpPipelinePolicy;
import com.azure.android.core.http.policy.CookiePolicy;
import com.azure.android.core.http.policy.RetryPolicy;
import com.azure.android.core.http.policy.UserAgentPolicy;
import com.azure.android.core.serde.jackson.JacksonSerder;

public final class AzureCommunicationChatServiceImpl {
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final JacksonSerder jacksonSerder;
    private final ChatThreadImpl chatThreads;
    private final ChatImpl chats;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public JacksonSerder getJacksonSerder() {
        return this.jacksonSerder;
    }

    public ChatThreadImpl getChatThreadClient() {
        return this.chatThreads;
    }

    public ChatImpl getChatClient() {
        return this.chats;
    }

    AzureCommunicationChatServiceImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), RetryPolicy.withExponentialBackoff(), new CookiePolicy()}).build(), JacksonSerder.createDefault(), endpoint, apiVersion);
    }

    AzureCommunicationChatServiceImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonSerder.createDefault(), endpoint, apiVersion);
    }

    AzureCommunicationChatServiceImpl(HttpPipeline httpPipeline, JacksonSerder jacksonSerder, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.jacksonSerder = jacksonSerder;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.chatThreads = new ChatThreadImpl(this);
        this.chats = new ChatImpl(this);
    }
}

