/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation;

import com.azure.android.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.android.core.http.HttpClient;
import com.azure.android.core.http.HttpPipeline;
import com.azure.android.core.http.HttpPipelineBuilder;
import com.azure.android.core.http.HttpPipelinePolicy;
import com.azure.android.core.http.policy.CookiePolicy;
import com.azure.android.core.http.policy.HttpLogOptions;
import com.azure.android.core.http.policy.HttpLoggingPolicy;
import com.azure.android.core.http.policy.RetryPolicy;
import com.azure.android.core.http.policy.UserAgentPolicy;
import com.azure.android.core.rest.annotation.ServiceClientBuilder;
import com.azure.android.core.serde.jackson.JacksonSerder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={AzureCommunicationChatServiceImpl.class})
public final class AzureCommunicationChatServiceImplBuilder {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private final Map<String, String> properties = new HashMap<String, String>();
    private String endpoint;
    private String apiVersion;
    private HttpPipeline pipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private RetryPolicy retryPolicy;
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();

    public AzureCommunicationChatServiceImplBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public AzureCommunicationChatServiceImplBuilder apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public AzureCommunicationChatServiceImplBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public AzureCommunicationChatServiceImplBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public AzureCommunicationChatServiceImplBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public AzureCommunicationChatServiceImplBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public AzureCommunicationChatServiceImplBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public AzureCommunicationChatServiceImpl buildClient() {
        if (this.apiVersion == null) {
            this.apiVersion = "2021-09-07";
        }
        if (this.pipeline == null) {
            this.pipeline = this.createHttpPipeline();
        }
        AzureCommunicationChatServiceImpl client = new AzureCommunicationChatServiceImpl(this.pipeline, JacksonSerder.createDefault(), this.endpoint, this.apiVersion);
        return client;
    }

    private HttpPipeline createHttpPipeline() {
        String clientVersion;
        if (this.httpLogOptions == null) {
            this.httpLogOptions = new HttpLogOptions();
        }
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.get(SDK_NAME);
        if (clientName == null) {
            clientName = "UnknownName";
        }
        if ((clientVersion = this.properties.get(SDK_VERSION)) == null) {
            clientVersion = "UnknownVersion";
        }
        policies.add(new UserAgentPolicy(null, clientName, clientVersion));
        policies.add(this.retryPolicy == null ? RetryPolicy.withExponentialBackoff() : this.retryPolicy);
        policies.add(new CookiePolicy());
        policies.addAll(this.pipelinePolicies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return httpPipeline;
    }
}

