/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation;

import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.rest.util.paging.PagedResponse;
import com.azure.android.core.util.AsyncStream;
import com.azure.android.core.util.AsyncStreamHandler;
import com.azure.android.core.util.CancellationToken;
import com.azure.android.core.util.Function;
import com.azure.android.core.util.Predicate;
import java.util.concurrent.CancellationException;
import java9.util.concurrent.CompletableFuture;
import java9.util.concurrent.CompletionException;

public final class CFBackedPageAsyncStream<T>
implements AsyncStream<PagedResponse<T>> {
    private final Function<String, CompletableFuture<PagedResponse<T>>> pageRetriever;
    private final Predicate<String> continuationPredicate;
    private final String startPageId;
    private final ClientLogger logger;

    public CFBackedPageAsyncStream(Function<String, CompletableFuture<PagedResponse<T>>> pageRetriever, Predicate<String> continuationPredicate, String startPageId, ClientLogger logger) {
        this.pageRetriever = pageRetriever;
        this.continuationPredicate = continuationPredicate;
        this.startPageId = startPageId;
        this.logger = logger;
    }

    public CancellationToken forEach(AsyncStreamHandler<PagedResponse<T>> handler) {
        CancellationToken token = new CancellationToken();
        handler.onInit(token);
        if (token.isCancellationRequested()) {
            handler.onError((Throwable)new CancellationException());
            return token;
        }
        CompletableFuture<Void> completableFuture = this.enumeratePages(this.startPageId, token, handler);
        token.registerOnCancel(() -> completableFuture.cancel(true));
        completableFuture.whenCompleteAsync((ignored, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof CompletionException && throwable.getCause() != null) {
                    handler.onError(throwable.getCause());
                } else {
                    handler.onError(throwable);
                }
            } else {
                handler.onComplete();
            }
        });
        return token;
    }

    private CompletableFuture<Void> enumeratePages(String pageId, CancellationToken token, AsyncStreamHandler<PagedResponse<T>> handler) {
        return ((CompletableFuture)this.pageRetriever.call((Object)pageId)).handleAsync((pagedResponse, throwable) -> {
            if (throwable != null) {
                if (throwable instanceof RuntimeException) {
                    throw this.logger.logExceptionAsError((RuntimeException)throwable);
                }
                throw this.logger.logExceptionAsError(new RuntimeException((Throwable)throwable));
            }
            handler.onNext(pagedResponse);
            String nextPageId = (String)pagedResponse.getContinuationToken();
            return this.continuationPredicate.test((Object)nextPageId) ? nextPageId : null;
        }).thenCompose(nextPageId -> {
            if (token.isCancellationRequested()) {
                return CompletableFuture.failedFuture((Throwable)new CancellationException());
            }
            return nextPageId != null ? this.enumeratePages((String)nextPageId, token, handler) : CompletableFuture.completedFuture(null);
        });
    }
}

