/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation;

import com.azure.android.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.android.communication.chat.implementation.models.ChatThreadsItemCollection;
import com.azure.android.communication.chat.implementation.models.CommunicationErrorResponseException;
import com.azure.android.communication.chat.implementation.models.CreateChatThreadOptions;
import com.azure.android.communication.chat.implementation.models.CreateChatThreadResult;
import com.azure.android.communication.chat.models.ChatThreadItem;
import com.azure.android.core.http.HttpPipeline;
import com.azure.android.core.rest.Callback;
import com.azure.android.core.rest.Response;
import com.azure.android.core.rest.RestProxy;
import com.azure.android.core.rest.annotation.BodyParam;
import com.azure.android.core.rest.annotation.Delete;
import com.azure.android.core.rest.annotation.ExpectedResponses;
import com.azure.android.core.rest.annotation.Get;
import com.azure.android.core.rest.annotation.HeaderParam;
import com.azure.android.core.rest.annotation.Host;
import com.azure.android.core.rest.annotation.HostParam;
import com.azure.android.core.rest.annotation.PathParam;
import com.azure.android.core.rest.annotation.Post;
import com.azure.android.core.rest.annotation.QueryParam;
import com.azure.android.core.rest.annotation.ServiceInterface;
import com.azure.android.core.rest.annotation.UnexpectedResponseExceptionType;
import com.azure.android.core.rest.annotation.UnexpectedResponseExceptionTypes;
import com.azure.android.core.rest.util.paging.PagedResponse;
import com.azure.android.core.rest.util.paging.PagedResponseBase;
import com.azure.android.core.serde.jackson.JacksonSerder;
import com.azure.android.core.util.RequestContext;
import java.util.concurrent.ExecutionException;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Function;
import org.threeten.bp.OffsetDateTime;

public final class ChatImpl {
    private final ChatsService service;
    private final AzureCommunicationChatServiceImpl client;

    ChatImpl(AzureCommunicationChatServiceImpl client) {
        this.service = (ChatsService)RestProxy.create(ChatsService.class, (HttpPipeline)client.getHttpPipeline(), (JacksonSerder)client.getJacksonSerder());
        this.client = client;
    }

    public CompletableFuture<Response<CreateChatThreadResult>> createChatThreadWithResponseAsync(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId) {
        String accept = "application/json";
        ResponseCompletableFuture<CreateChatThreadResult> completableFuture = new ResponseCompletableFuture<CreateChatThreadResult>();
        this.service.createChatThread(this.client.getEndpoint(), repeatabilityRequestId, this.client.getApiVersion(), createChatThreadRequest, "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<CreateChatThreadResult>> createChatThreadWithResponseAsync(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<CreateChatThreadResult> completableFuture = new ResponseCompletableFuture<CreateChatThreadResult>();
        this.service.createChatThread(this.client.getEndpoint(), repeatabilityRequestId, this.client.getApiVersion(), createChatThreadRequest, "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<CreateChatThreadResult> createChatThreadAsync(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId) {
        return this.createChatThreadWithResponseAsync(createChatThreadRequest, repeatabilityRequestId).thenApply(response -> (CreateChatThreadResult)response.getValue());
    }

    public CompletableFuture<CreateChatThreadResult> createChatThreadAsync(CreateChatThreadOptions createChatThreadRequest) {
        String repeatabilityRequestId = null;
        return this.createChatThreadWithResponseAsync(createChatThreadRequest, repeatabilityRequestId).thenApply(response -> (CreateChatThreadResult)response.getValue());
    }

    public CompletableFuture<CreateChatThreadResult> createChatThreadAsync(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId, RequestContext requestContext) {
        return this.createChatThreadWithResponseAsync(createChatThreadRequest, repeatabilityRequestId, requestContext).thenApply(response -> (CreateChatThreadResult)response.getValue());
    }

    public CreateChatThreadResult createChatThread(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId) {
        try {
            return (CreateChatThreadResult)this.createChatThreadAsync(createChatThreadRequest, repeatabilityRequestId).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CreateChatThreadResult createChatThread(CreateChatThreadOptions createChatThreadRequest) {
        String repeatabilityRequestId = null;
        try {
            return (CreateChatThreadResult)this.createChatThreadAsync(createChatThreadRequest, repeatabilityRequestId).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<CreateChatThreadResult> createChatThreadWithResponse(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId, RequestContext requestContext) {
        try {
            return (Response)this.createChatThreadWithResponseAsync(createChatThreadRequest, repeatabilityRequestId, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<PagedResponse<ChatThreadItem>> listChatThreadsSinglePageAsync(Integer maxPageSize, OffsetDateTime startTime) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatThreadsItemCollection)response.getValue()).getValue(), ((ChatThreadsItemCollection)response.getValue()).getNextLink(), null));
        this.service.listChatThreads(this.client.getEndpoint(), maxPageSize, startTime, this.client.getApiVersion(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<PagedResponse<ChatThreadItem>> listChatThreadsSinglePageAsync(Integer maxPageSize, OffsetDateTime startTime, RequestContext requestContext) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatThreadsItemCollection)response.getValue()).getValue(), ((ChatThreadsItemCollection)response.getValue()).getNextLink(), null));
        this.service.listChatThreads(this.client.getEndpoint(), maxPageSize, startTime, this.client.getApiVersion(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<Void>> deleteChatThreadWithResponseAsync(String chatThreadId) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.deleteChatThread(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<Void>> deleteChatThreadWithResponseAsync(String chatThreadId, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.deleteChatThread(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Void> deleteChatThreadAsync(String chatThreadId) {
        return this.deleteChatThreadWithResponseAsync(chatThreadId).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Void> deleteChatThreadAsync(String chatThreadId, RequestContext requestContext) {
        return this.deleteChatThreadWithResponseAsync(chatThreadId, requestContext).thenApply(response -> (Void)response.getValue());
    }

    public void deleteChatThread(String chatThreadId) {
        try {
            this.deleteChatThreadAsync(chatThreadId).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<Void> deleteChatThreadWithResponse(String chatThreadId, RequestContext requestContext) {
        try {
            return (Response)this.deleteChatThreadWithResponseAsync(chatThreadId, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<PagedResponse<ChatThreadItem>> listChatThreadsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatThreadsItemCollection)response.getValue()).getValue(), ((ChatThreadsItemCollection)response.getValue()).getNextLink(), null));
        this.service.listChatThreadsNext(nextLink, this.client.getEndpoint(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<PagedResponse<ChatThreadItem>> listChatThreadsNextSinglePageAsync(String nextLink, RequestContext requestContext) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatThreadsItemCollection)response.getValue()).getValue(), ((ChatThreadsItemCollection)response.getValue()).getNextLink(), null));
        this.service.listChatThreadsNext(nextLink, this.client.getEndpoint(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    private static final class PagedResponseCompletableFuture<P, T>
    extends CompletableFuture<PagedResponse<T>>
    implements Callback<Response<P>> {
        private final Function<Response<P>, PagedResponse<T>> converter;

        PagedResponseCompletableFuture(Function<Response<P>, PagedResponse<T>> converter) {
            this.converter = converter;
        }

        public void onSuccess(Response<P> response) {
            this.complete((PagedResponse)this.converter.apply(response));
        }

        public void onFailure(Throwable error) {
            this.completeExceptionally(error);
        }
    }

    private static final class ResponseCompletableFuture<T>
    extends CompletableFuture<Response<T>>
    implements Callback<Response<T>> {
        private ResponseCompletableFuture() {
        }

        public void onSuccess(Response<T> response) {
            this.complete(response);
        }

        public void onFailure(Throwable error) {
            this.completeExceptionally(error);
        }
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCh")
    private static interface ChatsService {
        @Post(value="/chat/threads")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void createChatThread(@HostParam(value="endpoint") String var1, @HeaderParam(value="repeatability-Request-Id") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CreateChatThreadOptions var4, @HeaderParam(value="Accept") String var5, RequestContext var6, Callback<Response<CreateChatThreadResult>> var7);

        @Get(value="/chat/threads")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void listChatThreads(@HostParam(value="endpoint") String var1, @QueryParam(value="maxPageSize") Integer var2, @QueryParam(value="startTime") OffsetDateTime var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestContext var6, Callback<Response<ChatThreadsItemCollection>> var7);

        @Delete(value="/chat/threads/{chatThreadId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void deleteChatThread(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestContext var5, Callback<Response<Void>> var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void listChatThreadsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestContext var4, Callback<Response<ChatThreadsItemCollection>> var5);
    }
}

