/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation;

import com.azure.android.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.android.communication.chat.implementation.models.AddChatParticipantsOptions;
import com.azure.android.communication.chat.implementation.models.AddChatParticipantsResult;
import com.azure.android.communication.chat.implementation.models.ChatMessage;
import com.azure.android.communication.chat.implementation.models.ChatMessageReadReceipt;
import com.azure.android.communication.chat.implementation.models.ChatMessageReadReceiptsCollection;
import com.azure.android.communication.chat.implementation.models.ChatMessagesCollection;
import com.azure.android.communication.chat.implementation.models.ChatParticipant;
import com.azure.android.communication.chat.implementation.models.ChatParticipantsCollection;
import com.azure.android.communication.chat.implementation.models.ChatThreadProperties;
import com.azure.android.communication.chat.implementation.models.CommunicationErrorResponseException;
import com.azure.android.communication.chat.implementation.models.CommunicationIdentifierModel;
import com.azure.android.communication.chat.implementation.models.SendReadReceiptRequest;
import com.azure.android.communication.chat.models.SendChatMessageOptions;
import com.azure.android.communication.chat.models.SendChatMessageResult;
import com.azure.android.communication.chat.models.TypingNotificationOptions;
import com.azure.android.communication.chat.models.UpdateChatMessageOptions;
import com.azure.android.communication.chat.models.UpdateChatThreadOptions;
import com.azure.android.core.http.HttpPipeline;
import com.azure.android.core.rest.Callback;
import com.azure.android.core.rest.Response;
import com.azure.android.core.rest.RestProxy;
import com.azure.android.core.rest.annotation.BodyParam;
import com.azure.android.core.rest.annotation.Delete;
import com.azure.android.core.rest.annotation.ExpectedResponses;
import com.azure.android.core.rest.annotation.Get;
import com.azure.android.core.rest.annotation.HeaderParam;
import com.azure.android.core.rest.annotation.Host;
import com.azure.android.core.rest.annotation.HostParam;
import com.azure.android.core.rest.annotation.Patch;
import com.azure.android.core.rest.annotation.PathParam;
import com.azure.android.core.rest.annotation.Post;
import com.azure.android.core.rest.annotation.QueryParam;
import com.azure.android.core.rest.annotation.ServiceInterface;
import com.azure.android.core.rest.annotation.UnexpectedResponseExceptionType;
import com.azure.android.core.rest.annotation.UnexpectedResponseExceptionTypes;
import com.azure.android.core.rest.util.paging.PagedResponse;
import com.azure.android.core.rest.util.paging.PagedResponseBase;
import com.azure.android.core.serde.jackson.JacksonSerder;
import com.azure.android.core.util.RequestContext;
import java.util.concurrent.ExecutionException;
import java9.util.concurrent.CompletableFuture;
import java9.util.function.Function;
import org.threeten.bp.OffsetDateTime;

public final class ChatThreadImpl {
    private final ChatThreadsService service;
    private final AzureCommunicationChatServiceImpl client;

    ChatThreadImpl(AzureCommunicationChatServiceImpl client) {
        this.service = (ChatThreadsService)RestProxy.create(ChatThreadsService.class, (HttpPipeline)client.getHttpPipeline(), (JacksonSerder)client.getJacksonSerder());
        this.client = client;
    }

    public CompletableFuture<PagedResponse<ChatMessageReadReceipt>> listChatReadReceiptsSinglePageAsync(String chatThreadId, Integer maxPageSize, Integer skip) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatMessageReadReceiptsCollection)response.getValue()).getValue(), ((ChatMessageReadReceiptsCollection)response.getValue()).getNextLink(), null));
        this.service.listChatReadReceipts(this.client.getEndpoint(), chatThreadId, maxPageSize, skip, this.client.getApiVersion(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<PagedResponse<ChatMessageReadReceipt>> listChatReadReceiptsSinglePageAsync(String chatThreadId, Integer maxPageSize, Integer skip, RequestContext requestContext) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatMessageReadReceiptsCollection)response.getValue()).getValue(), ((ChatMessageReadReceiptsCollection)response.getValue()).getNextLink(), null));
        this.service.listChatReadReceipts(this.client.getEndpoint(), chatThreadId, maxPageSize, skip, this.client.getApiVersion(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<Void>> sendChatReadReceiptWithResponseAsync(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.sendChatReadReceipt(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendReadReceiptRequest, "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<Void>> sendChatReadReceiptWithResponseAsync(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.sendChatReadReceipt(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendReadReceiptRequest, "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Void> sendChatReadReceiptAsync(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest) {
        return this.sendChatReadReceiptWithResponseAsync(chatThreadId, sendReadReceiptRequest).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Void> sendChatReadReceiptAsync(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest, RequestContext requestContext) {
        return this.sendChatReadReceiptWithResponseAsync(chatThreadId, sendReadReceiptRequest, requestContext).thenApply(response -> (Void)response.getValue());
    }

    public void sendChatReadReceipt(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest) {
        try {
            this.sendChatReadReceiptAsync(chatThreadId, sendReadReceiptRequest).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<Void> sendChatReadReceiptWithResponse(String chatThreadId, SendReadReceiptRequest sendReadReceiptRequest, RequestContext requestContext) {
        try {
            return (Response)this.sendChatReadReceiptWithResponseAsync(chatThreadId, sendReadReceiptRequest, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Response<SendChatMessageResult>> sendChatMessageWithResponseAsync(String chatThreadId, SendChatMessageOptions sendChatMessageRequest) {
        String accept = "application/json";
        ResponseCompletableFuture<SendChatMessageResult> completableFuture = new ResponseCompletableFuture<SendChatMessageResult>();
        this.service.sendChatMessage(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendChatMessageRequest, "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<SendChatMessageResult>> sendChatMessageWithResponseAsync(String chatThreadId, SendChatMessageOptions sendChatMessageRequest, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<SendChatMessageResult> completableFuture = new ResponseCompletableFuture<SendChatMessageResult>();
        this.service.sendChatMessage(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendChatMessageRequest, "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<SendChatMessageResult> sendChatMessageAsync(String chatThreadId, SendChatMessageOptions sendChatMessageRequest) {
        return this.sendChatMessageWithResponseAsync(chatThreadId, sendChatMessageRequest).thenApply(response -> (SendChatMessageResult)response.getValue());
    }

    public CompletableFuture<SendChatMessageResult> sendChatMessageAsync(String chatThreadId, SendChatMessageOptions sendChatMessageRequest, RequestContext requestContext) {
        return this.sendChatMessageWithResponseAsync(chatThreadId, sendChatMessageRequest, requestContext).thenApply(response -> (SendChatMessageResult)response.getValue());
    }

    public SendChatMessageResult sendChatMessage(String chatThreadId, SendChatMessageOptions sendChatMessageRequest) {
        try {
            return (SendChatMessageResult)this.sendChatMessageAsync(chatThreadId, sendChatMessageRequest).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<SendChatMessageResult> sendChatMessageWithResponse(String chatThreadId, SendChatMessageOptions sendChatMessageRequest, RequestContext requestContext) {
        try {
            return (Response)this.sendChatMessageWithResponseAsync(chatThreadId, sendChatMessageRequest, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<PagedResponse<ChatMessage>> listChatMessagesSinglePageAsync(String chatThreadId, Integer maxPageSize, OffsetDateTime startTime) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatMessagesCollection)response.getValue()).getValue(), ((ChatMessagesCollection)response.getValue()).getNextLink(), null));
        this.service.listChatMessages(this.client.getEndpoint(), chatThreadId, maxPageSize, startTime, this.client.getApiVersion(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<PagedResponse<ChatMessage>> listChatMessagesSinglePageAsync(String chatThreadId, Integer maxPageSize, OffsetDateTime startTime, RequestContext requestContext) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatMessagesCollection)response.getValue()).getValue(), ((ChatMessagesCollection)response.getValue()).getNextLink(), null));
        this.service.listChatMessages(this.client.getEndpoint(), chatThreadId, maxPageSize, startTime, this.client.getApiVersion(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<ChatMessage>> getChatMessageWithResponseAsync(String chatThreadId, String chatMessageId) {
        String accept = "application/json";
        ResponseCompletableFuture<ChatMessage> completableFuture = new ResponseCompletableFuture<ChatMessage>();
        this.service.getChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<ChatMessage>> getChatMessageWithResponseAsync(String chatThreadId, String chatMessageId, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<ChatMessage> completableFuture = new ResponseCompletableFuture<ChatMessage>();
        this.service.getChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<ChatMessage> getChatMessageAsync(String chatThreadId, String chatMessageId) {
        return this.getChatMessageWithResponseAsync(chatThreadId, chatMessageId).thenApply(response -> (ChatMessage)response.getValue());
    }

    public CompletableFuture<ChatMessage> getChatMessageAsync(String chatThreadId, String chatMessageId, RequestContext requestContext) {
        return this.getChatMessageWithResponseAsync(chatThreadId, chatMessageId, requestContext).thenApply(response -> (ChatMessage)response.getValue());
    }

    public ChatMessage getChatMessage(String chatThreadId, String chatMessageId) {
        try {
            return (ChatMessage)this.getChatMessageAsync(chatThreadId, chatMessageId).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<ChatMessage> getChatMessageWithResponse(String chatThreadId, String chatMessageId, RequestContext requestContext) {
        try {
            return (Response)this.getChatMessageWithResponseAsync(chatThreadId, chatMessageId, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Response<Void>> updateChatMessageWithResponseAsync(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.updateChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), updateChatMessageRequest, "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<Void>> updateChatMessageWithResponseAsync(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.updateChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), updateChatMessageRequest, "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Void> updateChatMessageAsync(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest) {
        return this.updateChatMessageWithResponseAsync(chatThreadId, chatMessageId, updateChatMessageRequest).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Void> updateChatMessageAsync(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest, RequestContext requestContext) {
        return this.updateChatMessageWithResponseAsync(chatThreadId, chatMessageId, updateChatMessageRequest, requestContext).thenApply(response -> (Void)response.getValue());
    }

    public void updateChatMessage(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest) {
        try {
            this.updateChatMessageAsync(chatThreadId, chatMessageId, updateChatMessageRequest).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<Void> updateChatMessageWithResponse(String chatThreadId, String chatMessageId, UpdateChatMessageOptions updateChatMessageRequest, RequestContext requestContext) {
        try {
            return (Response)this.updateChatMessageWithResponseAsync(chatThreadId, chatMessageId, updateChatMessageRequest, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Response<Void>> deleteChatMessageWithResponseAsync(String chatThreadId, String chatMessageId) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.deleteChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<Void>> deleteChatMessageWithResponseAsync(String chatThreadId, String chatMessageId, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.deleteChatMessage(this.client.getEndpoint(), chatThreadId, chatMessageId, this.client.getApiVersion(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Void> deleteChatMessageAsync(String chatThreadId, String chatMessageId) {
        return this.deleteChatMessageWithResponseAsync(chatThreadId, chatMessageId).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Void> deleteChatMessageAsync(String chatThreadId, String chatMessageId, RequestContext requestContext) {
        return this.deleteChatMessageWithResponseAsync(chatThreadId, chatMessageId, requestContext).thenApply(response -> (Void)response.getValue());
    }

    public void deleteChatMessage(String chatThreadId, String chatMessageId) {
        try {
            this.deleteChatMessageAsync(chatThreadId, chatMessageId).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<Void> deleteChatMessageWithResponse(String chatThreadId, String chatMessageId, RequestContext requestContext) {
        try {
            return (Response)this.deleteChatMessageWithResponseAsync(chatThreadId, chatMessageId, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<PagedResponse<ChatParticipant>> listChatParticipantsSinglePageAsync(String chatThreadId, Integer maxPageSize, Integer skip) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatParticipantsCollection)response.getValue()).getValue(), ((ChatParticipantsCollection)response.getValue()).getNextLink(), null));
        this.service.listChatParticipants(this.client.getEndpoint(), chatThreadId, maxPageSize, skip, this.client.getApiVersion(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<PagedResponse<ChatParticipant>> listChatParticipantsSinglePageAsync(String chatThreadId, Integer maxPageSize, Integer skip, RequestContext requestContext) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatParticipantsCollection)response.getValue()).getValue(), ((ChatParticipantsCollection)response.getValue()).getNextLink(), null));
        this.service.listChatParticipants(this.client.getEndpoint(), chatThreadId, maxPageSize, skip, this.client.getApiVersion(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<Void>> removeChatParticipantWithResponseAsync(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.removeChatParticipant(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), participantCommunicationIdentifier, "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<Void>> removeChatParticipantWithResponseAsync(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.removeChatParticipant(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), participantCommunicationIdentifier, "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Void> removeChatParticipantAsync(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier) {
        return this.removeChatParticipantWithResponseAsync(chatThreadId, participantCommunicationIdentifier).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Void> removeChatParticipantAsync(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier, RequestContext requestContext) {
        return this.removeChatParticipantWithResponseAsync(chatThreadId, participantCommunicationIdentifier, requestContext).thenApply(response -> (Void)response.getValue());
    }

    public void removeChatParticipant(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier) {
        try {
            this.removeChatParticipantAsync(chatThreadId, participantCommunicationIdentifier).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<Void> removeChatParticipantWithResponse(String chatThreadId, CommunicationIdentifierModel participantCommunicationIdentifier, RequestContext requestContext) {
        try {
            return (Response)this.removeChatParticipantWithResponseAsync(chatThreadId, participantCommunicationIdentifier, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Response<AddChatParticipantsResult>> addChatParticipantsWithResponseAsync(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest) {
        String accept = "application/json";
        ResponseCompletableFuture<AddChatParticipantsResult> completableFuture = new ResponseCompletableFuture<AddChatParticipantsResult>();
        this.service.addChatParticipants(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), addChatParticipantsRequest, "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<AddChatParticipantsResult>> addChatParticipantsWithResponseAsync(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<AddChatParticipantsResult> completableFuture = new ResponseCompletableFuture<AddChatParticipantsResult>();
        this.service.addChatParticipants(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), addChatParticipantsRequest, "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<AddChatParticipantsResult> addChatParticipantsAsync(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest) {
        return this.addChatParticipantsWithResponseAsync(chatThreadId, addChatParticipantsRequest).thenApply(response -> (AddChatParticipantsResult)response.getValue());
    }

    public CompletableFuture<AddChatParticipantsResult> addChatParticipantsAsync(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest, RequestContext requestContext) {
        return this.addChatParticipantsWithResponseAsync(chatThreadId, addChatParticipantsRequest, requestContext).thenApply(response -> (AddChatParticipantsResult)response.getValue());
    }

    public AddChatParticipantsResult addChatParticipants(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest) {
        try {
            return (AddChatParticipantsResult)this.addChatParticipantsAsync(chatThreadId, addChatParticipantsRequest).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<AddChatParticipantsResult> addChatParticipantsWithResponse(String chatThreadId, AddChatParticipantsOptions addChatParticipantsRequest, RequestContext requestContext) {
        try {
            return (Response)this.addChatParticipantsWithResponseAsync(chatThreadId, addChatParticipantsRequest, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Response<Void>> updateChatThreadPropertiesWithResponseAsync(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.updateChatThreadProperties(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), updateChatThreadRequest, "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<Void>> updateChatThreadPropertiesWithResponseAsync(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.updateChatThreadProperties(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), updateChatThreadRequest, "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Void> updateChatThreadPropertiesAsync(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest) {
        return this.updateChatThreadPropertiesWithResponseAsync(chatThreadId, updateChatThreadRequest).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Void> updateChatThreadPropertiesAsync(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest, RequestContext requestContext) {
        return this.updateChatThreadPropertiesWithResponseAsync(chatThreadId, updateChatThreadRequest, requestContext).thenApply(response -> (Void)response.getValue());
    }

    public void updateChatThreadProperties(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest) {
        try {
            this.updateChatThreadPropertiesAsync(chatThreadId, updateChatThreadRequest).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<Void> updateChatThreadPropertiesWithResponse(String chatThreadId, UpdateChatThreadOptions updateChatThreadRequest, RequestContext requestContext) {
        try {
            return (Response)this.updateChatThreadPropertiesWithResponseAsync(chatThreadId, updateChatThreadRequest, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Response<ChatThreadProperties>> getChatThreadPropertiesWithResponseAsync(String chatThreadId) {
        String accept = "application/json";
        ResponseCompletableFuture<ChatThreadProperties> completableFuture = new ResponseCompletableFuture<ChatThreadProperties>();
        this.service.getChatThreadProperties(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<ChatThreadProperties>> getChatThreadPropertiesWithResponseAsync(String chatThreadId, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<ChatThreadProperties> completableFuture = new ResponseCompletableFuture<ChatThreadProperties>();
        this.service.getChatThreadProperties(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<ChatThreadProperties> getChatThreadPropertiesAsync(String chatThreadId) {
        return this.getChatThreadPropertiesWithResponseAsync(chatThreadId).thenApply(response -> (ChatThreadProperties)response.getValue());
    }

    public CompletableFuture<ChatThreadProperties> getChatThreadPropertiesAsync(String chatThreadId, RequestContext requestContext) {
        return this.getChatThreadPropertiesWithResponseAsync(chatThreadId, requestContext).thenApply(response -> (ChatThreadProperties)response.getValue());
    }

    public ChatThreadProperties getChatThreadProperties(String chatThreadId) {
        try {
            return (ChatThreadProperties)this.getChatThreadPropertiesAsync(chatThreadId).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<ChatThreadProperties> getChatThreadPropertiesWithResponse(String chatThreadId, RequestContext requestContext) {
        try {
            return (Response)this.getChatThreadPropertiesWithResponseAsync(chatThreadId, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<Response<Void>> sendTypingNotificationWithResponseAsync(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.sendTypingNotification(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendTypingNotificationRequest, "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Response<Void>> sendTypingNotificationWithResponseAsync(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest, RequestContext requestContext) {
        String accept = "application/json";
        ResponseCompletableFuture<Void> completableFuture = new ResponseCompletableFuture<Void>();
        this.service.sendTypingNotification(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), sendTypingNotificationRequest, "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<Void> sendTypingNotificationAsync(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest) {
        return this.sendTypingNotificationWithResponseAsync(chatThreadId, sendTypingNotificationRequest).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Void> sendTypingNotificationAsync(String chatThreadId) {
        TypingNotificationOptions sendTypingNotificationRequest = null;
        return this.sendTypingNotificationWithResponseAsync(chatThreadId, sendTypingNotificationRequest).thenApply(response -> (Void)response.getValue());
    }

    public CompletableFuture<Void> sendTypingNotificationAsync(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest, RequestContext requestContext) {
        return this.sendTypingNotificationWithResponseAsync(chatThreadId, sendTypingNotificationRequest, requestContext).thenApply(response -> (Void)response.getValue());
    }

    public void sendTypingNotification(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest) {
        try {
            this.sendTypingNotificationAsync(chatThreadId, sendTypingNotificationRequest).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendTypingNotification(String chatThreadId) {
        TypingNotificationOptions sendTypingNotificationRequest = null;
        try {
            this.sendTypingNotificationAsync(chatThreadId, sendTypingNotificationRequest).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<Void> sendTypingNotificationWithResponse(String chatThreadId, TypingNotificationOptions sendTypingNotificationRequest, RequestContext requestContext) {
        try {
            return (Response)this.sendTypingNotificationWithResponseAsync(chatThreadId, sendTypingNotificationRequest, requestContext).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<PagedResponse<ChatMessageReadReceipt>> listChatReadReceiptsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatMessageReadReceiptsCollection)response.getValue()).getValue(), ((ChatMessageReadReceiptsCollection)response.getValue()).getNextLink(), null));
        this.service.listChatReadReceiptsNext(nextLink, this.client.getEndpoint(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<PagedResponse<ChatMessageReadReceipt>> listChatReadReceiptsNextSinglePageAsync(String nextLink, RequestContext requestContext) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatMessageReadReceiptsCollection)response.getValue()).getValue(), ((ChatMessageReadReceiptsCollection)response.getValue()).getNextLink(), null));
        this.service.listChatReadReceiptsNext(nextLink, this.client.getEndpoint(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<PagedResponse<ChatMessage>> listChatMessagesNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatMessagesCollection)response.getValue()).getValue(), ((ChatMessagesCollection)response.getValue()).getNextLink(), null));
        this.service.listChatMessagesNext(nextLink, this.client.getEndpoint(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<PagedResponse<ChatMessage>> listChatMessagesNextSinglePageAsync(String nextLink, RequestContext requestContext) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatMessagesCollection)response.getValue()).getValue(), ((ChatMessagesCollection)response.getValue()).getNextLink(), null));
        this.service.listChatMessagesNext(nextLink, this.client.getEndpoint(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<PagedResponse<ChatParticipant>> listChatParticipantsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatParticipantsCollection)response.getValue()).getValue(), ((ChatParticipantsCollection)response.getValue()).getNextLink(), null));
        this.service.listChatParticipantsNext(nextLink, this.client.getEndpoint(), "application/json", RequestContext.NONE, completableFuture);
        return completableFuture;
    }

    public CompletableFuture<PagedResponse<ChatParticipant>> listChatParticipantsNextSinglePageAsync(String nextLink, RequestContext requestContext) {
        String accept = "application/json";
        PagedResponseCompletableFuture completableFuture = new PagedResponseCompletableFuture(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), ((ChatParticipantsCollection)response.getValue()).getValue(), ((ChatParticipantsCollection)response.getValue()).getNextLink(), null));
        this.service.listChatParticipantsNext(nextLink, this.client.getEndpoint(), "application/json", requestContext, completableFuture);
        return completableFuture;
    }

    private static final class PagedResponseCompletableFuture<P, T>
    extends CompletableFuture<PagedResponse<T>>
    implements Callback<Response<P>> {
        private final Function<Response<P>, PagedResponse<T>> converter;

        PagedResponseCompletableFuture(Function<Response<P>, PagedResponse<T>> converter) {
            this.converter = converter;
        }

        public void onSuccess(Response<P> response) {
            this.complete((PagedResponse)this.converter.apply(response));
        }

        public void onFailure(Throwable error) {
            this.completeExceptionally(error);
        }
    }

    private static final class ResponseCompletableFuture<T>
    extends CompletableFuture<Response<T>>
    implements Callback<Response<T>> {
        private ResponseCompletableFuture() {
        }

        public void onSuccess(Response<T> response) {
            this.complete(response);
        }

        public void onFailure(Throwable error) {
            this.completeExceptionally(error);
        }
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCh")
    private static interface ChatThreadsService {
        @Get(value="/chat/threads/{chatThreadId}/readReceipts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void listChatReadReceipts(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="maxPageSize") Integer var3, @QueryParam(value="skip") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestContext var7, Callback<Response<ChatMessageReadReceiptsCollection>> var8);

        @Post(value="/chat/threads/{chatThreadId}/readReceipts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void sendChatReadReceipt(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SendReadReceiptRequest var4, @HeaderParam(value="Accept") String var5, RequestContext var6, Callback<Response<Void>> var7);

        @Post(value="/chat/threads/{chatThreadId}/messages")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void sendChatMessage(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SendChatMessageOptions var4, @HeaderParam(value="Accept") String var5, RequestContext var6, Callback<Response<SendChatMessageResult>> var7);

        @Get(value="/chat/threads/{chatThreadId}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void listChatMessages(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="maxPageSize") Integer var3, @QueryParam(value="startTime") OffsetDateTime var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestContext var7, Callback<Response<ChatMessagesCollection>> var8);

        @Get(value="/chat/threads/{chatThreadId}/messages/{chatMessageId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void getChatMessage(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @PathParam(value="chatMessageId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestContext var6, Callback<Response<ChatMessage>> var7);

        @Patch(value="/chat/threads/{chatThreadId}/messages/{chatMessageId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void updateChatMessage(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @PathParam(value="chatMessageId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/merge-patch+json") UpdateChatMessageOptions var5, @HeaderParam(value="Accept") String var6, RequestContext var7, Callback<Response<Void>> var8);

        @Delete(value="/chat/threads/{chatThreadId}/messages/{chatMessageId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void deleteChatMessage(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @PathParam(value="chatMessageId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestContext var6, Callback<Response<Void>> var7);

        @Get(value="/chat/threads/{chatThreadId}/participants")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void listChatParticipants(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="maxPageSize") Integer var3, @QueryParam(value="skip") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, RequestContext var7, Callback<Response<ChatParticipantsCollection>> var8);

        @Post(value="/chat/threads/{chatThreadId}/participants/:remove")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void removeChatParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CommunicationIdentifierModel var4, @HeaderParam(value="Accept") String var5, RequestContext var6, Callback<Response<Void>> var7);

        @Post(value="/chat/threads/{chatThreadId}/participants/:add")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void addChatParticipants(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") AddChatParticipantsOptions var4, @HeaderParam(value="Accept") String var5, RequestContext var6, Callback<Response<AddChatParticipantsResult>> var7);

        @Patch(value="/chat/threads/{chatThreadId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void updateChatThreadProperties(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/merge-patch+json") UpdateChatThreadOptions var4, @HeaderParam(value="Accept") String var5, RequestContext var6, Callback<Response<Void>> var7);

        @Get(value="/chat/threads/{chatThreadId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void getChatThreadProperties(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestContext var5, Callback<Response<ChatThreadProperties>> var6);

        @Post(value="/chat/threads/{chatThreadId}/typing")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void sendTypingNotification(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") TypingNotificationOptions var4, @HeaderParam(value="Accept") String var5, RequestContext var6, Callback<Response<Void>> var7);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void listChatReadReceiptsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestContext var4, Callback<Response<ChatMessageReadReceiptsCollection>> var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void listChatMessagesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestContext var4, Callback<Response<ChatMessagesCollection>> var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)})
        public void listChatParticipantsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestContext var4, Callback<Response<ChatParticipantsCollection>> var5);
    }
}

