/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation.notifications.fcm;

import com.azure.android.core.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class KeyMetaDataStore {
    private Map<String, KeyMetaDataEntry> map;
    private ClientLogger clientLogger = new ClientLogger(KeyMetaDataStore.class);

    public KeyMetaDataStore() {
        this.map = new HashMap<String, KeyMetaDataEntry>();
    }

    public int getSize() {
        return this.map.size();
    }

    public void load(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            this.map = (Map)new ObjectMapper().readValue(inputStream, (TypeReference)new TypeReference<Map<String, KeyMetaDataEntry>>(){});
        }
        catch (IOException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to load registration key metadata from the file system", e));
        }
    }

    private void writeJsonToFile(String path) {
        File outputFile = new File(path);
        try {
            boolean newFile = outputFile.createNewFile();
            if (newFile) {
                this.clientLogger.verbose("new file created for storing push notification credentials");
            }
        }
        catch (IOException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to create key store file", e));
        }
        String jsonStr = "";
        try {
            jsonStr = new ObjectMapper().writeValueAsString(this.map);
        }
        catch (JsonProcessingException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to generate JSON object", e));
        }
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            byte[] bytes = jsonStr.getBytes(StandardCharsets.UTF_8);
            bos.write(bytes);
        }
        catch (IOException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Filed writing key map to file", e));
        }
    }

    public void deleteEntry(String filePath, String alias) {
        this.map.remove(alias);
        this.writeJsonToFile(filePath);
    }

    public Long getCreationTime(String alias) {
        if (!this.map.containsKey(alias)) {
            return null;
        }
        return this.map.get(alias).creationTime;
    }

    public KeyMetaDataEntry getEntry(String alias) {
        return this.map.get(alias);
    }

    public void storeKeyEntry(String filePath, String alias, KeyMetaDataEntry keyMetaDataEntry) {
        this.map.put(alias, keyMetaDataEntry);
        this.writeJsonToFile(filePath);
    }

    public Set<String> getAliases() {
        return this.map.keySet();
    }

    public static class KeyMetaDataEntry {
        @JsonProperty(value="iv")
        private byte[] iv;
        @JsonProperty(value="ciphertext")
        private byte[] ciphertext;
        private long creationTime;

        public KeyMetaDataEntry() {
        }

        public byte[] getIV() {
            return (byte[])this.iv.clone();
        }

        public byte[] getCiphertext() {
            return (byte[])this.ciphertext.clone();
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public KeyMetaDataEntry(byte[] iv, byte[] ciphertext, long creationTime) {
            this.iv = (byte[])iv.clone();
            this.ciphertext = (byte[])ciphertext.clone();
            this.creationTime = creationTime;
        }
    }
}

