/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation.notifications.fcm;

import android.util.Pair;
import androidx.work.BackoffPolicy;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;
import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.implementation.notifications.fcm.RegistrarClient;
import com.azure.android.communication.chat.implementation.notifications.fcm.RegistrationKeyManager;
import com.azure.android.communication.chat.implementation.notifications.fcm.RegistrationRenewalWorker;
import com.azure.android.communication.chat.models.ChatEvent;
import com.azure.android.communication.chat.models.ChatEventType;
import com.azure.android.communication.chat.models.ChatPushNotification;
import com.azure.android.communication.common.CommunicationAccessToken;
import com.azure.android.communication.common.CommunicationTokenCredential;
import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.util.Base64Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java9.util.function.Consumer;
import javax.crypto.SecretKey;
import org.json.JSONObject;

public class PushNotificationClient {
    private final ClientLogger logger = new ClientLogger(PushNotificationClient.class);
    private final CommunicationTokenCredential communicationTokenCredential;
    private final RegistrarClient registrarClient;
    private final Map<ChatEventType, Set<Consumer<ChatEvent>>> pushNotificationListeners;
    private boolean isPushNotificationsStarted;
    private String deviceRegistrationToken;
    private Timer registrationRenewScheduleTimer;
    private WorkManager workManager;
    private RegistrationKeyManager registrationKeyManager;

    public PushNotificationClient(CommunicationTokenCredential communicationTokenCredential) {
        this.communicationTokenCredential = communicationTokenCredential;
        this.pushNotificationListeners = new HashMap<ChatEventType, Set<Consumer<ChatEvent>>>();
        this.isPushNotificationsStarted = false;
        this.registrarClient = new RegistrarClient();
        this.deviceRegistrationToken = null;
        this.registrationRenewScheduleTimer = null;
    }

    public boolean hasStarted() {
        return this.isPushNotificationsStarted;
    }

    @Deprecated
    public void startPushNotifications(String deviceRegistrationToken, Consumer<Throwable> errorHandler) {
        this.deviceRegistrationToken = deviceRegistrationToken;
        this.logger.verbose("device_id: " + deviceRegistrationToken);
        if (this.isPushNotificationsStarted) {
            return;
        }
        this.workManager = WorkManager.getInstance();
        this.registrationKeyManager = RegistrationKeyManager.instance();
        this.isPushNotificationsStarted = true;
        this.pushNotificationListeners.clear();
        this.logger.info("Successfully started push notifications!");
        long interval = 15L;
        this.startRegistrationRenewalWorker(interval, errorHandler);
    }

    public void startPushNotifications(String deviceRegistrationToken) {
        this.deviceRegistrationToken = deviceRegistrationToken;
        this.logger.verbose("device_id: " + deviceRegistrationToken);
        if (this.isPushNotificationsStarted) {
            return;
        }
        this.workManager = WorkManager.getInstance();
        this.registrationKeyManager = RegistrationKeyManager.instance();
        this.isPushNotificationsStarted = true;
        this.pushNotificationListeners.clear();
        this.logger.info("Successfully started push notifications!");
        long interval = 15L;
        this.startRegistrationRenewalWorker(interval, null);
    }

    public void stopPushNotifications() {
        if (!this.isPushNotificationsStarted) {
            return;
        }
        try {
            String skypeUserToken;
            try {
                skypeUserToken = ((CommunicationAccessToken)this.communicationTokenCredential.getToken().get()).getToken();
            }
            catch (InterruptedException | ExecutionException e) {
                throw this.logger.logExceptionAsError(new RuntimeException("Get skype user token failed for push notification: " + e.getMessage()));
            }
            try {
                this.registrarClient.unregister(skypeUserToken);
                this.logger.info("Successfully stopped push notification!");
            }
            catch (Throwable throwable) {
                throw this.logger.logExceptionAsError(new RuntimeException(throwable));
            }
        }
        catch (RuntimeException e) {
            this.logger.warning("Unregistered push notification with error: " + e.getMessage() + ". Would just clear local push notification listeners.");
        }
        this.isPushNotificationsStarted = false;
        this.pushNotificationListeners.clear();
        if (this.registrationRenewScheduleTimer != null) {
            this.registrationRenewScheduleTimer.cancel();
            this.registrationRenewScheduleTimer = null;
        }
        if (this.workManager != null) {
            this.workManager.cancelAllWork();
        }
    }

    public boolean handlePushNotification(ChatPushNotification pushNotification) {
        this.logger.info(" Receive handle push notification request.");
        ChatEventType chatEventType = this.parsePushNotificationEventType(pushNotification);
        this.logger.info(" " + (Object)((Object)chatEventType) + " received.");
        if (this.pushNotificationListeners.containsKey((Object)chatEventType)) {
            ChatEvent event = this.parsePushNotificationEvent(chatEventType, pushNotification);
            Set<Consumer<ChatEvent>> callbacks = this.pushNotificationListeners.get((Object)chatEventType);
            for (Consumer<ChatEvent> callback : callbacks) {
                this.logger.info(" invoke callback " + callback + " for " + (Object)((Object)chatEventType));
                callback.accept((Object)event);
            }
            return true;
        }
        return false;
    }

    public void addPushNotificationHandler(ChatEventType chatEventType, Consumer<ChatEvent> listener) {
        this.logger.info(" Add push notification handler.");
        Set<Consumer<ChatEvent>> callbacks = this.pushNotificationListeners.containsKey((Object)chatEventType) ? this.pushNotificationListeners.get((Object)chatEventType) : new HashSet<Consumer<ChatEvent>>();
        callbacks.add(listener);
        this.pushNotificationListeners.put(chatEventType, callbacks);
    }

    public void removePushNotificationHandler(ChatEventType chatEventType, Consumer<ChatEvent> listener) {
        if (this.pushNotificationListeners.containsKey((Object)chatEventType)) {
            Set<Consumer<ChatEvent>> callbacks = this.pushNotificationListeners.get((Object)chatEventType);
            callbacks.remove(listener);
            if (callbacks.isEmpty()) {
                this.pushNotificationListeners.remove((Object)chatEventType);
            } else {
                this.pushNotificationListeners.put(chatEventType, callbacks);
            }
        }
    }

    private ChatEventType parsePushNotificationEventType(ChatPushNotification pushNotification) {
        int eventId;
        if (pushNotification.getPayload().containsKey("eventId") && NotificationUtils.isValidEventId(eventId = Integer.parseInt(pushNotification.getPayload().get("eventId")))) {
            return NotificationUtils.getChatEventTypeByEventId(eventId);
        }
        throw this.logger.logExceptionAsError(new RuntimeException("Invalid push notification payload."));
    }

    private ChatEvent parsePushNotificationEvent(ChatEventType chatEventType, ChatPushNotification pushNotification) {
        String decrypted;
        this.logger.verbose(" Try Jsonlize input.");
        JSONObject obj = new JSONObject(pushNotification.getPayload());
        try {
            String encrypted = obj.getString("e");
            this.logger.verbose(" Encrypted payload: " + encrypted);
            decrypted = this.decryptPayload(encrypted);
            this.logger.verbose(" Decrypted payload: " + decrypted);
        }
        catch (Throwable e) {
            throw this.logger.logExceptionAsError(new RuntimeException("Failed to parse push notification payload: " + e));
        }
        return NotificationUtils.toEventPayload(chatEventType, decrypted);
    }

    private void startRegistrationRenewalWorker(long intervalInMinutes, Consumer<Throwable> errorHandler) {
        this.logger.info("Initialize RegistrationRenewalWorker in background");
        Data inputData = new Data.Builder().putString("deviceRegistrationToken", this.deviceRegistrationToken).build();
        PeriodicWorkRequest renewTokenRequest = (PeriodicWorkRequest)((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(RegistrationRenewalWorker.class, intervalInMinutes, TimeUnit.MINUTES).setBackoffCriteria(BackoffPolicy.LINEAR, 10L, TimeUnit.SECONDS)).setInputData(inputData)).build();
        this.workManager.cancelAllWork();
        this.workManager.enqueueUniquePeriodicWork("Renewal push notification registration", ExistingPeriodicWorkPolicy.REPLACE, renewTokenRequest);
        this.workManager.getWorkInfoByIdLiveData(renewTokenRequest.getId()).observeForever(workInfo -> {
            if (workInfo != null && workInfo.getState() == WorkInfo.State.ENQUEUED) {
                boolean succeeded = this.registrationKeyManager.getLastExecutionSucceeded();
                if (!succeeded) {
                    RuntimeException exception = new RuntimeException("Registration renew request failed");
                    if (errorHandler != null) {
                        errorHandler.accept((Object)exception);
                    }
                    this.logger.info("Renew token failed");
                } else {
                    this.logger.info("Renew token succeeded");
                }
            }
        });
    }

    private String decryptPayload(String encryptedPayload) throws Throwable {
        this.logger.verbose(" Decrypting payload.");
        Queue<Pair<SecretKey, SecretKey>> registrationKeyEntries = this.registrationKeyManager.getAllPairs();
        byte[] encryptedBytes = Base64Util.decodeString((String)encryptedPayload);
        byte[] encryptionKey = NotificationUtils.extractEncryptionKey(encryptedBytes);
        byte[] iv = NotificationUtils.extractInitializationVector(encryptedBytes);
        byte[] ciphertext = NotificationUtils.extractCipherText(encryptedBytes);
        byte[] hmac = NotificationUtils.extractHmac(encryptedBytes);
        while (!registrationKeyEntries.isEmpty()) {
            Pair<SecretKey, SecretKey> pair = registrationKeyEntries.poll();
            SecretKey cryptoKey = (SecretKey)pair.first;
            SecretKey authKey = (SecretKey)pair.second;
            if (!NotificationUtils.verifyEncryptedPayload(encryptionKey, iv, ciphertext, hmac, authKey)) continue;
            return NotificationUtils.decryptPushNotificationPayload(iv, ciphertext, cryptoKey);
        }
        throw this.logger.logExceptionAsError(new RuntimeException("Invalid encrypted push notification payload. Dropped the request!"));
    }
}

