/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation.notifications.fcm;

import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.core.http.HttpCallback;
import com.azure.android.core.http.HttpClient;
import com.azure.android.core.http.HttpMethod;
import com.azure.android.core.http.HttpRequest;
import com.azure.android.core.http.HttpResponse;
import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.serde.jackson.JacksonSerder;
import com.azure.android.core.serde.jackson.SerdeEncoding;
import com.azure.android.core.util.Base64Util;
import com.azure.android.core.util.CancellationToken;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;

public class RegistrarClient {
    private static final String SKYPE_TOKEN_HEADER = "X-Skypetoken";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String ENCRYPTION_KEY = "0x70";
    private static final String NODE_ID = "";
    private final ClientLogger logger = new ClientLogger(RegistrarClient.class);
    private final HttpClient httpClient = HttpClient.createDefault();
    private final JacksonSerder jacksonSerder = JacksonSerder.createDefault();
    private String registrationId;

    RegistrarClient() {
    }

    public void register(String skypeUserToken, String deviceRegistrationToken, SecretKey cryptoKey, SecretKey authKey) throws Throwable {
        String registrarServiceUrl = this.getRegistrarServiceUrl(skypeUserToken);
        HttpRequest request = new HttpRequest(HttpMethod.POST, registrarServiceUrl);
        request.setHeader(USER_AGENT_HEADER, "0.0.0.0").setHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_JSON).setHeader(SKYPE_TOKEN_HEADER, skypeUserToken);
        this.addRequestBody(request, deviceRegistrationToken, cryptoKey, authKey);
        final CountDownLatch latch = new CountDownLatch(1);
        final Throwable[] requestError = new Throwable[]{null};
        this.httpClient.send(request, CancellationToken.NONE, new HttpCallback(){

            public void onSuccess(HttpResponse response) {
                int statusCode = response.getStatusCode();
                RegistrarClient.this.logger.info("Registrar register http response code:" + statusCode);
                if (statusCode != 202) {
                    requestError[0] = new RuntimeException("Registrar register request failed with http status code " + statusCode + ". Error message: " + response.getBodyAsString());
                }
                latch.countDown();
            }

            public void onError(Throwable error) {
                requestError[0] = error;
                latch.countDown();
            }
        });
        this.awaitOnLatch(latch);
        if (requestError[0] != null) {
            throw this.logger.logThrowableAsError(requestError[0]);
        }
        this.logger.info("Register succeed! RegistrationId:" + this.registrationId);
    }

    public void unregister(String skypeUserToken) throws Throwable {
        if (this.registrationId == null) {
            return;
        }
        String registrarServiceUrl = this.getRegistrarServiceUrl(skypeUserToken);
        String unregisterUrl = registrarServiceUrl + "/" + this.registrationId;
        HttpRequest request = new HttpRequest(HttpMethod.DELETE, unregisterUrl);
        request.setHeader(USER_AGENT_HEADER, "0.0.0.0").setHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_JSON).setHeader(SKYPE_TOKEN_HEADER, skypeUserToken);
        final CountDownLatch latch = new CountDownLatch(1);
        final Throwable[] requestError = new Throwable[]{null};
        this.httpClient.send(request, CancellationToken.NONE, new HttpCallback(){

            public void onSuccess(HttpResponse response) {
                int statusCode = response.getStatusCode();
                RegistrarClient.this.logger.info("Registrar unregister http response code:" + statusCode);
                if (statusCode != 202) {
                    requestError[0] = new RuntimeException("Registrar unregister request failed with http status code " + statusCode + ". Error message: " + response.getBodyAsString());
                }
                latch.countDown();
            }

            public void onError(Throwable error) {
                requestError[0] = error;
                latch.countDown();
            }
        });
        this.awaitOnLatch(latch);
        if (requestError[0] != null) {
            throw this.logger.logThrowableAsError(requestError[0]);
        }
        this.logger.info("Unregister succeed! RegistrationId:" + this.registrationId);
    }

    private void addRequestBody(HttpRequest request, String deviceRegistrationToken, SecretKey cryptoKey, SecretKey authKey) {
        this.registrationId = UUID.randomUUID().toString();
        ClientDescription clientDescription = new ClientDescription();
        clientDescription.languageId = NODE_ID;
        clientDescription.platform = "Android";
        clientDescription.platformUIVersion = "0.0.0.0";
        clientDescription.applicationId = "AcsAndroid";
        clientDescription.templateKey = "AcsAndroid.AcsNotify_Chat_2.0";
        clientDescription.aesKey = Base64Util.encodeToString((byte[])cryptoKey.getEncoded());
        clientDescription.authKey = Base64Util.encodeToString((byte[])authKey.getEncoded());
        clientDescription.cryptoMethod = ENCRYPTION_KEY;
        Transports transports = new Transports();
        transports.fcm = new ArrayList();
        FcmTransport transport = new FcmTransport();
        transport.creationTime = NODE_ID;
        transport.context = NODE_ID;
        transport.path = deviceRegistrationToken;
        transport.ttl = "2700";
        transports.fcm.add(transport);
        RegistrarRequestBody registrarRequestBody = new RegistrarRequestBody();
        registrarRequestBody.clientDescription = clientDescription;
        registrarRequestBody.nodeId = NODE_ID;
        registrarRequestBody.registrationId = this.registrationId;
        registrarRequestBody.transports = transports;
        try {
            String body = this.jacksonSerder.serialize((Object)registrarRequestBody, SerdeEncoding.JSON);
            request.setBody(body);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }

    private boolean awaitOnLatch(CountDownLatch latch) {
        long timeoutInMin = 1L;
        try {
            return latch.await(timeoutInMin, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw this.logger.logExceptionAsError(new RuntimeException("Operation didn't complete within " + timeoutInMin + " minutes"));
        }
    }

    private String getRegistrarServiceUrl(String skypeUserToken) {
        String registrarUrl;
        NotificationUtils.CloudType cloudType = NotificationUtils.getUserCloudTypeFromSkypeToken(skypeUserToken);
        switch (cloudType) {
            case Dod: {
                registrarUrl = "https://dod.teams.microsoft.us/v2/registrations";
                break;
            }
            case Gcch: {
                registrarUrl = "https://gov.teams.microsoft.us/v2/registrations";
                break;
            }
            default: {
                registrarUrl = "https://edge.skype.com/registrar/prod/v2/registrations";
            }
        }
        return registrarUrl;
    }

    private static class RegistrarRequestBody {
        @JsonProperty(value="clientDescription")
        private ClientDescription clientDescription;
        @JsonProperty(value="nodeId")
        private String nodeId;
        @JsonProperty(value="registrationId")
        private String registrationId;
        @JsonProperty(value="transports")
        private Transports transports;

        private RegistrarRequestBody() {
        }
    }

    private static class Transports {
        @JsonProperty(value="FCM")
        private List<FcmTransport> fcm;

        private Transports() {
        }
    }

    private static class FcmTransport {
        @JsonProperty(value="context")
        private String context;
        @JsonProperty(value="creationTime")
        private String creationTime;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="ttl")
        private String ttl;

        private FcmTransport() {
        }
    }

    private static class ClientDescription {
        @JsonProperty(value="languageId")
        private String languageId;
        @JsonProperty(value="platform")
        private String platform;
        @JsonProperty(value="platformUIVersion")
        private String platformUIVersion;
        @JsonProperty(value="appId")
        private String applicationId;
        @JsonProperty(value="templateKey")
        private String templateKey;
        @JsonProperty(value="cryptoMethod")
        private String cryptoMethod;
        @JsonProperty(value="aesKey")
        private String aesKey;
        @JsonProperty(value="authKey")
        private String authKey;

        private ClientDescription() {
        }
    }
}

