/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation.notifications.fcm;

import android.content.Context;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.azure.android.communication.chat.implementation.notifications.fcm.KeyMetaDataStore;
import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.util.Base64Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class RegistrationKeyManager {
    private static RegistrationKeyManager registrationKeyManager;
    private KeyGenerator androidKeyGenerator;
    private KeyGenerator secretKeyGenerator;
    private KeyStore keyStore;
    private KeyMetaDataStore keyMetaDataStore;
    private Encryptor encryptor;
    private Decryptor decryptor;
    private boolean lastExecutionSucceeded = true;
    public static final int EXPIRATION_TIME_MINUTES = 45;
    public static final String CRYPTO_KEY_PREFIX = "CRYPTO_KEY_";
    public static final String AUTH_KEY_PREFIX = "AUTH_KEY_";
    public static final String KEY_CREATION_TIME_POSTFIX = "/key-creation-time-store";
    private ClientLogger clientLogger = new ClientLogger(RegistrationKeyManager.class);

    private RegistrationKeyManager() {
        this.encryptor = new Encryptor();
        this.decryptor = new Decryptor();
        try {
            this.secretKeyGenerator = KeyGenerator.getInstance("AES");
            this.secretKeyGenerator.init(256);
            this.androidKeyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("KeyGenerator failed: " + e.getMessage()));
        }
        try {
            this.keyStore = KeyStore.getInstance("AndroidKeyStore");
        }
        catch (KeyStoreException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to initialize key store", e));
        }
        this.keyMetaDataStore = new KeyMetaDataStore();
    }

    private void setUpAndroidKeyGenerator(String alias) {
        try {
            this.androidKeyGenerator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(alias, 3).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).build());
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegistrationKeyManager instance() {
        if (registrationKeyManager != null) return registrationKeyManager;
        Class<RegistrationKeyManager> clazz = RegistrationKeyManager.class;
        synchronized (RegistrationKeyManager.class) {
            if (registrationKeyManager != null) return registrationKeyManager;
            registrationKeyManager = new RegistrationKeyManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return registrationKeyManager;
        }
    }

    public void setLastExecutionSucceeded(boolean bool) {
        this.lastExecutionSucceeded = bool;
    }

    public boolean getLastExecutionSucceeded() {
        return this.lastExecutionSucceeded;
    }

    private int getNumOfPairs() {
        int numKeyPairs = 0;
        try {
            numKeyPairs = Math.max(this.keyStore.size(), this.keyMetaDataStore.getSize()) / 2;
        }
        catch (Exception e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to get size from key store", e));
        }
        return numKeyPairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshCredentials(String directoryPath, Context context) {
        Class<RegistrationKeyManager> clazz = RegistrationKeyManager.class;
        synchronized (RegistrationKeyManager.class) {
            this.clientLogger.info("Refresh credentials");
            this.load(directoryPath);
            this.rotateKeys(directoryPath, context);
            int index = this.getNumOfPairs();
            String cryptoAlias = CRYPTO_KEY_PREFIX + index;
            String authAlias = AUTH_KEY_PREFIX + index;
            long currentTimeMillis = System.currentTimeMillis();
            this.storeSecretKey(cryptoAlias, directoryPath, currentTimeMillis, this.secretKeyGenerator.generateKey(), context);
            this.storeSecretKey(authAlias, directoryPath, currentTimeMillis, this.secretKeyGenerator.generateKey(), context);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private int extractIndex(String alias) {
        if (alias.indexOf(CRYPTO_KEY_PREFIX) == 0) {
            return Integer.parseInt(alias.substring(alias.lastIndexOf(95) + 1));
        }
        return Integer.parseInt(alias.substring(alias.lastIndexOf(95) + 1));
    }

    private void rotateKeys(String directoryPath, Context context) {
        Object aliases;
        int removed = 0;
        HashSet<Integer> set = new HashSet<Integer>();
        HashSet<Integer> removedSet = new HashSet<Integer>();
        try {
            aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                set.add(this.extractIndex(aliases.nextElement()));
            }
        }
        catch (KeyStoreException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed iterate key-store", e));
        }
        aliases = this.keyMetaDataStore.getAliases();
        Iterator iterator = aliases.iterator();
        while (iterator.hasNext()) {
            String alias = (String)iterator.next();
            set.add(this.extractIndex(alias));
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            long currentTime;
            long diffInMinutes;
            int curIndex = (Integer)iterator.next();
            String cryptoKeyAlias = CRYPTO_KEY_PREFIX + curIndex;
            String authKeyAlias = AUTH_KEY_PREFIX + curIndex;
            Long insertionTime = this.getCreationTime(cryptoKeyAlias);
            if (insertionTime == null) {
                insertionTime = 0L;
            }
            if ((diffInMinutes = ((currentTime = System.currentTimeMillis()) - insertionTime) / 60000L) <= 45L && !this.anyEntryMissed(cryptoKeyAlias, authKeyAlias)) continue;
            try {
                this.deleteKeyFromFiles(cryptoKeyAlias, directoryPath);
                this.deleteKeyFromFiles(authKeyAlias, directoryPath);
                removedSet.add(curIndex);
                ++removed;
            }
            catch (Exception e) {
                throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to delete entry from key-store with index: " + curIndex, e));
            }
        }
        set.removeAll(removedSet);
        int toIndex = 0;
        if (removed == 0) {
            return;
        }
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            int fromIndex = (Integer)iterator2.next();
            String fromCryptoAlias = CRYPTO_KEY_PREFIX + fromIndex;
            String fromAuthAlias = AUTH_KEY_PREFIX + fromIndex;
            if (toIndex == fromIndex) {
                ++toIndex;
                continue;
            }
            String toCryptoAlias = CRYPTO_KEY_PREFIX + toIndex;
            String toAuthAlias = AUTH_KEY_PREFIX + toIndex;
            this.moveAnEntry(fromCryptoAlias, toCryptoAlias, directoryPath, context);
            this.moveAnEntry(fromAuthAlias, toAuthAlias, directoryPath, context);
            this.deleteKeyFromFiles(fromCryptoAlias, directoryPath);
            this.deleteKeyFromFiles(fromAuthAlias, directoryPath);
            ++toIndex;
        }
    }

    private boolean anyEntryMissed(String cryptoKeyAlias, String authKeyAlias) {
        boolean cryptoKeyMissing = this.getSecretKey(cryptoKeyAlias) == null;
        boolean authKeyMissing = this.getSecretKey(authKeyAlias) == null;
        boolean cryptoDataMissing = this.keyMetaDataStore.getEntry(cryptoKeyAlias) == null;
        boolean authDataMissing = this.keyMetaDataStore.getEntry(authKeyAlias) == null;
        return cryptoKeyMissing | authKeyMissing | cryptoDataMissing | authDataMissing;
    }

    private void load(String directoryPath) {
        try {
            this.keyStore.load(null, null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to load key store", e));
        }
        String keyCreationTimeStorePath = directoryPath + KEY_CREATION_TIME_POSTFIX;
        try (FileInputStream fis2 = new File(keyCreationTimeStorePath).exists() ? new FileInputStream(keyCreationTimeStorePath) : null;){
            this.keyMetaDataStore.load(fis2);
        }
        catch (IOException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to load key creation time store", e));
        }
    }

    private void deleteKeyFromFiles(String alias, String directoryPath) {
        try {
            this.keyStore.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to delete entry from key-store with alias: " + alias, e));
        }
        String keyMetaDataStorePath = directoryPath + KEY_CREATION_TIME_POSTFIX;
        try {
            this.keyMetaDataStore.deleteEntry(keyMetaDataStorePath, alias);
        }
        catch (Exception e) {
            RuntimeException runtimeException = new RuntimeException("keyMetaDataStore failed to delete entry");
            throw this.clientLogger.logExceptionAsError(runtimeException);
        }
    }

    public Long getCreationTime(String alias) {
        return this.keyMetaDataStore.getCreationTime(alias);
    }

    public SecretKey getSecretKey(String alias) {
        KeyStore.SecretKeyEntry pkEntry = null;
        try {
            pkEntry = (KeyStore.SecretKeyEntry)this.keyStore.getEntry(alias, null);
        }
        catch (Exception e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to get secret key", e));
        }
        if (pkEntry == null) {
            return null;
        }
        SecretKey secretKey = pkEntry.getSecretKey();
        return secretKey;
    }

    private void moveAnEntry(String fromAlias, String toAlias, String directoryPath, Context context) {
        KeyMetaDataStore.KeyMetaDataEntry entry = this.keyMetaDataStore.getEntry(fromAlias);
        SecretKey recoveredKey = this.recoverSecretKey(fromAlias, entry);
        this.storeSecretKey(toAlias, directoryPath, entry.getCreationTime(), recoveredKey, context);
    }

    @NonNull
    private SecretKey recoverSecretKey(String alias, KeyMetaDataStore.KeyMetaDataEntry entry) {
        SecretKey androidSecretKey = null;
        try {
            androidSecretKey = (SecretKey)this.keyStore.getKey(alias, null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to restore secret key", e));
        }
        String decrypted = this.decryptor.decrypt(androidSecretKey, entry.getCiphertext(), entry.getIV());
        SecretKey recoveredKey = this.secretKeyFromStr(decrypted);
        return recoveredKey;
    }

    private void storeSecretKey(String alias, String directoryPath, long timeInMilli, SecretKey secretKey, Context context) {
        this.setUpAndroidKeyGenerator(alias);
        this.androidKeyGenerator.generateKey();
        try {
            this.encryptor.encrypt((SecretKey)this.keyStore.getKey(alias, null), this.secretKeyToStr(secretKey));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw this.clientLogger.logExceptionAsError(new RuntimeException("Failed to store secret key", e));
        }
        byte[] encryptedText = this.encryptor.ciphertext;
        byte[] iv = this.encryptor.iv;
        String keyCreationTimeStorePath = directoryPath + KEY_CREATION_TIME_POSTFIX;
        KeyMetaDataStore.KeyMetaDataEntry entry = new KeyMetaDataStore.KeyMetaDataEntry(iv, encryptedText, timeInMilli);
        this.keyMetaDataStore.storeKeyEntry(keyCreationTimeStorePath, alias, entry);
    }

    private String secretKeyToStr(SecretKey secretKey) {
        return Base64Util.encodeToString((byte[])secretKey.getEncoded());
    }

    public Pair<SecretKey, SecretKey> getOnePair(int index) {
        String cryptoAlias = CRYPTO_KEY_PREFIX + index;
        String authAlias = AUTH_KEY_PREFIX + index;
        KeyMetaDataStore.KeyMetaDataEntry cryptoEntry = this.keyMetaDataStore.getEntry(cryptoAlias);
        KeyMetaDataStore.KeyMetaDataEntry authEntry = this.keyMetaDataStore.getEntry(authAlias);
        SecretKey cryptoKey = this.recoverSecretKey(cryptoAlias, cryptoEntry);
        SecretKey authKey = this.recoverSecretKey(authAlias, authEntry);
        return new Pair((Object)cryptoKey, (Object)authKey);
    }

    public Pair<SecretKey, SecretKey> getLastPair() {
        int lastIndex = this.getNumOfPairs() - 1;
        return this.getOnePair(lastIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<Pair<SecretKey, SecretKey>> getAllPairs() {
        Class<RegistrationKeyManager> clazz = RegistrationKeyManager.class;
        synchronized (RegistrationKeyManager.class) {
            int pairs = this.getNumOfPairs() - 1;
            LinkedList<Pair<SecretKey, SecretKey>> res = new LinkedList<Pair<SecretKey, SecretKey>>();
            for (int i = pairs; i >= 0; --i) {
                Pair<SecretKey, SecretKey> pair = this.getOnePair(i);
                res.offer(pair);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return res;
        }
    }

    private SecretKey secretKeyFromStr(String str) {
        byte[] bytes = Base64Util.decodeString((String)str);
        return new SecretKeySpec(bytes, 0, bytes.length, "AES");
    }

    class Decryptor {
        private static final String TRANSFORMATION_SYMMETRIC = "AES/GCM/NoPadding";

        Decryptor() {
        }

        String decrypt(Key decryptionKey, byte[] ciphertext, byte[] encryptionIv) {
            try {
                Cipher cipher = Cipher.getInstance(TRANSFORMATION_SYMMETRIC);
                GCMParameterSpec spec = new GCMParameterSpec(128, encryptionIv);
                cipher.init(2, decryptionKey, spec);
                return new String(cipher.doFinal(ciphertext), "UTF-8");
            }
            catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw RegistrationKeyManager.this.clientLogger.logExceptionAsError(new RuntimeException("Failed to decrypt data", e));
            }
        }
    }

    class Encryptor {
        private byte[] ciphertext;
        private byte[] iv;
        private static final String TRANSFORMATION_SYMMETRIC = "AES/GCM/NoPadding";

        Encryptor() {
        }

        void encrypt(Key encryptionKey, String plaintext) {
            try {
                Cipher cipher = Cipher.getInstance(TRANSFORMATION_SYMMETRIC);
                cipher.init(1, encryptionKey);
                this.iv = cipher.getIV();
                this.ciphertext = cipher.doFinal(plaintext.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                throw RegistrationKeyManager.this.clientLogger.logExceptionAsError(new RuntimeException("Failed to encrypt data", e));
            }
        }
    }
}

