/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation.notifications.fcm;

import android.content.Context;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.azure.android.communication.chat.implementation.notifications.fcm.RegistrarClient;
import com.azure.android.communication.chat.implementation.notifications.fcm.RegistrationKeyManager;
import com.azure.android.communication.common.CommunicationAccessToken;
import com.azure.android.communication.common.CommunicationTokenCredential;
import com.azure.android.core.logging.ClientLogger;
import java.util.concurrent.ExecutionException;
import java9.util.function.Consumer;
import javax.crypto.SecretKey;

public class RegistrationRenewalWorker
extends Worker {
    private ClientLogger clientLogger = new ClientLogger(RegistrationRenewalWorker.class);
    private RegistrarClient registrarClient;
    private CommunicationTokenCredential communicationTokenCredential;
    private Consumer<Throwable> exceptionHandler;
    private RegistrationKeyManager registrationKeyManager;

    public RegistrationRenewalWorker(@NonNull Context context, @NonNull WorkerParameters workerParameters) {
        super(context, workerParameters);
        throw this.clientLogger.logExceptionAsError(new RuntimeException("Missing WorkManager configuration for enabling push notifications. Please refer to the following documentation to ensure the correct setup is applied: https://docs.microsoft.com/azure/communication-services/tutorials/chat-android-push-notification"));
    }

    public RegistrationRenewalWorker(@NonNull Context context, @NonNull WorkerParameters workerParams, CommunicationTokenCredential communicationTokenCredential, Consumer<Throwable> exceptionHandler) {
        super(context, workerParams);
        this.registrarClient = new RegistrarClient();
        this.communicationTokenCredential = communicationTokenCredential;
        this.exceptionHandler = exceptionHandler;
        this.registrationKeyManager = RegistrationKeyManager.instance();
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        int attempts = this.getRunAttemptCount();
        this.clientLogger.info("RegistrationRenewalWorker execution in background: " + attempts);
        if (attempts >= 3) {
            this.clientLogger.info("execution retry limit reached");
            RuntimeException exception = new RuntimeException("Registration renew request failed after 3retries.");
            this.registrationKeyManager.setLastExecutionSucceeded(false);
            if (this.exceptionHandler != null) {
                this.exceptionHandler.accept((Object)exception);
            }
            return ListenableWorker.Result.failure();
        }
        Data inputData = this.getInputData();
        String deviceRegistrationToken = inputData.getString("deviceRegistrationToken");
        try {
            String skypeUserToken = ((CommunicationAccessToken)this.communicationTokenCredential.getToken().get()).getToken();
            this.refreshCredentials();
            Pair<SecretKey, SecretKey> cryptoKeyToAuthKeyPair = this.registrationKeyManager.getLastPair();
            this.registrarClient.register(skypeUserToken, deviceRegistrationToken, (SecretKey)cryptoKeyToAuthKeyPair.first, (SecretKey)cryptoKeyToAuthKeyPair.second);
        }
        catch (InterruptedException | ExecutionException e) {
            this.clientLogger.logThrowableAsError((Throwable)e);
            return ListenableWorker.Result.retry();
        }
        catch (Throwable throwable) {
            this.clientLogger.logThrowableAsError(throwable);
            return ListenableWorker.Result.retry();
        }
        this.clientLogger.info("RegistrationRenewalWorker execution succeeded");
        this.registrationKeyManager.setLastExecutionSucceeded(true);
        return ListenableWorker.Result.success();
    }

    private void refreshCredentials() {
        Context context = this.getApplicationContext();
        String directoryPath = context.getFilesDir().getAbsolutePath();
        this.clientLogger.verbose("DirectoryPath is ", new Object[]{directoryPath});
        this.registrationKeyManager.refreshCredentials(directoryPath, this.getApplicationContext());
    }
}

