/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation.notifications.signaling;

import android.text.TextUtils;
import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.models.ChatEvent;
import com.azure.android.communication.chat.models.ChatEventType;
import com.azure.android.communication.chat.models.RealTimeNotificationCallback;
import com.azure.android.core.logging.ClientLogger;
import com.microsoft.trouterclient.ITrouterConnectionInfo;
import com.microsoft.trouterclient.ITrouterListener;
import com.microsoft.trouterclient.ITrouterRequest;
import com.microsoft.trouterclient.ITrouterResponse;
import java.util.List;

final class CommunicationListener
implements ITrouterListener {
    private final ClientLogger logger;
    private final ChatEventType chatEventType;
    private final RealTimeNotificationCallback listenerFromConsumer;

    CommunicationListener(ChatEventType chatEventType, RealTimeNotificationCallback listener) {
        this.chatEventType = chatEventType;
        this.listenerFromConsumer = listener;
        this.logger = new ClientLogger(this.getClass());
    }

    public void onTrouterConnected(String endpointUrl, ITrouterConnectionInfo connectionInfo) {
        String msg = "onTrouterConnected(): url=" + endpointUrl + ", newPublicUrl=" + Boolean.toString(connectionInfo.isNewEndpointUrl());
        this.logger.info(msg);
    }

    public void onTrouterDisconnected() {
        String msg = "onTrouterDisconnected()";
        this.logger.info("onTrouterDisconnected()");
    }

    public void onTrouterRequest(ITrouterRequest iTrouterRequest, ITrouterResponse iTrouterResponse) {
        String msg = "onTrouterRequest(): #" + Long.toString(iTrouterResponse.getId()) + " " + iTrouterRequest.getMethod() + " " + iTrouterRequest.getUrlPathComponent() + "\n" + iTrouterRequest.getBody();
        this.logger.info(msg);
        ChatEvent chatEvent = NotificationUtils.parseTrouterNotificationPayload(this.chatEventType, iTrouterRequest.getBody());
        if (chatEvent != null) {
            this.listenerFromConsumer.onChatEvent(chatEvent);
        }
    }

    public void onTrouterResponseSent(ITrouterResponse iTrouterResponse, boolean isSuccess) {
        String msg = "onTrouterResponse(): #" + Long.toString(iTrouterResponse.getId()) + " isSuccess=" + Boolean.toString(isSuccess);
        this.logger.info(msg);
    }

    public void onTrouterUserActivityStateAccepted(String correlationVector) {
        String msg = "onTrouterUserActivityStateAccepted(): correlationVector=" + correlationVector;
        this.logger.info(msg);
    }

    public void onTrouterMessageLoss(List<String> flowTags) {
        String msg = "onTrouterMessageLoss(): flowTags=" + TextUtils.join((CharSequence)",", flowTags);
        this.logger.info(msg);
    }
}

