/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation.notifications.signaling;

import android.content.Context;
import com.azure.android.communication.chat.implementation.notifications.signaling.CommunicationListener;
import com.azure.android.communication.chat.implementation.notifications.signaling.RealtimeNotificationConfig;
import com.azure.android.communication.chat.implementation.notifications.signaling.RealtimeNotificationConfigClient;
import com.azure.android.communication.chat.implementation.notifications.signaling.SignalingClient;
import com.azure.android.communication.chat.models.ChatEventType;
import com.azure.android.communication.chat.models.RealTimeNotificationCallback;
import com.azure.android.communication.common.CommunicationAccessToken;
import com.azure.android.communication.common.CommunicationTokenCredential;
import com.azure.android.core.http.HttpPipeline;
import com.azure.android.core.logging.ClientLogger;
import com.microsoft.trouterclient.ISelfHostedTrouterClient;
import com.microsoft.trouterclient.ITrouterAuthHeadersProvider;
import com.microsoft.trouterclient.ITrouterConnectionDataCache;
import com.microsoft.trouterclient.ITrouterListener;
import com.microsoft.trouterclient.TrouterClientHost;
import com.microsoft.trouterclient.UserActivityState;
import com.microsoft.trouterclient.registration.ISkypetokenProvider;
import com.microsoft.trouterclient.registration.TrouterSkypetokenAuthHeaderProvider;
import com.microsoft.trouterclient.registration.TrouterUrlRegistrar;
import com.microsoft.trouterclient.registration.TrouterUrlRegistrationData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java9.util.function.Consumer;

public class CommunicationSignalingClient
implements SignalingClient {
    private final ClientLogger logger;
    private TrouterClientHost trouterClientHost;
    private ISelfHostedTrouterClient trouter;
    private String userToken;
    private final CommunicationTokenCredential communicationTokenCredential;
    private final RealtimeNotificationConfigClient realtimeNotificationConfigClient;
    private final Map<RealTimeNotificationCallback, CommunicationListener> trouterListeners;
    private boolean isRealtimeNotificationsStarted;
    private int tokenFetchRetries;
    private String serviceEndpoint;

    public CommunicationSignalingClient(CommunicationTokenCredential communicationTokenCredential, String serviceEndpoint, HttpPipeline httpPipeline) {
        this.communicationTokenCredential = communicationTokenCredential;
        this.realtimeNotificationConfigClient = new RealtimeNotificationConfigClient(httpPipeline);
        this.logger = new ClientLogger(CommunicationSignalingClient.class);
        this.isRealtimeNotificationsStarted = false;
        this.trouterListeners = new HashMap<RealTimeNotificationCallback, CommunicationListener>();
        this.tokenFetchRetries = 0;
        this.serviceEndpoint = serviceEndpoint;
    }

    @Override
    public boolean hasStarted() {
        return this.isRealtimeNotificationsStarted;
    }

    @Override
    public void start(String skypeUserToken, Context context) {
        this.userToken = skypeUserToken;
        ISkypetokenProvider skypetokenProvider = new ISkypetokenProvider(){

            public String getSkypetoken(boolean forceRefresh) {
                if (forceRefresh) {
                    CommunicationSignalingClient.this.tokenFetchRetries += 1;
                    if (CommunicationSignalingClient.this.tokenFetchRetries > 3) {
                        CommunicationSignalingClient.this.stop();
                        CommunicationSignalingClient.this.logger.error("Access token is expired and failed to fetch a valid one after 3 retries.");
                        return null;
                    }
                } else {
                    CommunicationSignalingClient.this.tokenFetchRetries = 0;
                }
                return CommunicationSignalingClient.this.userToken;
            }
        };
        this.start(context, skypetokenProvider, skypeUserToken);
    }

    @Override
    public void start(Context context, final Consumer<Throwable> errorHandler) {
        ISkypetokenProvider skypetokenProvider = new ISkypetokenProvider(){

            public String getSkypetoken(boolean forceRefresh) {
                if (forceRefresh) {
                    CommunicationSignalingClient.this.tokenFetchRetries += 1;
                    if (CommunicationSignalingClient.this.tokenFetchRetries > 3) {
                        CommunicationSignalingClient.this.stop();
                        Throwable throwable = new Throwable("Access token is expired and failed to fetch a valid one after 3 retries.");
                        CommunicationSignalingClient.this.logger.logThrowableAsError(throwable);
                        errorHandler.accept((Object)throwable);
                        return null;
                    }
                } else {
                    CommunicationSignalingClient.this.tokenFetchRetries = 0;
                }
                String skypeUserToken = null;
                try {
                    skypeUserToken = ((CommunicationAccessToken)CommunicationSignalingClient.this.communicationTokenCredential.getToken().get()).getToken();
                }
                catch (InterruptedException | ExecutionException e) {
                    CommunicationSignalingClient.this.logger.error("Get skype user token failed for realtime notification: " + e.getMessage());
                    skypeUserToken = "";
                }
                return skypeUserToken;
            }
        };
        String skypeUserToken = null;
        try {
            skypeUserToken = ((CommunicationAccessToken)this.communicationTokenCredential.getToken().get()).getToken();
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.error("Get skype user token failed for realtime notification: " + e.getMessage());
            errorHandler.accept((Object)e);
            return;
        }
        this.start(context, skypetokenProvider, skypeUserToken);
    }

    @Override
    public void stop() {
        if (!this.isRealtimeNotificationsStarted) {
            return;
        }
        this.isRealtimeNotificationsStarted = false;
        this.trouter.close();
        this.trouterListeners.clear();
    }

    @Override
    public void on(ChatEventType chatEventType, RealTimeNotificationCallback listener) {
        CommunicationListener communicationListener = new CommunicationListener(chatEventType, listener);
        String loggingName = CommunicationSignalingClient.class.getName();
        if (!this.trouterListeners.containsKey(listener)) {
            if (ChatEventType.CHAT_MESSAGE_RECEIVED.equals((Object)chatEventType)) {
                this.trouter.registerListener((ITrouterListener)communicationListener, "/chatMessageReceived", loggingName);
            } else if (ChatEventType.TYPING_INDICATOR_RECEIVED.equals((Object)chatEventType)) {
                this.trouter.registerListener((ITrouterListener)communicationListener, "/typingIndicatorReceived", loggingName);
            } else if (ChatEventType.READ_RECEIPT_RECEIVED.equals((Object)chatEventType)) {
                this.trouter.registerListener((ITrouterListener)communicationListener, "/readReceiptReceived", loggingName);
            } else if (ChatEventType.CHAT_MESSAGE_EDITED.equals((Object)chatEventType)) {
                this.trouter.registerListener((ITrouterListener)communicationListener, "/chatMessageEdited", loggingName);
            } else if (ChatEventType.CHAT_MESSAGE_DELETED.equals((Object)chatEventType)) {
                this.trouter.registerListener((ITrouterListener)communicationListener, "/chatMessageDeleted", loggingName);
            } else if (ChatEventType.CHAT_THREAD_CREATED.equals((Object)chatEventType)) {
                this.trouter.registerListener((ITrouterListener)communicationListener, "/chatThreadCreated", loggingName);
            } else if (ChatEventType.CHAT_THREAD_PROPERTIES_UPDATED.equals((Object)chatEventType)) {
                this.trouter.registerListener((ITrouterListener)communicationListener, "/chatThreadPropertiesUpdated", loggingName);
            } else if (ChatEventType.CHAT_THREAD_DELETED.equals((Object)chatEventType)) {
                this.trouter.registerListener((ITrouterListener)communicationListener, "/chatThreadDeleted", loggingName);
            } else if (ChatEventType.PARTICIPANTS_ADDED.equals((Object)chatEventType)) {
                this.trouter.registerListener((ITrouterListener)communicationListener, "/participantsAdded", loggingName);
            } else if (ChatEventType.PARTICIPANTS_REMOVED.equals((Object)chatEventType)) {
                this.trouter.registerListener((ITrouterListener)communicationListener, "/participantsRemoved", loggingName);
            } else {
                return;
            }
            this.trouterListeners.put(listener, communicationListener);
        }
    }

    @Override
    public void off(ChatEventType chatEventType, RealTimeNotificationCallback listener) {
        if (this.trouterListeners.containsKey(listener)) {
            this.trouter.unregisterListener((ITrouterListener)this.trouterListeners.get(listener));
            this.trouterListeners.remove(listener);
        }
    }

    private void start(Context context, ISkypetokenProvider skypetokenProvider, String skypeUserToken) {
        if (this.isRealtimeNotificationsStarted) {
            return;
        }
        RealtimeNotificationConfig realTimeNotificationConfig = this.realtimeNotificationConfigClient.getRealtimeConfigs(skypeUserToken, this.serviceEndpoint, "2024-09-01");
        String trouterHostname = realTimeNotificationConfig.getTrouterServiceUrl().replace("https://", "");
        String registrarBasePath = realTimeNotificationConfig.getRegistrarServiceUrl().replace("https://", "");
        this.logger.verbose(String.format("Received config from service. Trouter Hostname: %s, Registrar Base Path: %s", trouterHostname, registrarBasePath));
        TrouterSkypetokenAuthHeaderProvider trouterAuthHeadersProvider = new TrouterSkypetokenAuthHeaderProvider(skypetokenProvider);
        TrouterUrlRegistrationData registrationData = new TrouterUrlRegistrationData(null, "AcsAndroid", "Android", "0.0.0.0", "AcsAndroid_Chat_1.7", null, "");
        TrouterUrlRegistrar registrar = new TrouterUrlRegistrar(skypetokenProvider, registrationData, registrarBasePath, Integer.parseInt("3601"));
        try {
            this.trouterListeners.clear();
            this.trouterClientHost = TrouterClientHost.initialize((Context)context, (String)"99116/0.0.0.0/");
            this.trouter = this.trouterClientHost.createTrouterClient((ITrouterAuthHeadersProvider)trouterAuthHeadersProvider, (ITrouterConnectionDataCache)new InMemoryConnectionDataCache(), trouterHostname);
            this.trouter.withRegistrar(registrar);
            this.trouter.start();
            this.trouter.setUserActivityState(UserActivityState.ACTIVITY_ACTIVE);
            this.isRealtimeNotificationsStarted = true;
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage());
        }
    }

    static class InMemoryConnectionDataCache
    implements ITrouterConnectionDataCache {
        private String cachedData = "";

        InMemoryConnectionDataCache() {
        }

        public void store(String s) {
            this.cachedData = s;
        }

        public String load() {
            return this.cachedData;
        }
    }
}

