/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.implementation.notifications.signaling;

import com.azure.android.communication.chat.implementation.notifications.signaling.RealtimeNotificationConfig;
import com.azure.android.core.http.HttpCallback;
import com.azure.android.core.http.HttpClient;
import com.azure.android.core.http.HttpMethod;
import com.azure.android.core.http.HttpPipeline;
import com.azure.android.core.http.HttpPipelineBuilder;
import com.azure.android.core.http.HttpPipelinePolicy;
import com.azure.android.core.http.HttpRequest;
import com.azure.android.core.http.HttpResponse;
import com.azure.android.core.http.policy.RetryPolicy;
import com.azure.android.core.http.policy.UserAgentPolicy;
import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.util.CancellationToken;
import com.azure.android.core.util.RequestContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class RealtimeNotificationConfigClient {
    private final HttpPipeline httpPipeline;
    private final ClientLogger logger = new ClientLogger(RealtimeNotificationConfigClient.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";

    RealtimeNotificationConfigClient(HttpPipeline httpPipeline) {
        this.httpPipeline = this.createHttpPipeline(httpPipeline);
    }

    public RealtimeNotificationConfig getRealtimeConfigs(String token, String endpoint, String configApiVersion) {
        String urlString = endpoint + "/chat/config/realTimeNotifications?api-version=" + configApiVersion;
        HttpRequest request = new HttpRequest(HttpMethod.GET, urlString);
        request.setHeader(AUTHORIZATION_HEADER, "Bearer " + token).setHeader("Accept", "application/json");
        final CountDownLatch latch = new CountDownLatch(1);
        final Throwable[] requestError = new Throwable[]{null};
        final RealtimeNotificationConfig[] configResult = new RealtimeNotificationConfig[]{null};
        this.httpPipeline.send(request, RequestContext.NONE, CancellationToken.NONE, new HttpCallback(){

            public void onSuccess(HttpResponse response) {
                int statusCode = response.getStatusCode();
                RealtimeNotificationConfigClient.this.logger.info("Retrieve realtime notification config HTTP response code: " + statusCode);
                if (statusCode != 200) {
                    try {
                        String errorBody = response.getBodyAsString();
                        requestError[0] = new RuntimeException("Registrar register request failed with HTTP status code " + statusCode + ". Error message: " + errorBody);
                    }
                    catch (Exception e) {
                        requestError[0] = new RuntimeException("Failed to read error response body", e);
                    }
                } else {
                    try {
                        ObjectMapper objectMapper = new ObjectMapper();
                        configResult[0] = (RealtimeNotificationConfig)objectMapper.readValue(response.getBodyAsString(), RealtimeNotificationConfig.class);
                        RealtimeNotificationConfigClient.this.logger.info("Successfully converted response to RealtimeNotificationConfig.");
                    }
                    catch (Exception e) {
                        RealtimeNotificationConfigClient.this.logger.error("Failed to parse response body to RealtimeNotificationConfig: " + e.getMessage(), new Object[]{e});
                        requestError[0] = new RuntimeException("Failed to parse response body", e);
                    }
                }
                latch.countDown();
            }

            public void onError(Throwable error) {
                RealtimeNotificationConfigClient.this.logger.error("HTTP request failed: " + error.getMessage(), new Object[]{error});
                requestError[0] = error;
                latch.countDown();
            }
        });
        boolean completed = this.awaitOnLatch(latch);
        if (!completed) {
            throw (RuntimeException)this.logger.logThrowableAsError((Throwable)new RuntimeException("HTTP request timed out."));
        }
        if (requestError[0] != null) {
            throw (RuntimeException)this.logger.logThrowableAsError((Throwable)new RuntimeException("All retry attempts failed.", requestError[0]));
        }
        return configResult[0];
    }

    private HttpPipeline createHttpPipeline(HttpPipeline httpPipeline) {
        List<HttpPipelinePolicy> customPolicies = RealtimeNotificationConfigClient.getEssentialPolicies(httpPipeline);
        return new HttpPipelineBuilder().httpClient(HttpClient.createDefault()).policies(customPolicies.toArray(new HttpPipelinePolicy[0])).build();
    }

    public static List<HttpPipelinePolicy> getEssentialPolicies(HttpPipeline pipeline) {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        int index = 0;
        try {
            while (true) {
                HttpPipelinePolicy policy;
                if ((policy = pipeline.getPolicy(index)) instanceof RetryPolicy || policy instanceof UserAgentPolicy) {
                    policies.add(policy);
                }
                ++index;
            }
        }
        catch (IndexOutOfBoundsException e) {
            return policies;
        }
    }

    private boolean awaitOnLatch(CountDownLatch latch) {
        long timeoutInSec = 10L;
        try {
            return latch.await(timeoutInSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw this.logger.logExceptionAsError(new RuntimeException("Operation didn't complete within " + timeoutInSec + " seconds"));
        }
    }
}

