/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.models;

import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.implementation.notifications.signaling.EventAccessorHelper;
import com.azure.android.communication.chat.models.ChatUserEvent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.threeten.bp.OffsetDateTime;

public final class ChatMessageEditedEvent
extends ChatUserEvent {
    @JsonProperty(value="messageBody")
    private String content;
    @JsonProperty(value="edittime")
    private OffsetDateTime editedOn;
    @JsonProperty(value="messageId")
    private String id;
    @JsonProperty(value="senderDisplayName")
    private String senderDisplayName;
    @JsonProperty(value="originalArrivalTime")
    private OffsetDateTime createdOn;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="acsChatMessageMetadata")
    private String acsChatMessageMetadata;
    @JsonProperty(value="metadata")
    private Map<String, String> metadata;

    public String getContent() {
        return this.content;
    }

    public OffsetDateTime getEditedOn() {
        return this.editedOn;
    }

    public String getId() {
        return this.id;
    }

    public String getSenderDisplayName() {
        return this.senderDisplayName;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    private ChatMessageEditedEvent setMetadata() {
        this.metadata = NotificationUtils.parseChatMessageMetadata(this.acsChatMessageMetadata);
        return this;
    }

    static {
        EventAccessorHelper.setChatMessageEditedEventAccessorAccessor(event -> {
            ChatMessageEditedEvent chatMessageEditedEvent = (ChatMessageEditedEvent)event;
            chatMessageEditedEvent.setMetadata().setSender().setRecipient().setThreadId();
        });
    }
}

