/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.models;

import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.implementation.notifications.signaling.EventAccessorHelper;
import com.azure.android.communication.chat.models.ChatMessageType;
import com.azure.android.communication.chat.models.ChatUserEvent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.threeten.bp.OffsetDateTime;

public final class ChatMessageReceivedEvent
extends ChatUserEvent {
    @JsonProperty(value="type")
    private ChatMessageType type;
    @JsonProperty(value="messageType", access=JsonProperty.Access.WRITE_ONLY)
    private String messageType;
    @JsonProperty(value="messageBody")
    private String content;
    @JsonProperty(value="priority")
    private String priority;
    @JsonProperty(value="messageId")
    private String id;
    @JsonProperty(value="senderDisplayName")
    private String senderDisplayName;
    @JsonProperty(value="originalArrivalTime")
    private OffsetDateTime createdOn;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="acsChatMessageMetadata")
    private String acsChatMessageMetadata;
    @JsonProperty(value="metadata")
    private Map<String, String> metadata;

    public ChatMessageType getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getId() {
        return this.id;
    }

    public String getSenderDisplayName() {
        return this.senderDisplayName;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    private ChatMessageReceivedEvent setType() {
        this.type = NotificationUtils.parseChatMessageType(this.messageType);
        return this;
    }

    private ChatMessageReceivedEvent setMetadata() {
        this.metadata = NotificationUtils.parseChatMessageMetadata(this.acsChatMessageMetadata);
        return this;
    }

    static {
        EventAccessorHelper.setChatMessageReceivedEventAccessor(event -> {
            ChatMessageReceivedEvent chatMessageReceivedEvent = (ChatMessageReceivedEvent)event;
            chatMessageReceivedEvent.setType().setMetadata().setSender().setRecipient().setThreadId();
        });
    }
}

