/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.models;

import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.implementation.notifications.signaling.EventAccessorHelper;
import com.azure.android.communication.chat.models.ChatParticipant;
import com.azure.android.communication.chat.models.ChatThreadEvent;
import com.azure.android.communication.chat.models.ChatThreadProperties;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.threeten.bp.OffsetDateTime;

public class ChatThreadCreatedEvent
extends ChatThreadEvent {
    @JsonProperty(value="createTime")
    private OffsetDateTime createdOn;
    private ChatThreadProperties properties;
    @JsonProperty(value="properties")
    private String propertiesJsonString;
    @JsonProperty(value="participants")
    private List<ChatParticipant> participants;
    @JsonProperty(value="members", access=JsonProperty.Access.WRITE_ONLY)
    private String participantsJsonString;
    private ChatParticipant createdBy;
    @JsonProperty(value="createdBy", access=JsonProperty.Access.WRITE_ONLY)
    private String createdByJsonString;

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public ChatThreadProperties getProperties() {
        return this.properties;
    }

    public List<ChatParticipant> getParticipants() {
        return this.participants;
    }

    public ChatParticipant getCreatedBy() {
        return this.createdBy;
    }

    ChatThreadCreatedEvent setProperties() {
        this.properties = new ChatThreadProperties();
        try {
            JSONObject propertiesJsonObject = new JSONObject(this.propertiesJsonString);
            this.properties.setId(this.getChatThreadId()).setTopic(propertiesJsonObject.getString("topic")).setCreatedByCommunicationIdentifier(this.createdBy.getCommunicationIdentifier()).setCreatedOn(this.createdOn);
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    ChatThreadCreatedEvent setCreatedBy() {
        this.createdBy = new ChatParticipant();
        try {
            JSONObject createdByJsonObject = new JSONObject(this.createdByJsonString);
            CommunicationIdentifier createdByCommunicationIdentifier = NotificationUtils.getCommunicationIdentifier(createdByJsonObject.getString("participantId"));
            this.createdBy.setCommunicationIdentifier(createdByCommunicationIdentifier).setDisplayName(createdByJsonObject.getString("displayName"));
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    ChatThreadCreatedEvent setParticipants() {
        this.participants = new ArrayList<ChatParticipant>();
        try {
            JSONArray participantsJsonArray = new JSONArray(this.participantsJsonString);
            for (int i = 0; i < participantsJsonArray.length(); ++i) {
                JSONObject participant = participantsJsonArray.getJSONObject(i);
                CommunicationIdentifier communicationUser = NotificationUtils.getCommunicationIdentifier(participant.getString("participantId"));
                ChatParticipant chatParticipant = new ChatParticipant();
                chatParticipant.setCommunicationIdentifier(communicationUser);
                chatParticipant.setDisplayName(participant.getString("displayName"));
                this.participants.add(chatParticipant);
            }
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    static {
        EventAccessorHelper.setChatThreadCreatedEventAccessor(event -> {
            ChatThreadCreatedEvent chatThreadCreatedEvent = (ChatThreadCreatedEvent)event;
            chatThreadCreatedEvent.setCreatedBy().setParticipants().setProperties();
        });
    }
}

