/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.models;

import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.implementation.notifications.signaling.EventAccessorHelper;
import com.azure.android.communication.chat.models.ChatParticipant;
import com.azure.android.communication.chat.models.ChatThreadEvent;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.json.JSONException;
import org.json.JSONObject;
import org.threeten.bp.OffsetDateTime;

public class ChatThreadDeletedEvent
extends ChatThreadEvent {
    @JsonProperty(value="deleteTime")
    private OffsetDateTime deletedOn;
    private ChatParticipant deletedBy;
    @JsonProperty(value="deletedBy", access=JsonProperty.Access.WRITE_ONLY)
    private String deletedByJsonString;

    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    public ChatParticipant getDeletedBy() {
        return this.deletedBy;
    }

    ChatThreadDeletedEvent setDeletedBy() {
        this.deletedBy = new ChatParticipant();
        try {
            JSONObject deletedByJsonObject = new JSONObject(this.deletedByJsonString);
            CommunicationIdentifier deletedByCommunicationIdentifier = NotificationUtils.getCommunicationIdentifier(deletedByJsonObject.getString("participantId"));
            this.deletedBy.setCommunicationIdentifier(deletedByCommunicationIdentifier).setDisplayName(deletedByJsonObject.getString("displayName"));
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    static {
        EventAccessorHelper.setChatThreadDeletedEventAccessor(event -> {
            ChatThreadDeletedEvent chatThreadDeletedEvent = (ChatThreadDeletedEvent)event;
            chatThreadDeletedEvent.setDeletedBy();
        });
    }
}

