/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.models;

import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.implementation.notifications.signaling.EventAccessorHelper;
import com.azure.android.communication.chat.models.ChatParticipant;
import com.azure.android.communication.chat.models.ChatThreadEvent;
import com.azure.android.communication.chat.models.ChatThreadProperties;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.json.JSONException;
import org.json.JSONObject;
import org.threeten.bp.OffsetDateTime;

public class ChatThreadPropertiesUpdatedEvent
extends ChatThreadEvent {
    private ChatThreadProperties properties;
    @JsonProperty(value="properties")
    private String propertiesJsonString;
    @JsonProperty(value="editTime")
    private OffsetDateTime updatedOn;
    private ChatParticipant updatedBy;
    @JsonProperty(value="editedBy", access=JsonProperty.Access.WRITE_ONLY)
    private String updatedByJsonString;

    public ChatThreadProperties getProperties() {
        return this.properties;
    }

    public OffsetDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    public ChatParticipant getUpdatedBy() {
        return this.updatedBy;
    }

    ChatThreadPropertiesUpdatedEvent setUpdatedBy() {
        this.updatedBy = new ChatParticipant();
        try {
            JSONObject updatedByJsonObject = new JSONObject(this.updatedByJsonString);
            CommunicationIdentifier updatedByCommunicationIdentifier = NotificationUtils.getCommunicationIdentifier(updatedByJsonObject.getString("participantId"));
            this.updatedBy.setCommunicationIdentifier(updatedByCommunicationIdentifier).setDisplayName(updatedByJsonObject.getString("displayName"));
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    ChatThreadPropertiesUpdatedEvent setProperties() {
        this.properties = new ChatThreadProperties();
        try {
            JSONObject propertiesJsonObject = new JSONObject(this.propertiesJsonString);
            this.properties.setId(this.getChatThreadId()).setTopic(propertiesJsonObject.getString("topic"));
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    static {
        EventAccessorHelper.setChatThreadPropertiesUpdatedEventAccessor(event -> {
            ChatThreadPropertiesUpdatedEvent chatThreadPropertiesUpdatedEvent = (ChatThreadPropertiesUpdatedEvent)event;
            chatThreadPropertiesUpdatedEvent.setUpdatedBy().setProperties();
        });
    }
}

