/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.models;

import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.models.ChatEvent;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.fasterxml.jackson.annotation.JsonProperty;

public abstract class ChatUserEvent
extends ChatEvent {
    @JsonProperty(value="senderId", access=JsonProperty.Access.WRITE_ONLY)
    private String senderId;
    @JsonProperty(value="recipientMri", access=JsonProperty.Access.WRITE_ONLY)
    private String recipientMri;
    @JsonProperty(value="recipientId", access=JsonProperty.Access.WRITE_ONLY)
    private String recipientId;
    @JsonProperty(value="sender")
    private CommunicationIdentifier sender;
    @JsonProperty(value="recipient")
    private CommunicationIdentifier recipient;

    public CommunicationIdentifier getSender() {
        return this.sender;
    }

    public CommunicationIdentifier getRecipient() {
        return this.recipient;
    }

    ChatUserEvent setSender() {
        this.sender = NotificationUtils.getCommunicationIdentifier(this.senderId);
        return this;
    }

    ChatUserEvent setRecipient() {
        if (this.recipientMri != null) {
            this.recipient = NotificationUtils.getCommunicationIdentifier(this.recipientMri);
            return this;
        }
        this.recipient = NotificationUtils.getCommunicationIdentifier(this.recipientId);
        return this;
    }
}

