/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.models;

import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.implementation.notifications.signaling.EventAccessorHelper;
import com.azure.android.communication.chat.models.ChatParticipant;
import com.azure.android.communication.chat.models.ChatThreadEvent;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.threeten.bp.OffsetDateTime;

public class ParticipantsAddedEvent
extends ChatThreadEvent {
    @JsonProperty(value="time")
    private OffsetDateTime addedOn;
    private ChatParticipant addedBy;
    @JsonProperty(value="addedBy", access=JsonProperty.Access.WRITE_ONLY)
    private String addedByJsonString;
    private List<ChatParticipant> participantsAdded;
    @JsonProperty(value="participantsAdded", access=JsonProperty.Access.WRITE_ONLY)
    private String participantsAddedJsonString;

    public OffsetDateTime getAddedOn() {
        return this.addedOn;
    }

    public ChatParticipant getAddedBy() {
        return this.addedBy;
    }

    public List<ChatParticipant> getParticipantsAdded() {
        return this.participantsAdded;
    }

    ParticipantsAddedEvent setAddedBy() {
        this.addedBy = new ChatParticipant();
        try {
            JSONObject addedByJsonObject = new JSONObject(this.addedByJsonString);
            CommunicationIdentifier addedByCommunicationIdentifier = NotificationUtils.getCommunicationIdentifier(addedByJsonObject.getString("participantId"));
            this.addedBy.setCommunicationIdentifier(addedByCommunicationIdentifier).setDisplayName(addedByJsonObject.getString("displayName"));
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    ParticipantsAddedEvent setParticipantsAdded() {
        this.participantsAdded = new ArrayList<ChatParticipant>();
        try {
            JSONArray participantsAddedJsonArray = new JSONArray(this.participantsAddedJsonString);
            for (int i = 0; i < participantsAddedJsonArray.length(); ++i) {
                JSONObject participant = participantsAddedJsonArray.getJSONObject(i);
                CommunicationIdentifier communicationUser = NotificationUtils.getCommunicationIdentifier(participant.getString("participantId"));
                ChatParticipant chatParticipant = new ChatParticipant();
                chatParticipant.setCommunicationIdentifier(communicationUser);
                chatParticipant.setDisplayName(participant.getString("displayName"));
                chatParticipant.setShareHistoryTime(NotificationUtils.parseEpochTime(participant.getLong("shareHistoryTime")));
                this.participantsAdded.add(chatParticipant);
            }
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    static {
        EventAccessorHelper.setParticipantsAddedEventAccessor(event -> {
            ParticipantsAddedEvent participantsAddedEvent = (ParticipantsAddedEvent)event;
            participantsAddedEvent.setAddedBy().setParticipantsAdded();
        });
    }
}

