/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.models;

import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.implementation.notifications.signaling.EventAccessorHelper;
import com.azure.android.communication.chat.models.ChatParticipant;
import com.azure.android.communication.chat.models.ChatThreadEvent;
import com.azure.android.communication.common.CommunicationIdentifier;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.threeten.bp.OffsetDateTime;

public class ParticipantsRemovedEvent
extends ChatThreadEvent {
    @JsonProperty(value="time")
    private OffsetDateTime removedOn;
    private ChatParticipant removedBy;
    @JsonProperty(value="removedBy", access=JsonProperty.Access.WRITE_ONLY)
    private String removedByJsonString;
    private List<ChatParticipant> participantsRemoved;
    @JsonProperty(value="participantsRemoved", access=JsonProperty.Access.WRITE_ONLY)
    private String participantsRemovedJsonString;

    public OffsetDateTime getRemovedOn() {
        return this.removedOn;
    }

    public ChatParticipant getRemovedBy() {
        return this.removedBy;
    }

    public List<ChatParticipant> getParticipantsRemoved() {
        return this.participantsRemoved;
    }

    ParticipantsRemovedEvent setRemovedBy() {
        this.removedBy = new ChatParticipant();
        try {
            JSONObject removedByJsonObject = new JSONObject(this.removedByJsonString);
            CommunicationIdentifier removedByCommunicationIdentifier = NotificationUtils.getCommunicationIdentifier(removedByJsonObject.getString("participantId"));
            this.removedBy.setCommunicationIdentifier(removedByCommunicationIdentifier).setDisplayName(removedByJsonObject.getString("displayName"));
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    ParticipantsRemovedEvent setParticipantsRemoved() {
        this.participantsRemoved = new ArrayList<ChatParticipant>();
        try {
            JSONArray participantsRemovedJsonArray = new JSONArray(this.participantsRemovedJsonString);
            for (int i = 0; i < participantsRemovedJsonArray.length(); ++i) {
                JSONObject participant = participantsRemovedJsonArray.getJSONObject(i);
                CommunicationIdentifier communicationUser = NotificationUtils.getCommunicationIdentifier(participant.getString("participantId"));
                ChatParticipant chatParticipant = new ChatParticipant();
                chatParticipant.setCommunicationIdentifier(communicationUser);
                chatParticipant.setDisplayName(participant.getString("displayName"));
                chatParticipant.setShareHistoryTime(NotificationUtils.parseEpochTime(participant.getLong("shareHistoryTime")));
                this.participantsRemoved.add(chatParticipant);
            }
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    static {
        EventAccessorHelper.setParticipantsRemovedEventAccessor(event -> {
            ParticipantsRemovedEvent participantsRemovedEvent = (ParticipantsRemovedEvent)event;
            participantsRemovedEvent.setRemovedBy().setParticipantsRemoved();
        });
    }
}

