/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.chat.models;

import com.azure.android.communication.chat.implementation.notifications.NotificationUtils;
import com.azure.android.communication.chat.implementation.notifications.signaling.EventAccessorHelper;
import com.azure.android.communication.chat.models.ChatUserEvent;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.json.JSONException;
import org.json.JSONObject;
import org.threeten.bp.OffsetDateTime;

public final class ReadReceiptReceivedEvent
extends ChatUserEvent {
    @JsonProperty(value="messageId")
    private String chatMessageId;
    @JsonProperty(value="readOn")
    private OffsetDateTime readOn;
    @JsonProperty(value="messageBody", access=JsonProperty.Access.WRITE_ONLY)
    private String messageBody;

    public String getChatMessageId() {
        return this.chatMessageId;
    }

    public OffsetDateTime getReadOn() {
        return this.readOn;
    }

    ReadReceiptReceivedEvent setReadOn() {
        try {
            JSONObject messageBodyJsonObject = new JSONObject(this.messageBody);
            this.readOn = NotificationUtils.extractReadTimeFromConsumptionHorizon(messageBodyJsonObject.getString("consumptionhorizon"));
        }
        catch (JSONException e) {
            return this;
        }
        return this;
    }

    static {
        EventAccessorHelper.setReadReceiptReceivedEventAccessor(event -> {
            ReadReceiptReceivedEvent readReceiptReceivedEvent = (ReadReceiptReceivedEvent)event;
            readReceiptReceivedEvent.setReadOn().setSender().setRecipient().setThreadId();
        });
    }
}

