/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.common;

import com.azure.android.communication.common.CommunicationAccessToken;
import com.azure.android.communication.common.CommunicationTokenRefreshOptions;
import com.azure.android.communication.common.TokenParser;
import com.azure.android.communication.common.UserCredential;
import com.azure.android.core.logging.ClientLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java9.util.concurrent.CompletableFuture;

final class AutoRefreshUserCredential
extends UserCredential {
    private static final String CREDENTIAL_DISPOSED = "UserCredential has been disposed.";
    private static final int ON_DEMAND_REFRESH_BUFFER_SECS = 120;
    private static final int PROACTIVE_REFRESH_BUFFER_SECS = 600;
    private static final int REFRESH_AFTER_TTL_DIVIDER = 2;
    private final ClientLogger logger = new ClientLogger(AutoRefreshUserCredential.class);
    private final Callable<String> tokenRefreshCallable;
    private final boolean refreshProactively;
    private volatile CompletableFuture<CommunicationAccessToken> tokenFuture;
    private CompletableFuture<Void> tokenFutureUpdater;

    AutoRefreshUserCredential(CommunicationTokenRefreshOptions tokenRefreshOptions) {
        this.tokenRefreshCallable = tokenRefreshOptions.getTokenRefresher();
        this.refreshProactively = tokenRefreshOptions.isRefreshProactively();
        CommunicationAccessToken initialAccessToken = null;
        if (tokenRefreshOptions.getInitialToken() != null) {
            initialAccessToken = TokenParser.createAccessToken(tokenRefreshOptions.getInitialToken());
            this.tokenFuture = CompletableFuture.completedFuture((Object)initialAccessToken);
        }
        if (this.refreshProactively) {
            this.scheduleTokenFutureUpdate(initialAccessToken);
        }
    }

    @Override
    public CompletableFuture<CommunicationAccessToken> getToken() {
        if (this.shouldRefreshOnDemand()) {
            this.updateTokenFuture();
        }
        return this.tokenFuture;
    }

    private boolean shouldRefreshOnDemand() {
        CompletableFuture<CommunicationAccessToken> tokenFuture = this.tokenFuture;
        if (tokenFuture == null || tokenFuture.isCancelled()) {
            return true;
        }
        if (tokenFuture.isDone()) {
            try {
                CommunicationAccessToken accessToken = (CommunicationAccessToken)tokenFuture.get();
                return this.isTokenExpiringSoon(accessToken, 120);
            }
            catch (InterruptedException | ExecutionException e) {
                return true;
            }
        }
        return false;
    }

    private synchronized void updateTokenFuture() {
        if (this.isDisposed()) {
            this.tokenFuture = CompletableFuture.failedFuture((Throwable)new IllegalStateException(CREDENTIAL_DISPOSED));
            return;
        }
        CompletableFuture<CommunicationAccessToken> tokenFuture = this.tokenFuture;
        if (tokenFuture != null && !tokenFuture.isDone() && !tokenFuture.isCancelled()) {
            return;
        }
        this.tokenFuture = CompletableFuture.supplyAsync(() -> {
            CommunicationAccessToken accessToken;
            if (this.isDisposed()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException(CREDENTIAL_DISPOSED));
            }
            try {
                String tokenStr = this.tokenRefreshCallable.call();
                accessToken = TokenParser.createAccessToken(tokenStr);
                if (accessToken.isExpired()) {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The token returned from the tokenRefresher is expired."));
                }
            }
            catch (Exception e) {
                throw this.logger.logExceptionAsError(new RuntimeException(e));
            }
            if (this.refreshProactively) {
                this.scheduleTokenFutureUpdate(accessToken);
            }
            return accessToken;
        });
    }

    private synchronized void scheduleTokenFutureUpdate(CommunicationAccessToken accessToken) {
        if (this.isDisposed()) {
            return;
        }
        if (this.tokenFutureUpdater != null) {
            this.tokenFutureUpdater.cancel(true);
        }
        long delayMs = 0L;
        if (accessToken != null && !accessToken.isExpired()) {
            long currentEpochMs = System.currentTimeMillis();
            long tokenTtlMs = accessToken.getExpiresAt().toInstant().toEpochMilli() - currentEpochMs;
            long nextFetchTimeMs = this.isTokenExpiringSoon(accessToken, 600) ? tokenTtlMs / 2L : tokenTtlMs - TimeUnit.MILLISECONDS.convert(600L, TimeUnit.SECONDS);
            delayMs = Math.max(nextFetchTimeMs, 0L);
        }
        this.tokenFutureUpdater = CompletableFuture.runAsync(this::updateTokenFuture, (Executor)CompletableFuture.delayedExecutor((long)delayMs, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    private boolean isTokenExpiringSoon(CommunicationAccessToken accessToken, int refreshBufferSecs) {
        if (accessToken == null) {
            return true;
        }
        long refreshEpochSecond = accessToken.getExpiresAt().toEpochSecond() - (long)refreshBufferSecs;
        long currentEpochSecond = System.currentTimeMillis() / 1000L;
        return currentEpochSecond >= refreshEpochSecond;
    }

    @Override
    public void dispose() {
        if (this.tokenFuture != null) {
            this.tokenFuture.cancel(true);
        }
        if (this.tokenFutureUpdater != null) {
            this.tokenFutureUpdater.cancel(true);
        }
        super.dispose();
    }
}

