/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.common;

import com.azure.android.communication.common.CommunicationCloudEnvironment;
import com.azure.android.communication.common.CommunicationUserIdentifier;
import com.azure.android.communication.common.MicrosoftTeamsAppIdentifier;
import com.azure.android.communication.common.MicrosoftTeamsUserIdentifier;
import com.azure.android.communication.common.PhoneNumberIdentifier;
import com.azure.android.communication.common.UnknownIdentifier;

public abstract class CommunicationIdentifier {
    static final String ACS_USER_PREFIX = "8:acs:";
    static final String ACS_USER_GCCH_CLOUD_PREFIX = "8:gcch-acs:";
    static final String ACS_USER_DOD_CLOUD_PREFIX = "8:dod-acs:";
    static final String SPOOL_USER_PREFIX = "8:spool:";
    static final String TEAMS_USER_PUBLIC_CLOUD_PREFIX = "8:orgid:";
    static final String TEAMS_USER_GCCH_CLOUD_PREFIX = "8:gcch:";
    static final String TEAMS_USER_DOD_CLOUD_PREFIX = "8:dod:";
    static final String TEAMS_ANONYMOUS_USER_PREFIX = "8:teamsvisitor:";
    static final String TEAMS_APP_PUBLIC_CLOUD_PREFIX = "28:orgid:";
    static final String TEAMS_APP_DOD_CLOUD_PREFIX = "28:dod:";
    static final String TEAMS_APP_GCCH_CLOUD_PREFIX = "28:gcch:";
    static final String PHONE_NUMBER_PREFIX = "4:";
    private String rawId;

    public static CommunicationIdentifier fromRawId(String rawId) {
        if (rawId == null || rawId.trim().length() == 0) {
            throw new IllegalArgumentException("The parameter [rawId] cannot be null to empty.");
        }
        if (rawId.startsWith(PHONE_NUMBER_PREFIX)) {
            return new PhoneNumberIdentifier(rawId.substring(PHONE_NUMBER_PREFIX.length()));
        }
        String[] segments = rawId.split(":");
        int segmentCount = segments.length;
        if (segmentCount != 3) {
            return new UnknownIdentifier(rawId);
        }
        String prefix = segments[0] + ":" + segments[1] + ":";
        String suffix = segments[2];
        switch (prefix) {
            case "8:teamsvisitor:": {
                return new MicrosoftTeamsUserIdentifier(suffix, true);
            }
            case "8:orgid:": {
                return new MicrosoftTeamsUserIdentifier(suffix, false);
            }
            case "8:dod:": {
                return new MicrosoftTeamsUserIdentifier(suffix, false).setCloudEnvironment(CommunicationCloudEnvironment.DOD);
            }
            case "8:gcch:": {
                return new MicrosoftTeamsUserIdentifier(suffix, false).setCloudEnvironment(CommunicationCloudEnvironment.GCCH);
            }
            case "28:orgid:": {
                return new MicrosoftTeamsAppIdentifier(suffix);
            }
            case "28:dod:": {
                return new MicrosoftTeamsAppIdentifier(suffix, CommunicationCloudEnvironment.DOD);
            }
            case "28:gcch:": {
                return new MicrosoftTeamsAppIdentifier(suffix, CommunicationCloudEnvironment.GCCH);
            }
            case "8:acs:": 
            case "8:spool:": 
            case "8:dod-acs:": 
            case "8:gcch-acs:": {
                return new CommunicationUserIdentifier(rawId);
            }
        }
        return new UnknownIdentifier(rawId);
    }

    public String getRawId() {
        return this.rawId;
    }

    protected CommunicationIdentifier setRawId(String rawId) {
        this.rawId = rawId;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof CommunicationIdentifier)) {
            return false;
        }
        CommunicationIdentifier thatId = (CommunicationIdentifier)that;
        return this.getRawId().equals(thatId.getRawId());
    }

    public int hashCode() {
        return this.getRawId().hashCode();
    }
}

