/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.common;

import com.azure.android.communication.common.CommunicationCloudEnvironment;
import com.azure.android.communication.common.CommunicationIdentifier;

public final class MicrosoftTeamsAppIdentifier
extends CommunicationIdentifier {
    private final String appId;
    private final CommunicationCloudEnvironment cloudEnvironment;

    public MicrosoftTeamsAppIdentifier(String appId, CommunicationCloudEnvironment cloudEnvironment) {
        if (appId == null || appId.trim().length() == 0) {
            throw new IllegalArgumentException("The initialization parameter [appId] cannot be null or empty.");
        }
        this.appId = appId;
        this.cloudEnvironment = cloudEnvironment;
        this.generateRawId();
    }

    public MicrosoftTeamsAppIdentifier(String appId) {
        this(appId, CommunicationCloudEnvironment.PUBLIC);
    }

    public String getAppId() {
        return this.appId;
    }

    public CommunicationCloudEnvironment getCloudEnvironment() {
        return this.cloudEnvironment;
    }

    @Override
    protected MicrosoftTeamsAppIdentifier setRawId(String rawId) {
        super.setRawId(rawId);
        return this;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof MicrosoftTeamsAppIdentifier)) {
            return false;
        }
        return ((MicrosoftTeamsAppIdentifier)that).getRawId().equals(this.getRawId());
    }

    @Override
    public int hashCode() {
        return this.getRawId().hashCode();
    }

    private void generateRawId() {
        if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.DOD)) {
            super.setRawId("28:dod:" + this.appId);
        } else if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.GCCH)) {
            super.setRawId("28:gcch:" + this.appId);
        } else {
            super.setRawId("28:orgid:" + this.appId);
        }
    }
}

