/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.common;

import com.azure.android.communication.common.CommunicationCloudEnvironment;
import com.azure.android.communication.common.CommunicationIdentifier;

public final class MicrosoftTeamsUserIdentifier
extends CommunicationIdentifier {
    private final String userId;
    private final boolean isAnonymous;
    private boolean rawIdSet = false;
    private CommunicationCloudEnvironment cloudEnvironment = CommunicationCloudEnvironment.PUBLIC;

    public MicrosoftTeamsUserIdentifier(String userId, boolean isAnonymous) {
        if (userId == null || userId.trim().length() == 0) {
            throw new IllegalArgumentException("The initialization parameter [userId] cannot be null or empty.");
        }
        this.userId = userId;
        this.isAnonymous = isAnonymous;
        this.generateRawId();
    }

    public MicrosoftTeamsUserIdentifier(String userId) {
        this(userId, false);
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public MicrosoftTeamsUserIdentifier setCloudEnvironment(CommunicationCloudEnvironment cloudEnvironment) {
        this.cloudEnvironment = cloudEnvironment;
        this.generateRawId();
        return this;
    }

    public CommunicationCloudEnvironment getCloudEnvironment() {
        return this.cloudEnvironment;
    }

    @Override
    public MicrosoftTeamsUserIdentifier setRawId(String rawId) {
        super.setRawId(rawId);
        this.rawIdSet = true;
        return this;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof MicrosoftTeamsUserIdentifier)) {
            return false;
        }
        MicrosoftTeamsUserIdentifier thatId = (MicrosoftTeamsUserIdentifier)that;
        if (this.cloudEnvironment != null && !this.cloudEnvironment.equals((Object)thatId.cloudEnvironment)) {
            return false;
        }
        if (thatId.cloudEnvironment != null && !thatId.cloudEnvironment.equals((Object)this.cloudEnvironment)) {
            return false;
        }
        return this.getRawId() == null || thatId.getRawId() == null || thatId.getRawId().equals(this.getRawId());
    }

    @Override
    public int hashCode() {
        return this.getRawId().hashCode();
    }

    private void generateRawId() {
        if (!this.rawIdSet) {
            if (this.isAnonymous) {
                super.setRawId("8:teamsvisitor:" + this.userId);
            } else if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.DOD)) {
                super.setRawId("8:dod:" + this.userId);
            } else if (this.cloudEnvironment.equals((Object)CommunicationCloudEnvironment.GCCH)) {
                super.setRawId("8:gcch:" + this.userId);
            } else {
                super.setRawId("8:orgid:" + this.userId);
            }
        }
    }
}

