// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.implementation.MessagesImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateMessageRequest;
import com.azure.ai.agents.persistent.implementation.models.UpdateMessageRequest;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.MessageAttachment;
import com.azure.ai.agents.persistent.models.MessageRole;
import com.azure.ai.agents.persistent.models.ThreadMessage;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the asynchronous Messages type.
 */
@ServiceClient(builder = PersistentAgentsClientBuilder.class, isAsync = true)
public final class MessagesAsyncClient {

    @Generated
    private final MessagesImpl serviceClient;

    /**
     * Initializes an instance of MessagesAsyncClient class.
     *
     * @param serviceClient the service client implementation.
     */
    @Generated
    MessagesAsyncClient(MessagesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    /**
     * Creates a new message on a specified thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     role: String(user/assistant) (Required)
     *     content: BinaryData (Required)
     *     attachments (Optional): [
     *          (Optional){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param createMessageRequest The createMessageRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a single, existing message within an agent thread along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createMessageWithResponse(String threadId, BinaryData createMessageRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.createMessageWithResponseAsync(threadId, createMessageRequest, requestOptions);
    }

    /**
     * Gets a list of messages that exist on a thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>run_id</td><td>String</td><td>No</td><td>Filter messages by the run ID that generated them.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of messages that exist on a thread as paginated response with {@link PagedFlux}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMessages(String threadId, RequestOptions requestOptions) {
        return this.serviceClient.listMessagesAsync(threadId, requestOptions);
    }

    /**
     * Retrieves an existing message.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param messageId Identifier of the message.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a single, existing message within an agent thread along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMessageWithResponse(String threadId, String messageId,
        RequestOptions requestOptions) {
        return this.serviceClient.getMessageWithResponseAsync(threadId, messageId, requestOptions);
    }

    /**
     * Modifies an existing message on an existing thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param messageId Identifier of the message.
     * @param updateMessageRequest The updateMessageRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a single, existing message within an agent thread along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateMessageWithResponse(String threadId, String messageId,
        BinaryData updateMessageRequest, RequestOptions requestOptions) {
        return this.serviceClient.updateMessageWithResponseAsync(threadId, messageId, updateMessageRequest,
            requestOptions);
    }

    /**
     * Creates a new message on a specified thread.
     *
     * @param threadId Identifier of the thread.
     * @param role The role of the entity that is creating the message. Allowed values include:
     * `user`, which indicates the message is sent by an actual user (and should be
     * used in most cases to represent user-generated messages), and `assistant`,
     * which indicates the message is generated by the agent (use this value to insert
     * messages from the agent into the conversation).
     * @param content The content of the initial message. This may be a basic string (if you only
     * need text) or an array of typed content blocks (for example, text, image_file,
     * image_url, and so on).
     * @param attachments A list of files attached to the message, and the tools they should be added to.
     * @param metadata A set of up to 16 key/value pairs that can be attached to an object, used for storing additional
     * information about that object in a structured format. Keys may be up to 64 characters in length and values may be
     * up to 512 characters in length.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single, existing message within an agent thread on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThreadMessage> createMessage(String threadId, MessageRole role, BinaryData content,
        List<MessageAttachment> attachments, Map<String, String> metadata) {
        // Generated convenience method for createMessageWithResponse
        RequestOptions requestOptions = new RequestOptions();
        CreateMessageRequest createMessageRequestObj
            = new CreateMessageRequest(role, content).setAttachments(attachments).setMetadata(metadata);
        BinaryData createMessageRequest = BinaryData.fromObject(createMessageRequestObj);
        return createMessageWithResponse(threadId, createMessageRequest, requestOptions).flatMap(FluxUtil::toMono)
            .map(protocolMethodData -> protocolMethodData.toObject(ThreadMessage.class));
    }

    /**
     * Creates a new message on a specified thread.
     *
     * @param threadId Identifier of the thread.
     * @param role The role of the entity that is creating the message. Allowed values include:
     * `user`, which indicates the message is sent by an actual user (and should be
     * used in most cases to represent user-generated messages), and `assistant`,
     * which indicates the message is generated by the agent (use this value to insert
     * messages from the agent into the conversation).
     * @param content The content of the initial message. This may be a basic string (if you only
     * need text) or an array of typed content blocks (for example, text, image_file,
     * image_url, and so on).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single, existing message within an agent thread on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThreadMessage> createMessage(String threadId, MessageRole role, BinaryData content) {
        // Generated convenience method for createMessageWithResponse
        RequestOptions requestOptions = new RequestOptions();
        CreateMessageRequest createMessageRequestObj = new CreateMessageRequest(role, content);
        BinaryData createMessageRequest = BinaryData.fromObject(createMessageRequestObj);
        return createMessageWithResponse(threadId, createMessageRequest, requestOptions).flatMap(FluxUtil::toMono)
            .map(protocolMethodData -> protocolMethodData.toObject(ThreadMessage.class));
    }

    /**
     * Gets a list of messages that exist on a thread.
     *
     * @param threadId Identifier of the thread.
     * @param runId Filter messages by the run ID that generated them.
     * @param limit A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default
     * is 20.
     * @param order Sort order by the created_at timestamp of the objects. asc for ascending order and desc for
     * descending order.
     * @param after A cursor for use in pagination. after is an object ID that defines your place in the list. For
     * instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can
     * include after=obj_foo in order to fetch the next page of the list.
     * @param before A cursor for use in pagination. before is an object ID that defines your place in the list. For
     * instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can
     * include before=obj_foo in order to fetch the previous page of the list.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of messages that exist on a thread as paginated response with {@link PagedFlux}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ThreadMessage> listMessages(String threadId, String runId, Integer limit, ListSortOrder order,
        String after, String before) {
        // Generated convenience method for listMessages
        RequestOptions requestOptions = new RequestOptions();
        if (runId != null) {
            requestOptions.addQueryParam("run_id", runId, false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = listMessages(threadId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux<PagedResponse<BinaryData>> flux = (continuationTokenParam == null)
                ? pagedFluxResponse.byPage().take(1)
                : pagedFluxResponse.byPage(continuationTokenParam).take(1);
            return flux.map(pagedResponse -> new PagedResponseBase<Void, ThreadMessage>(pagedResponse.getRequest(),
                pagedResponse.getStatusCode(), pagedResponse.getHeaders(),
                pagedResponse.getValue()
                    .stream()
                    .map(protocolMethodData -> protocolMethodData.toObject(ThreadMessage.class))
                    .collect(Collectors.toList()),
                pagedResponse.getContinuationToken(), null));
        });
    }

    /**
     * Gets a list of messages that exist on a thread.
     *
     * @param threadId Identifier of the thread.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of messages that exist on a thread as paginated response with {@link PagedFlux}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ThreadMessage> listMessages(String threadId) {
        // Generated convenience method for listMessages
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = listMessages(threadId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux<PagedResponse<BinaryData>> flux = (continuationTokenParam == null)
                ? pagedFluxResponse.byPage().take(1)
                : pagedFluxResponse.byPage(continuationTokenParam).take(1);
            return flux.map(pagedResponse -> new PagedResponseBase<Void, ThreadMessage>(pagedResponse.getRequest(),
                pagedResponse.getStatusCode(), pagedResponse.getHeaders(),
                pagedResponse.getValue()
                    .stream()
                    .map(protocolMethodData -> protocolMethodData.toObject(ThreadMessage.class))
                    .collect(Collectors.toList()),
                pagedResponse.getContinuationToken(), null));
        });
    }

    /**
     * Retrieves an existing message.
     *
     * @param threadId Identifier of the thread.
     * @param messageId Identifier of the message.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single, existing message within an agent thread on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThreadMessage> getMessage(String threadId, String messageId) {
        // Generated convenience method for getMessageWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getMessageWithResponse(threadId, messageId, requestOptions).flatMap(FluxUtil::toMono)
            .map(protocolMethodData -> protocolMethodData.toObject(ThreadMessage.class));
    }

    /**
     * Modifies an existing message on an existing thread.
     *
     * @param threadId Identifier of the thread.
     * @param messageId Identifier of the message.
     * @param metadata A set of up to 16 key/value pairs that can be attached to an object, used for storing additional
     * information about that object in a structured format. Keys may be up to 64 characters in length and values may be
     * up to 512 characters in length.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single, existing message within an agent thread on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThreadMessage> updateMessage(String threadId, String messageId, Map<String, String> metadata) {
        // Generated convenience method for updateMessageWithResponse
        RequestOptions requestOptions = new RequestOptions();
        UpdateMessageRequest updateMessageRequestObj = new UpdateMessageRequest().setMetadata(metadata);
        BinaryData updateMessageRequest = BinaryData.fromObject(updateMessageRequestObj);
        return updateMessageWithResponse(threadId, messageId, updateMessageRequest, requestOptions)
            .flatMap(FluxUtil::toMono)
            .map(protocolMethodData -> protocolMethodData.toObject(ThreadMessage.class));
    }

    /**
     * Modifies an existing message on an existing thread.
     *
     * @param threadId Identifier of the thread.
     * @param messageId Identifier of the message.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single, existing message within an agent thread on successful completion of {@link Mono}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThreadMessage> updateMessage(String threadId, String messageId) {
        // Generated convenience method for updateMessageWithResponse
        RequestOptions requestOptions = new RequestOptions();
        UpdateMessageRequest updateMessageRequestObj = new UpdateMessageRequest();
        BinaryData updateMessageRequest = BinaryData.fromObject(updateMessageRequestObj);
        return updateMessageWithResponse(threadId, messageId, updateMessageRequest, requestOptions)
            .flatMap(FluxUtil::toMono)
            .map(protocolMethodData -> protocolMethodData.toObject(ThreadMessage.class));
    }

    /**
     * Creates a new message on a specified thread.
     *
     * @param threadId Identifier of the thread.
     * @param role The role of the entity that is creating the message. Allowed values include:
     * `user`, which indicates the message is sent by an actual user (and should be
     * used in most cases to represent user-generated messages), and `assistant`,
     * which indicates the message is generated by the agent (use this value to insert
     * messages from the agent into the conversation).
     * @param content The content of the initial message. This may be a basic string (if you only
     * need text) or an array of typed content blocks (for example, text, image_file,
     * image_url, and so on).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single, existing message within an agent thread on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThreadMessage> createMessage(String threadId, MessageRole role, String content) {
        // Generated convenience method for createMessage
        BinaryData binaryContent = BinaryData.fromString(content);
        return createMessage(threadId, role, binaryContent);
    }

    /**
     * Creates a new message on a specified thread.
     *
     * @param threadId Identifier of the thread.
     * @param role The role of the entity that is creating the message. Allowed values include:
     * `user`, which indicates the message is sent by an actual user (and should be
     * used in most cases to represent user-generated messages), and `assistant`,
     * which indicates the message is generated by the agent (use this value to insert
     * messages from the agent into the conversation).
     * @param content The content of the initial message. This may be a basic string (if you only
     * need text) or an array of typed content blocks (for example, text, image_file,
     * image_url, and so on).
     * @param attachments A list of files attached to the message, and the tools they should be added to.
     * @param metadata A set of up to 16 key/value pairs that can be attached to an object, used for storing additional
     * information about that object in a structured format. Keys may be up to 64 characters in length and values may be
     * up to 512 characters in length.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single, existing message within an agent thread on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThreadMessage> createMessage(String threadId, MessageRole role, String content,
        List<MessageAttachment> attachments, Map<String, String> metadata) {
        // Generated convenience method for createMessage
        BinaryData binaryContent = BinaryData.fromString(content);
        return createMessage(threadId, role, binaryContent, attachments, metadata);
    }
}
