// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.implementation.PersistentAgentsClientImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateThreadAndRunRequest;
import com.azure.ai.agents.persistent.models.CreateThreadAndRunOptions;
import com.azure.ai.agents.persistent.models.ThreadRun;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

/**
 * Initializes a new instance of the synchronous PersistentAgentsClient type.
 */
@ServiceClient(builder = PersistentAgentsClientBuilder.class)
public final class PersistentAgentsClient {

    @Generated
    private final PersistentAgentsClientImpl serviceClient;

    /**
     * Initializes an instance of PersistentAgentsClient class.
     *
     * @param serviceClient the service client implementation.
     */
    @Generated
    PersistentAgentsClient(PersistentAgentsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    /**
     * Gets an instance of PersistentAgentsAdministrationClient class.
     *
     * @return an instance of PersistentAgentsAdministrationClient class.
     */
    public PersistentAgentsAdministrationClient getPersistentAgentsAdministrationClient() {
        return new PersistentAgentsAdministrationClient(serviceClient.getPersistentAgentsAdministration());
    }

    /**
     * Gets an instance of FilesClient class.
     *
     * @return an instance of FilesClient class.
     */
    public FilesClient getFilesClient() {
        return new FilesClient(serviceClient.getFiles());
    }

    /**
     * Gets an instance of MessagesClient class.
     *
     * @return an instance of MessagesClient class.
     */
    public MessagesClient getMessagesClient() {
        return new MessagesClient(serviceClient.getMessages());
    }

    /**
     * Gets an instance of RunsClient class.
     *
     * @return an instance of RunsClient class.
     */
    public RunsClient getRunsClient() {
        return new RunsClient(serviceClient.getRuns());
    }

    /**
     * Gets an instance of ThreadsClient class.
     *
     * @return an instance of ThreadsClient class.
     */
    public ThreadsClient getThreadsClient() {
        return new ThreadsClient(serviceClient.getThreads());
    }

    /**
     * Gets an instance of VectorStoresClient class.
     *
     * @return an instance of VectorStoresClient class.
     */
    public VectorStoresClient getVectorStoresClient() {
        return new VectorStoresClient(serviceClient.getVectorStores());
    }

    /**
     * Creates a new agent thread and immediately starts a run using that new thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     assistant_id: String (Required)
     *     thread (Optional): {
     *         messages (Optional): [
     *              (Optional){
     *                 role: String(user/assistant) (Required)
     *                 content: BinaryData (Required)
     *                 attachments (Optional): [
     *                      (Optional){
     *                         file_id: String (Optional)
     *                         data_source (Optional): {
     *                             uri: String (Required)
     *                             type: String(uri_asset/id_asset) (Required)
     *                         }
     *                         tools (Required): [
     *                             BinaryData (Required)
     *                         ]
     *                     }
     *                 ]
     *                 metadata (Optional): {
     *                     String: String (Required)
     *                 }
     *             }
     *         ]
     *         tool_resources (Optional): {
     *             code_interpreter (Optional): {
     *                 file_ids (Optional): [
     *                     String (Optional)
     *                 ]
     *                 data_sources (Optional): [
     *                     (recursive schema, see above)
     *                 ]
     *             }
     *             file_search (Optional): {
     *                 vector_store_ids (Optional): [
     *                     String (Optional)
     *                 ]
     *                 vector_stores (Optional): [
     *                      (Optional){
     *                         name: String (Required)
     *                         configuration (Required): {
     *                             data_sources (Required): [
     *                                 (recursive schema, see above)
     *                             ]
     *                         }
     *                     }
     *                 ]
     *             }
     *             azure_ai_search (Optional): {
     *                 indexes (Optional): [
     *                      (Optional){
     *                         index_connection_id: String (Optional)
     *                         index_name: String (Optional)
     *                         query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                         top_k: Integer (Optional)
     *                         filter: String (Optional)
     *                         index_asset_id: String (Optional)
     *                     }
     *                 ]
     *             }
     *         }
     *         metadata (Optional): {
     *             String: String (Required)
     *         }
     *     }
     *     model: String (Optional)
     *     instructions: String (Optional)
     *     tools (Optional): [
     *          (Optional){
     *             type: String (Required)
     *         }
     *     ]
     *     tool_resources (Optional): (recursive schema, see tool_resources above)
     *     stream: Boolean (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Optional)
     *     max_completion_tokens: Integer (Optional)
     *     truncation_strategy (Optional): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Optional)
     *     response_format: BinaryData (Optional)
     *     parallel_tool_calls: Boolean (Optional)
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     *
     * @param createThreadAndRunRequest The createThreadAndRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createThreadAndRunWithResponse(BinaryData createThreadAndRunRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.createThreadAndRunWithResponse(createThreadAndRunRequest, requestOptions);
    }

    /**
     * Creates a new agent thread and immediately starts a run using that new thread.
     *
     * @param options Options for createThreadAndRun API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data representing a single evaluation run of an agent thread.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThreadRun createThreadAndRun(CreateThreadAndRunOptions options) {
        // Generated convenience method for createThreadAndRunWithResponse
        RequestOptions requestOptions = new RequestOptions();
        CreateThreadAndRunRequest createThreadAndRunRequestObj
            = new CreateThreadAndRunRequest(options.getAssistantId()).setThread(options.getThread())
                .setModel(options.getModel())
                .setInstructions(options.getInstructions())
                .setTools(options.getTools())
                .setToolResources(options.getToolResources())
                .setStream(options.isStream())
                .setTemperature(options.getTemperature())
                .setTopP(options.getTopP())
                .setMaxPromptTokens(options.getMaxPromptTokens())
                .setMaxCompletionTokens(options.getMaxCompletionTokens())
                .setTruncationStrategy(options.getTruncationStrategy())
                .setToolChoice(options.getToolChoice())
                .setResponseFormat(options.getResponseFormat())
                .setParallelToolCalls(options.isParallelToolCalls())
                .setMetadata(options.getMetadata());
        BinaryData createThreadAndRunRequest = BinaryData.fromObject(createThreadAndRunRequestObj);
        return createThreadAndRunWithResponse(createThreadAndRunRequest, requestOptions).getValue()
            .toObject(ThreadRun.class);
    }
}
