// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.agents.persistent;

import com.azure.core.util.ServiceVersion;

/**
 * Service version of Persistent AgentsClient.
 */
public enum PersistentAgentsServiceVersion implements ServiceVersion {
    /**
     * Enum value 2025-05-01.
     */
    V2025_05_01("2025-05-01"),

    /**
     * Enum value v1.
     */
    V1("v1"),

    /**
     * Enum value 2025-05-15-preview.
     */
    V2025_05_15_PREVIEW("2025-05-15-preview");

    private final String version;

    PersistentAgentsServiceVersion(String version) {
        this.version = version;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getVersion() {
        return this.version;
    }

    /**
     * Gets the latest service version supported by this client library.
     * 
     * @return The latest {@link PersistentAgentsServiceVersion}.
     */
    public static PersistentAgentsServiceVersion getLatest() {
        return V2025_05_15_PREVIEW;
    }
}
