// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.implementation.RunsImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateRunRequest;
import com.azure.ai.agents.persistent.implementation.models.SubmitToolOutputsToRunRequest;
import com.azure.ai.agents.persistent.implementation.models.UpdateRunRequest;
import com.azure.ai.agents.persistent.models.CreateRunOptions;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.PersistentAgentServerSentEvents;
import com.azure.ai.agents.persistent.models.RunAdditionalFieldList;
import com.azure.ai.agents.persistent.models.RunStep;
import com.azure.ai.agents.persistent.models.StreamUpdate;
import com.azure.ai.agents.persistent.models.ThreadRun;
import com.azure.ai.agents.persistent.models.ToolOutput;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import reactor.core.publisher.Flux;

/**
 * Initializes a new instance of the synchronous Runs type.
 */
@ServiceClient(builder = PersistentAgentsClientBuilder.class)
public final class RunsClient {

    private final ClientLogger logger = new ClientLogger(RunsClient.class);

    @Generated
    private final RunsImpl serviceClient;

    /**
     * Initializes an instance of RunsClient class.
     *
     * @param serviceClient the service client implementation.
     */
    @Generated
    RunsClient(RunsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    /**
     * Creates a new run for an agent thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content`
     * to fetch the file search result content. In the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     assistant_id: String (Required)
     *     model: String (Optional)
     *     instructions: String (Optional)
     *     additional_instructions: String (Optional)
     *     additional_messages (Optional): [
     *          (Optional){
     *             role: String(user/assistant) (Required)
     *             content: BinaryData (Required)
     *             attachments (Optional): [
     *                  (Optional){
     *                     file_id: String (Optional)
     *                     data_source (Optional): {
     *                         uri: String (Required)
     *                         type: String(uri_asset/id_asset) (Required)
     *                     }
     *                     tools (Required): [
     *                         BinaryData (Required)
     *                     ]
     *                 }
     *             ]
     *             metadata (Optional): {
     *                 String: String (Required)
     *             }
     *         }
     *     ]
     *     tools (Optional): [
     *          (Optional){
     *             type: String (Required)
     *         }
     *     ]
     *     stream: Boolean (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Optional)
     *     max_completion_tokens: Integer (Optional)
     *     truncation_strategy (Optional): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Optional)
     *     response_format: BinaryData (Optional)
     *     parallel_tool_calls: Boolean (Optional)
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param createRunRequest The createRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createRunWithResponse(String threadId, BinaryData createRunRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.createRunWithResponse(threadId, createRunRequest, requestOptions);
    }

    /**
     * Gets a list of runs for a specified thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of runs for a specified thread as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listRuns(String threadId, RequestOptions requestOptions) {
        return this.serviceClient.listRuns(threadId, requestOptions);
    }

    /**
     * Gets an existing run from an existing thread.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return an existing run from an existing thread along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        return this.serviceClient.getRunWithResponse(threadId, runId, requestOptions);
    }

    /**
     * Modifies an existing thread run.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param updateRunRequest The updateRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateRunWithResponse(String threadId, String runId, BinaryData updateRunRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.updateRunWithResponse(threadId, runId, updateRunRequest, requestOptions);
    }

    /**
     * Submits outputs from tools as requested by tool calls in a run.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     tool_outputs (Required): [
     *          (Required){
     *             tool_call_id: String (Optional)
     *             output: String (Optional)
     *         }
     *     ]
     *     stream: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param submitToolOutputsToRunRequest The submitToolOutputsToRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> submitToolOutputsToRunWithResponse(String threadId, String runId,
        BinaryData submitToolOutputsToRunRequest, RequestOptions requestOptions) {
        return this.serviceClient.submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest,
            requestOptions);
    }

    /**
     * Cancels a run of an in‐progress thread.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> cancelRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        return this.serviceClient.cancelRunWithResponse(threadId, runId, requestOptions);
    }

    /**
     * Retrieves a single run step from a thread run.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content` to fetch the
     * file search result content. In the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     type: String(message_creation/tool_calls) (Required)
     *     assistant_id: String (Required)
     *     thread_id: String (Required)
     *     run_id: String (Required)
     *     status: String(in_progress/cancelled/failed/completed/expired) (Required)
     *     step_details (Required): {
     *         type: String(message_creation/tool_calls) (Required)
     *     }
     *     last_error (Required): {
     *         code: String(server_error/rate_limit_exceeded) (Required)
     *         message: String (Required)
     *     }
     *     created_at: long (Required)
     *     expired_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     usage (Optional): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param stepId Identifier of the run step.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed information about a single step of an agent thread run along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getRunStepWithResponse(String threadId, String runId, String stepId,
        RequestOptions requestOptions) {
        return this.serviceClient.getRunStepWithResponse(threadId, runId, stepId, requestOptions);
    }

    /**
     * Gets a list of run steps from a thread run.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content` to fetch the
     * file search result content. In the form of "," separated string.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     type: String(message_creation/tool_calls) (Required)
     *     assistant_id: String (Required)
     *     thread_id: String (Required)
     *     run_id: String (Required)
     *     status: String(in_progress/cancelled/failed/completed/expired) (Required)
     *     step_details (Required): {
     *         type: String(message_creation/tool_calls) (Required)
     *     }
     *     last_error (Required): {
     *         code: String(server_error/rate_limit_exceeded) (Required)
     *         message: String (Required)
     *     }
     *     created_at: long (Required)
     *     expired_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     usage (Optional): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of run steps from a thread run as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listRunSteps(String threadId, String runId, RequestOptions requestOptions) {
        return this.serviceClient.listRunSteps(threadId, runId, requestOptions);
    }

    /**
     * Creates a new run for an agent thread.
     *
     * @param options Options for createRun API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data representing a single evaluation run of an agent thread.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThreadRun createRun(CreateRunOptions options) {
        // Generated convenience method for createRunWithResponse
        RequestOptions requestOptions = new RequestOptions();
        String threadId = options.getThreadId();
        List<RunAdditionalFieldList> include = options.getInclude();
        CreateRunRequest createRunRequestObj
            = new CreateRunRequest(options.getAssistantId()).setModel(options.getModel())
                .setInstructions(options.getInstructions())
                .setAdditionalInstructions(options.getAdditionalInstructions())
                .setAdditionalMessages(options.getAdditionalMessages())
                .setTools(options.getTools())
                .setStream(options.isStream())
                .setTemperature(options.getTemperature())
                .setTopP(options.getTopP())
                .setMaxPromptTokens(options.getMaxPromptTokens())
                .setMaxCompletionTokens(options.getMaxCompletionTokens())
                .setTruncationStrategy(options.getTruncationStrategy())
                .setToolChoice(options.getToolChoice())
                .setResponseFormat(options.getResponseFormat())
                .setParallelToolCalls(options.isParallelToolCalls())
                .setMetadata(options.getMetadata());
        BinaryData createRunRequest = BinaryData.fromObject(createRunRequestObj);
        if (include != null) {
            requestOptions.addQueryParam("include[]",
                include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(",")),
                false);
        }
        return createRunWithResponse(threadId, createRunRequest, requestOptions).getValue().toObject(ThreadRun.class);
    }

    /**
     * Gets a list of runs for a specified thread.
     *
     * @param threadId Identifier of the thread.
     * @param limit A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default
     * is 20.
     * @param order Sort order by the created_at timestamp of the objects. asc for ascending order and desc for
     * descending order.
     * @param after A cursor for use in pagination. after is an object ID that defines your place in the list. For
     * instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can
     * include after=obj_foo in order to fetch the next page of the list.
     * @param before A cursor for use in pagination. before is an object ID that defines your place in the list. For
     * instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can
     * include before=obj_foo in order to fetch the previous page of the list.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of runs for a specified thread as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ThreadRun> listRuns(String threadId, Integer limit, ListSortOrder order, String after,
        String before) {
        // Generated convenience method for listRuns
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return serviceClient.listRuns(threadId, requestOptions)
            .mapPage(bodyItemValue -> bodyItemValue.toObject(ThreadRun.class));
    }

    /**
     * Gets a list of runs for a specified thread.
     *
     * @param threadId Identifier of the thread.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of runs for a specified thread as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ThreadRun> listRuns(String threadId) {
        // Generated convenience method for listRuns
        RequestOptions requestOptions = new RequestOptions();
        return serviceClient.listRuns(threadId, requestOptions)
            .mapPage(bodyItemValue -> bodyItemValue.toObject(ThreadRun.class));
    }

    /**
     * Gets an existing run from an existing thread.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing run from an existing thread.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThreadRun getRun(String threadId, String runId) {
        // Generated convenience method for getRunWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getRunWithResponse(threadId, runId, requestOptions).getValue().toObject(ThreadRun.class);
    }

    /**
     * Modifies an existing thread run.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param metadata A set of up to 16 key/value pairs that can be attached to an object, used for storing additional
     * information about that object in a structured format. Keys may be up to 64 characters in length and values may be
     * up to 512 characters in length.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data representing a single evaluation run of an agent thread.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThreadRun updateRun(String threadId, String runId, Map<String, String> metadata) {
        // Generated convenience method for updateRunWithResponse
        RequestOptions requestOptions = new RequestOptions();
        UpdateRunRequest updateRunRequestObj = new UpdateRunRequest().setMetadata(metadata);
        BinaryData updateRunRequest = BinaryData.fromObject(updateRunRequestObj);
        return updateRunWithResponse(threadId, runId, updateRunRequest, requestOptions).getValue()
            .toObject(ThreadRun.class);
    }

    /**
     * Modifies an existing thread run.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data representing a single evaluation run of an agent thread.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThreadRun updateRun(String threadId, String runId) {
        // Generated convenience method for updateRunWithResponse
        RequestOptions requestOptions = new RequestOptions();
        UpdateRunRequest updateRunRequestObj = new UpdateRunRequest();
        BinaryData updateRunRequest = BinaryData.fromObject(updateRunRequestObj);
        return updateRunWithResponse(threadId, runId, updateRunRequest, requestOptions).getValue()
            .toObject(ThreadRun.class);
    }

    /**
     * Submits outputs from tools as requested by tool calls in a run.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param toolOutputs A list of tools for which the outputs are being submitted.
     * @param stream If true, returns a stream of events that happen during the Run as SSE, terminating at `[DONE]`.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data representing a single evaluation run of an agent thread.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThreadRun submitToolOutputsToRun(String threadId, String runId, List<ToolOutput> toolOutputs,
        Boolean stream) {
        // Generated convenience method for submitToolOutputsToRunWithResponse
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest submitToolOutputsToRunRequestObj
            = new SubmitToolOutputsToRunRequest(toolOutputs).setStream(stream);
        BinaryData submitToolOutputsToRunRequest = BinaryData.fromObject(submitToolOutputsToRunRequestObj);
        return submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest, requestOptions)
            .getValue()
            .toObject(ThreadRun.class);
    }

    /**
     * Submits outputs from tools as requested by tool calls in a run.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param toolOutputs A list of tools for which the outputs are being submitted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data representing a single evaluation run of an agent thread.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThreadRun submitToolOutputsToRun(String threadId, String runId, List<ToolOutput> toolOutputs) {
        // Generated convenience method for submitToolOutputsToRunWithResponse
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest submitToolOutputsToRunRequestObj = new SubmitToolOutputsToRunRequest(toolOutputs);
        BinaryData submitToolOutputsToRunRequest = BinaryData.fromObject(submitToolOutputsToRunRequestObj);
        return submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest, requestOptions)
            .getValue()
            .toObject(ThreadRun.class);
    }

    /**
     * Cancels a run of an in‐progress thread.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data representing a single evaluation run of an agent thread.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThreadRun cancelRun(String threadId, String runId) {
        // Generated convenience method for cancelRunWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return cancelRunWithResponse(threadId, runId, requestOptions).getValue().toObject(ThreadRun.class);
    }

    /**
     * Retrieves a single run step from a thread run.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param stepId Identifier of the run step.
     * @param include A list of additional fields to include in the response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content` to fetch the
     * file search result content.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a single step of an agent thread run.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RunStep getRunStep(String threadId, String runId, String stepId, List<RunAdditionalFieldList> include) {
        // Generated convenience method for getRunStepWithResponse
        RequestOptions requestOptions = new RequestOptions();
        if (include != null) {
            requestOptions.addQueryParam("include[]",
                include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(",")),
                false);
        }
        return getRunStepWithResponse(threadId, runId, stepId, requestOptions).getValue().toObject(RunStep.class);
    }

    /**
     * Retrieves a single run step from a thread run.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param stepId Identifier of the run step.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed information about a single step of an agent thread run.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RunStep getRunStep(String threadId, String runId, String stepId) {
        // Generated convenience method for getRunStepWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getRunStepWithResponse(threadId, runId, stepId, requestOptions).getValue().toObject(RunStep.class);
    }

    /**
     * Gets a list of run steps from a thread run.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param include A list of additional fields to include in the response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content` to fetch the
     * file search result content.
     * @param limit A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default
     * is 20.
     * @param order Sort order by the created_at timestamp of the objects. asc for ascending order and desc for
     * descending order.
     * @param after A cursor for use in pagination. after is an object ID that defines your place in the list. For
     * instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can
     * include after=obj_foo in order to fetch the next page of the list.
     * @param before A cursor for use in pagination. before is an object ID that defines your place in the list. For
     * instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can
     * include before=obj_foo in order to fetch the previous page of the list.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of run steps from a thread run as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RunStep> listRunSteps(String threadId, String runId, List<RunAdditionalFieldList> include,
        Integer limit, ListSortOrder order, String after, String before) {
        // Generated convenience method for listRunSteps
        RequestOptions requestOptions = new RequestOptions();
        if (include != null) {
            requestOptions.addQueryParam("include[]",
                include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(",")),
                false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return serviceClient.listRunSteps(threadId, runId, requestOptions)
            .mapPage(bodyItemValue -> bodyItemValue.toObject(RunStep.class));
    }

    /**
     * Gets a list of run steps from a thread run.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of run steps from a thread run as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RunStep> listRunSteps(String threadId, String runId) {
        // Generated convenience method for listRunSteps
        RequestOptions requestOptions = new RequestOptions();
        return serviceClient.listRunSteps(threadId, runId, requestOptions)
            .mapPage(bodyItemValue -> bodyItemValue.toObject(RunStep.class));
    }

    /**
     * Creates a new streaming run for an agent thread.
     *
     * @param options Options for createRun API.
     * @return data representing a single evaluation run of an agent thread.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Stream<StreamUpdate> createRunStreaming(CreateRunOptions options) {
        // Generated convenience method for createRunWithResponse
        RequestOptions requestOptions = new RequestOptions();
        String threadId = options.getThreadId();
        List<RunAdditionalFieldList> include = options.getInclude();
        CreateRunRequest createRunRequestObj
            = new CreateRunRequest(options.getAssistantId()).setModel(options.getModel())
                .setInstructions(options.getInstructions())
                .setAdditionalInstructions(options.getAdditionalInstructions())
                .setAdditionalMessages(options.getAdditionalMessages())
                .setTools(options.getTools())
                .setStream(true)
                .setTemperature(options.getTemperature())
                .setTopP(options.getTopP())
                .setMaxPromptTokens(options.getMaxPromptTokens())
                .setMaxCompletionTokens(options.getMaxCompletionTokens())
                .setTruncationStrategy(options.getTruncationStrategy())
                .setToolChoice(options.getToolChoice())
                .setResponseFormat(options.getResponseFormat())
                .setParallelToolCalls(options.isParallelToolCalls())
                .setMetadata(options.getMetadata());
        BinaryData createRunRequest = BinaryData.fromObject(createRunRequestObj);
        if (include != null) {
            requestOptions.addQueryParam("include[]",
                include.stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(",")),
                false);
        }
        Flux<ByteBuffer> response
            = createRunWithResponse(threadId, createRunRequest, requestOptions).getValue().toFluxByteBuffer();
        PersistentAgentServerSentEvents eventStream = new PersistentAgentServerSentEvents(response);
        Iterable<StreamUpdate> iterable = eventStream.getEvents().toIterable();
        Stream<StreamUpdate> stream = StreamSupport.stream(iterable.spliterator(), false);
        return stream.onClose(() -> {
            if (iterable instanceof AutoCloseable) {
                try {
                    ((AutoCloseable) iterable).close();
                } catch (Exception e) {
                    throw logger.logExceptionAsError(new RuntimeException(e));
                }
            }
        });
    }

    /**
     * Submits outputs from tools as requested by tool calls in a run with streaming updates.
     * Runs that need submitted tool outputs will have a status of 'requires_action'
     * with a required_action.type of 'submit_tool_outputs'.
     *
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param toolOutputs A list of tools for which the outputs are being submitted.
     * @return data representing a single evaluation run of an agent thread.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Stream<StreamUpdate> submitToolOutputsToRunStreaming(String threadId, String runId,
        List<ToolOutput> toolOutputs) {
        // Generated convenience method for submitToolOutputsToRunWithResponse
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest submitToolOutputsToRunRequestObj
            = new SubmitToolOutputsToRunRequest(toolOutputs).setStream(true);
        BinaryData submitToolOutputsToRunRequest = BinaryData.fromObject(submitToolOutputsToRunRequestObj);
        Flux<ByteBuffer> response
            = submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest, requestOptions)
                .getValue()
                .toFluxByteBuffer();
        PersistentAgentServerSentEvents eventStream = new PersistentAgentServerSentEvents(response);
        Iterable<StreamUpdate> iterable = eventStream.getEvents().toIterable();
        Stream<StreamUpdate> stream = StreamSupport.stream(iterable.spliterator(), false);
        return stream.onClose(() -> {
            if (iterable instanceof AutoCloseable) {
                try {
                    ((AutoCloseable) iterable).close();
                } catch (Exception e) {
                    throw logger.logExceptionAsError(new RuntimeException(e));
                }
            }
        });
    }
}
