// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.agents.persistent.implementation;

import com.azure.ai.agents.persistent.PersistentAgentsServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the Messages type.
 */
public final class MessagesImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final MessagesService service;

    /**
     * Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     */
    private final String endpoint;

    /**
     * Gets Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Service version.
     */
    private final PersistentAgentsServiceVersion serviceVersion;

    /**
     * Gets Service version.
     * 
     * @return the serviceVersion value.
     */
    public PersistentAgentsServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of Messages client.
     * 
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public MessagesImpl(String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of Messages client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public MessagesImpl(HttpPipeline httpPipeline, String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of Messages client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public MessagesImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint,
        PersistentAgentsServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = RestProxy.create(MessagesService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for Messages to be used by the proxy service to perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "Messages")
    public interface MessagesService {
        @Post("/threads/{threadId}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> createMessage(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData createMessageRequest, RequestOptions requestOptions,
            Context context);

        @Post("/threads/{threadId}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> createMessageSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData createMessageRequest, RequestOptions requestOptions,
            Context context);

        @Get("/threads/{threadId}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listMessages(@HostParam("endpoint") String endpoint,
            @PathParam("threadId") String threadId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}/messages")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listMessagesSync(@HostParam("endpoint") String endpoint,
            @PathParam("threadId") String threadId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}/messages/{messageId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getMessage(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("messageId") String messageId, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}/messages/{messageId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getMessageSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("messageId") String messageId, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Post("/threads/{threadId}/messages/{messageId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> updateMessage(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("messageId") String messageId, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData updateMessageRequest,
            RequestOptions requestOptions, Context context);

        @Post("/threads/{threadId}/messages/{messageId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> updateMessageSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("messageId") String messageId, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData updateMessageRequest,
            RequestOptions requestOptions, Context context);
    }

    /**
     * Creates a new message on a specified thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     role: String(user/assistant) (Required)
     *     content: BinaryData (Required)
     *     attachments (Optional): [
     *          (Optional){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param createMessageRequest The createMessageRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a single, existing message within an agent thread along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createMessageWithResponseAsync(String threadId, BinaryData createMessageRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createMessage(this.getEndpoint(), this.getServiceVersion().getVersion(),
                threadId, contentType, accept, createMessageRequest, requestOptions, context));
    }

    /**
     * Creates a new message on a specified thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     role: String(user/assistant) (Required)
     *     content: BinaryData (Required)
     *     attachments (Optional): [
     *          (Optional){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param createMessageRequest The createMessageRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a single, existing message within an agent thread along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createMessageWithResponse(String threadId, BinaryData createMessageRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.createMessageSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId,
            contentType, accept, createMessageRequest, requestOptions, Context.NONE);
    }

    /**
     * Gets a list of messages that exist on a thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>run_id</td><td>String</td><td>No</td><td>Filter messages by the run ID that generated them.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of messages that exist on a thread along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listMessagesSinglePageAsync(String threadId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listMessages(this.getEndpoint(), threadId,
                this.getServiceVersion().getVersion(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "data"), null, null));
    }

    /**
     * Gets a list of messages that exist on a thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>run_id</td><td>String</td><td>No</td><td>Filter messages by the run ID that generated them.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of messages that exist on a thread as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMessagesAsync(String threadId, RequestOptions requestOptions) {
        return new PagedFlux<>(() -> listMessagesSinglePageAsync(threadId, requestOptions));
    }

    /**
     * Gets a list of messages that exist on a thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>run_id</td><td>String</td><td>No</td><td>Filter messages by the run ID that generated them.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of messages that exist on a thread along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listMessagesSinglePage(String threadId, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listMessagesSync(this.getEndpoint(), threadId,
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "data"), null, null);
    }

    /**
     * Gets a list of messages that exist on a thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>run_id</td><td>String</td><td>No</td><td>Filter messages by the run ID that generated them.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of messages that exist on a thread as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMessages(String threadId, RequestOptions requestOptions) {
        return new PagedIterable<>(() -> listMessagesSinglePage(threadId, requestOptions));
    }

    /**
     * Retrieves an existing message.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param messageId Identifier of the message.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a single, existing message within an agent thread along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMessageWithResponseAsync(String threadId, String messageId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getMessage(this.getEndpoint(),
            this.getServiceVersion().getVersion(), threadId, messageId, accept, requestOptions, context));
    }

    /**
     * Retrieves an existing message.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param messageId Identifier of the message.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a single, existing message within an agent thread along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getMessageWithResponse(String threadId, String messageId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getMessageSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, messageId,
            accept, requestOptions, Context.NONE);
    }

    /**
     * Modifies an existing message on an existing thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param messageId Identifier of the message.
     * @param updateMessageRequest The updateMessageRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a single, existing message within an agent thread along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateMessageWithResponseAsync(String threadId, String messageId,
        BinaryData updateMessageRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateMessage(this.getEndpoint(), this.getServiceVersion().getVersion(),
                threadId, messageId, contentType, accept, updateMessageRequest, requestOptions, context));
    }

    /**
     * Modifies an existing message on an existing thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     thread_id: String (Required)
     *     status: String(in_progress/incomplete/completed) (Required)
     *     incomplete_details (Required): {
     *         reason: String(content_filter/max_tokens/run_cancelled/run_failed/run_expired) (Required)
     *     }
     *     completed_at: Long (Required)
     *     incomplete_at: Long (Required)
     *     role: String(user/assistant) (Required)
     *     content (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     assistant_id: String (Required)
     *     run_id: String (Required)
     *     attachments (Required): [
     *          (Required){
     *             file_id: String (Optional)
     *             data_source (Optional): {
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *             tools (Required): [
     *                 BinaryData (Required)
     *             ]
     *         }
     *     ]
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param messageId Identifier of the message.
     * @param updateMessageRequest The updateMessageRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a single, existing message within an agent thread along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateMessageWithResponse(String threadId, String messageId,
        BinaryData updateMessageRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.updateMessageSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, messageId,
            contentType, accept, updateMessageRequest, requestOptions, Context.NONE);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            List<?> values = (List<?>) obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        } catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            return (String) obj.get(path);
        } catch (RuntimeException e) {
            return null;
        }
    }
}
