// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.agents.persistent.implementation;

import com.azure.ai.agents.persistent.PersistentAgentsServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the PersistentAgentsClient type.
 */
public final class PersistentAgentsClientImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final PersistentAgentsClientService service;

    /**
     * Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     */
    private final String endpoint;

    /**
     * Gets Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Service version.
     */
    private final PersistentAgentsServiceVersion serviceVersion;

    /**
     * Gets Service version.
     * 
     * @return the serviceVersion value.
     */
    public PersistentAgentsServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of PersistentAgentsClient client.
     * 
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public PersistentAgentsClientImpl(String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of PersistentAgentsClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public PersistentAgentsClientImpl(HttpPipeline httpPipeline, String endpoint,
        PersistentAgentsServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of PersistentAgentsClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public PersistentAgentsClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint,
        PersistentAgentsServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service
            = RestProxy.create(PersistentAgentsClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for PersistentAgentsClient to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "PersistentAgentsClient")
    public interface PersistentAgentsClientService {
        @Post("/threads/runs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> createThreadAndRun(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData createThreadAndRunRequest,
            RequestOptions requestOptions, Context context);

        @Post("/threads/runs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> createThreadAndRunSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData createThreadAndRunRequest,
            RequestOptions requestOptions, Context context);
    }

    /**
     * Creates a new agent thread and immediately starts a run using that new thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     assistant_id: String (Required)
     *     thread (Optional): {
     *         messages (Optional): [
     *              (Optional){
     *                 role: String(user/assistant) (Required)
     *                 content: BinaryData (Required)
     *                 attachments (Optional): [
     *                      (Optional){
     *                         file_id: String (Optional)
     *                         data_source (Optional): {
     *                             uri: String (Required)
     *                             type: String(uri_asset/id_asset) (Required)
     *                         }
     *                         tools (Required): [
     *                             BinaryData (Required)
     *                         ]
     *                     }
     *                 ]
     *                 metadata (Optional): {
     *                     String: String (Required)
     *                 }
     *             }
     *         ]
     *         tool_resources (Optional): {
     *             code_interpreter (Optional): {
     *                 file_ids (Optional): [
     *                     String (Optional)
     *                 ]
     *                 data_sources (Optional): [
     *                     (recursive schema, see above)
     *                 ]
     *             }
     *             file_search (Optional): {
     *                 vector_store_ids (Optional): [
     *                     String (Optional)
     *                 ]
     *                 vector_stores (Optional): [
     *                      (Optional){
     *                         name: String (Required)
     *                         configuration (Required): {
     *                             data_sources (Required): [
     *                                 (recursive schema, see above)
     *                             ]
     *                         }
     *                     }
     *                 ]
     *             }
     *             azure_ai_search (Optional): {
     *                 indexes (Optional): [
     *                      (Optional){
     *                         index_connection_id: String (Optional)
     *                         index_name: String (Optional)
     *                         query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                         top_k: Integer (Optional)
     *                         filter: String (Optional)
     *                         index_asset_id: String (Optional)
     *                     }
     *                 ]
     *             }
     *         }
     *         metadata (Optional): {
     *             String: String (Required)
     *         }
     *     }
     *     model: String (Optional)
     *     instructions: String (Optional)
     *     tools (Optional): [
     *          (Optional){
     *             type: String (Required)
     *         }
     *     ]
     *     tool_resources (Optional): (recursive schema, see tool_resources above)
     *     stream: Boolean (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Optional)
     *     max_completion_tokens: Integer (Optional)
     *     truncation_strategy (Optional): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Optional)
     *     response_format: BinaryData (Optional)
     *     parallel_tool_calls: Boolean (Optional)
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param createThreadAndRunRequest The createThreadAndRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createThreadAndRunWithResponseAsync(BinaryData createThreadAndRunRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.createThreadAndRun(this.getEndpoint(), this.getServiceVersion().getVersion(),
                contentType, accept, createThreadAndRunRequest, requestOptions, context));
    }

    /**
     * Creates a new agent thread and immediately starts a run using that new thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     assistant_id: String (Required)
     *     thread (Optional): {
     *         messages (Optional): [
     *              (Optional){
     *                 role: String(user/assistant) (Required)
     *                 content: BinaryData (Required)
     *                 attachments (Optional): [
     *                      (Optional){
     *                         file_id: String (Optional)
     *                         data_source (Optional): {
     *                             uri: String (Required)
     *                             type: String(uri_asset/id_asset) (Required)
     *                         }
     *                         tools (Required): [
     *                             BinaryData (Required)
     *                         ]
     *                     }
     *                 ]
     *                 metadata (Optional): {
     *                     String: String (Required)
     *                 }
     *             }
     *         ]
     *         tool_resources (Optional): {
     *             code_interpreter (Optional): {
     *                 file_ids (Optional): [
     *                     String (Optional)
     *                 ]
     *                 data_sources (Optional): [
     *                     (recursive schema, see above)
     *                 ]
     *             }
     *             file_search (Optional): {
     *                 vector_store_ids (Optional): [
     *                     String (Optional)
     *                 ]
     *                 vector_stores (Optional): [
     *                      (Optional){
     *                         name: String (Required)
     *                         configuration (Required): {
     *                             data_sources (Required): [
     *                                 (recursive schema, see above)
     *                             ]
     *                         }
     *                     }
     *                 ]
     *             }
     *             azure_ai_search (Optional): {
     *                 indexes (Optional): [
     *                      (Optional){
     *                         index_connection_id: String (Optional)
     *                         index_name: String (Optional)
     *                         query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                         top_k: Integer (Optional)
     *                         filter: String (Optional)
     *                         index_asset_id: String (Optional)
     *                     }
     *                 ]
     *             }
     *         }
     *         metadata (Optional): {
     *             String: String (Required)
     *         }
     *     }
     *     model: String (Optional)
     *     instructions: String (Optional)
     *     tools (Optional): [
     *          (Optional){
     *             type: String (Required)
     *         }
     *     ]
     *     tool_resources (Optional): (recursive schema, see tool_resources above)
     *     stream: Boolean (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Optional)
     *     max_completion_tokens: Integer (Optional)
     *     truncation_strategy (Optional): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Optional)
     *     response_format: BinaryData (Optional)
     *     parallel_tool_calls: Boolean (Optional)
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param createThreadAndRunRequest The createThreadAndRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createThreadAndRunWithResponse(BinaryData createThreadAndRunRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.createThreadAndRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), contentType,
            accept, createThreadAndRunRequest, requestOptions, Context.NONE);
    }

    /**
     * Gets an instance of PersistentAgentsAdministrationImpl class.
     * 
     * @return an instance of PersistentAgentsAdministrationImpl class.
     */
    public PersistentAgentsAdministrationImpl getPersistentAgentsAdministration() {
        return new PersistentAgentsAdministrationImpl(httpPipeline, serializerAdapter, endpoint, serviceVersion);
    }

    /**
     * Gets an instance of FilesImpl class.
     * 
     * @return an instance of FilesImpl class.
     */
    public FilesImpl getFiles() {
        return new FilesImpl(httpPipeline, serializerAdapter, endpoint, serviceVersion);
    }

    /**
     * Gets an instance of MessagesImpl class.
     * 
     * @return an instance of MessagesImpl class.
     */
    public MessagesImpl getMessages() {
        return new MessagesImpl(httpPipeline, serializerAdapter, endpoint, serviceVersion);
    }

    /**
     * Gets an instance of RunsImpl class.
     * 
     * @return an instance of RunsImpl class.
     */
    public RunsImpl getRuns() {
        return new RunsImpl(httpPipeline, serializerAdapter, endpoint, serviceVersion);
    }

    /**
     * Gets an instance of ThreadsImpl class.
     * 
     * @return an instance of ThreadsImpl class.
     */
    public ThreadsImpl getThreads() {
        return new ThreadsImpl(httpPipeline, serializerAdapter, endpoint, serviceVersion);
    }

    /**
     * Gets an instance of VectorStoresImpl class.
     * 
     * @return an instance of VectorStoresImpl class.
     */
    public VectorStoresImpl getVectorStores() {
        return new VectorStoresImpl(httpPipeline, serializerAdapter, endpoint, serviceVersion);
    }
}
