// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.agents.persistent.implementation;

import com.azure.ai.agents.persistent.PersistentAgentsServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the Runs type.
 */
public final class RunsImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final RunsService service;

    /**
     * Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     */
    private final String endpoint;

    /**
     * Gets Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Service version.
     */
    private final PersistentAgentsServiceVersion serviceVersion;

    /**
     * Gets Service version.
     * 
     * @return the serviceVersion value.
     */
    public PersistentAgentsServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of Runs client.
     * 
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public RunsImpl(String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of Runs client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public RunsImpl(HttpPipeline httpPipeline, String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of Runs client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public RunsImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint,
        PersistentAgentsServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = RestProxy.create(RunsService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for Runs to be used by the proxy service to perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "Runs")
    public interface RunsService {
        @Post("/threads/{threadId}/runs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> createRun(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData createRunRequest, RequestOptions requestOptions, Context context);

        @Post("/threads/{threadId}/runs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> createRunSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData createRunRequest, RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}/runs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listRuns(@HostParam("endpoint") String endpoint,
            @PathParam("threadId") String threadId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}/runs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listRunsSync(@HostParam("endpoint") String endpoint,
            @PathParam("threadId") String threadId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}/runs/{runId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getRun(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("runId") String runId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("/threads/{threadId}/runs/{runId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getRunSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("runId") String runId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Post("/threads/{threadId}/runs/{runId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> updateRun(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("runId") String runId, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData updateRunRequest,
            RequestOptions requestOptions, Context context);

        @Post("/threads/{threadId}/runs/{runId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> updateRunSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("runId") String runId, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData updateRunRequest,
            RequestOptions requestOptions, Context context);

        @Post("/threads/{threadId}/runs/{runId}/submit_tool_outputs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> submitToolOutputsToRun(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("runId") String runId, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData submitToolOutputsToRunRequest, RequestOptions requestOptions,
            Context context);

        @Post("/threads/{threadId}/runs/{runId}/submit_tool_outputs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> submitToolOutputsToRunSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("runId") String runId, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData submitToolOutputsToRunRequest, RequestOptions requestOptions,
            Context context);

        @Post("/threads/{threadId}/runs/{runId}/cancel")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> cancelRun(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("runId") String runId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Post("/threads/{threadId}/runs/{runId}/cancel")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> cancelRunSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("runId") String runId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("/threads/{threadId}/runs/{runId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listRunSteps(@HostParam("endpoint") String endpoint,
            @PathParam("threadId") String threadId, @PathParam("runId") String runId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}/runs/{runId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listRunStepsSync(@HostParam("endpoint") String endpoint,
            @PathParam("threadId") String threadId, @PathParam("runId") String runId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}/runs/{runId}/steps/{stepId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getRunStep(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("runId") String runId, @PathParam("stepId") String stepId, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}/runs/{runId}/steps/{stepId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getRunStepSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @PathParam("runId") String runId, @PathParam("stepId") String stepId, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);
    }

    /**
     * Creates a new run for an agent thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content`
     * to fetch the file search result content. In the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     assistant_id: String (Required)
     *     model: String (Optional)
     *     instructions: String (Optional)
     *     additional_instructions: String (Optional)
     *     additional_messages (Optional): [
     *          (Optional){
     *             role: String(user/assistant) (Required)
     *             content: BinaryData (Required)
     *             attachments (Optional): [
     *                  (Optional){
     *                     file_id: String (Optional)
     *                     data_source (Optional): {
     *                         uri: String (Required)
     *                         type: String(uri_asset/id_asset) (Required)
     *                     }
     *                     tools (Required): [
     *                         BinaryData (Required)
     *                     ]
     *                 }
     *             ]
     *             metadata (Optional): {
     *                 String: String (Required)
     *             }
     *         }
     *     ]
     *     tools (Optional): [
     *          (Optional){
     *             type: String (Required)
     *         }
     *     ]
     *     stream: Boolean (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Optional)
     *     max_completion_tokens: Integer (Optional)
     *     truncation_strategy (Optional): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Optional)
     *     response_format: BinaryData (Optional)
     *     parallel_tool_calls: Boolean (Optional)
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param createRunRequest The createRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createRunWithResponseAsync(String threadId, BinaryData createRunRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createRun(this.getEndpoint(), this.getServiceVersion().getVersion(),
                threadId, contentType, accept, createRunRequest, requestOptions, context));
    }

    /**
     * Creates a new run for an agent thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content`
     * to fetch the file search result content. In the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     assistant_id: String (Required)
     *     model: String (Optional)
     *     instructions: String (Optional)
     *     additional_instructions: String (Optional)
     *     additional_messages (Optional): [
     *          (Optional){
     *             role: String(user/assistant) (Required)
     *             content: BinaryData (Required)
     *             attachments (Optional): [
     *                  (Optional){
     *                     file_id: String (Optional)
     *                     data_source (Optional): {
     *                         uri: String (Required)
     *                         type: String(uri_asset/id_asset) (Required)
     *                     }
     *                     tools (Required): [
     *                         BinaryData (Required)
     *                     ]
     *                 }
     *             ]
     *             metadata (Optional): {
     *                 String: String (Required)
     *             }
     *         }
     *     ]
     *     tools (Optional): [
     *          (Optional){
     *             type: String (Required)
     *         }
     *     ]
     *     stream: Boolean (Optional)
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Optional)
     *     max_completion_tokens: Integer (Optional)
     *     truncation_strategy (Optional): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Optional)
     *     response_format: BinaryData (Optional)
     *     parallel_tool_calls: Boolean (Optional)
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param createRunRequest The createRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createRunWithResponse(String threadId, BinaryData createRunRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.createRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, contentType,
            accept, createRunRequest, requestOptions, Context.NONE);
    }

    /**
     * Gets a list of runs for a specified thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of runs for a specified thread along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listRunsSinglePageAsync(String threadId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listRuns(this.getEndpoint(), threadId,
                this.getServiceVersion().getVersion(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "data"), null, null));
    }

    /**
     * Gets a list of runs for a specified thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of runs for a specified thread as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listRunsAsync(String threadId, RequestOptions requestOptions) {
        return new PagedFlux<>(() -> listRunsSinglePageAsync(threadId, requestOptions));
    }

    /**
     * Gets a list of runs for a specified thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of runs for a specified thread along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listRunsSinglePage(String threadId, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listRunsSync(this.getEndpoint(), threadId,
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "data"), null, null);
    }

    /**
     * Gets a list of runs for a specified thread.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of runs for a specified thread as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listRuns(String threadId, RequestOptions requestOptions) {
        return new PagedIterable<>(() -> listRunsSinglePage(threadId, requestOptions));
    }

    /**
     * Gets an existing run from an existing thread.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return an existing run from an existing thread along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRunWithResponseAsync(String threadId, String runId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getRun(this.getEndpoint(), this.getServiceVersion().getVersion(),
            threadId, runId, accept, requestOptions, context));
    }

    /**
     * Gets an existing run from an existing thread.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return an existing run from an existing thread along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, accept,
            requestOptions, Context.NONE);
    }

    /**
     * Modifies an existing thread run.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param updateRunRequest The updateRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateRunWithResponseAsync(String threadId, String runId,
        BinaryData updateRunRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateRun(this.getEndpoint(), this.getServiceVersion().getVersion(),
                threadId, runId, contentType, accept, updateRunRequest, requestOptions, context));
    }

    /**
     * Modifies an existing thread run.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param updateRunRequest The updateRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateRunWithResponse(String threadId, String runId, BinaryData updateRunRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.updateRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId,
            contentType, accept, updateRunRequest, requestOptions, Context.NONE);
    }

    /**
     * Submits outputs from tools as requested by tool calls in a run.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     tool_outputs (Required): [
     *          (Required){
     *             tool_call_id: String (Optional)
     *             output: String (Optional)
     *         }
     *     ]
     *     stream: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param submitToolOutputsToRunRequest The submitToolOutputsToRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> submitToolOutputsToRunWithResponseAsync(String threadId, String runId,
        BinaryData submitToolOutputsToRunRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.submitToolOutputsToRun(this.getEndpoint(), this.getServiceVersion().getVersion(),
                threadId, runId, contentType, accept, submitToolOutputsToRunRequest, requestOptions, context));
    }

    /**
     * Submits outputs from tools as requested by tool calls in a run.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     tool_outputs (Required): [
     *          (Required){
     *             tool_call_id: String (Optional)
     *             output: String (Optional)
     *         }
     *     ]
     *     stream: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param submitToolOutputsToRunRequest The submitToolOutputsToRunRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> submitToolOutputsToRunWithResponse(String threadId, String runId,
        BinaryData submitToolOutputsToRunRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.submitToolOutputsToRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId,
            runId, contentType, accept, submitToolOutputsToRunRequest, requestOptions, Context.NONE);
    }

    /**
     * Cancels a run of an in‐progress thread.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> cancelRunWithResponseAsync(String threadId, String runId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.cancelRun(this.getEndpoint(),
            this.getServiceVersion().getVersion(), threadId, runId, accept, requestOptions, context));
    }

    /**
     * Cancels a run of an in‐progress thread.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     thread_id: String (Required)
     *     assistant_id: String (Required)
     *     status: String(queued/in_progress/requires_action/cancelling/cancelled/failed/completed/expired) (Required)
     *     required_action (Optional): {
     *         type: String (Required)
     *     }
     *     last_error (Required): {
     *         code: String (Required)
     *         message: String (Required)
     *     }
     *     model: String (Required)
     *     instructions: String (Required)
     *     tools (Required): [
     *          (Required){
     *             type: String (Required)
     *         }
     *     ]
     *     created_at: long (Required)
     *     expires_at: Long (Required)
     *     started_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     incomplete_details (Required): {
     *         reason: String(max_completion_tokens/max_prompt_tokens) (Required)
     *     }
     *     usage (Required): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     temperature: Double (Optional)
     *     top_p: Double (Optional)
     *     max_prompt_tokens: Integer (Required)
     *     max_completion_tokens: Integer (Required)
     *     truncation_strategy (Required): {
     *         type: String(auto/last_messages) (Required)
     *         last_messages: Integer (Optional)
     *     }
     *     tool_choice: BinaryData (Required)
     *     response_format: BinaryData (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     parallel_tool_calls: boolean (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return data representing a single evaluation run of an agent thread along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> cancelRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.cancelRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, accept,
            requestOptions, Context.NONE);
    }

    /**
     * Gets a list of run steps from a thread run.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content` to fetch the
     * file search result content. In the form of "," separated string.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     type: String(message_creation/tool_calls) (Required)
     *     assistant_id: String (Required)
     *     thread_id: String (Required)
     *     run_id: String (Required)
     *     status: String(in_progress/cancelled/failed/completed/expired) (Required)
     *     step_details (Required): {
     *         type: String(message_creation/tool_calls) (Required)
     *     }
     *     last_error (Required): {
     *         code: String(server_error/rate_limit_exceeded) (Required)
     *         message: String (Required)
     *     }
     *     created_at: long (Required)
     *     expired_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     usage (Optional): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of run steps from a thread run along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listRunStepsSinglePageAsync(String threadId, String runId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listRunSteps(this.getEndpoint(), threadId, runId,
                this.getServiceVersion().getVersion(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "data"), null, null));
    }

    /**
     * Gets a list of run steps from a thread run.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content` to fetch the
     * file search result content. In the form of "," separated string.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     type: String(message_creation/tool_calls) (Required)
     *     assistant_id: String (Required)
     *     thread_id: String (Required)
     *     run_id: String (Required)
     *     status: String(in_progress/cancelled/failed/completed/expired) (Required)
     *     step_details (Required): {
     *         type: String(message_creation/tool_calls) (Required)
     *     }
     *     last_error (Required): {
     *         code: String(server_error/rate_limit_exceeded) (Required)
     *         message: String (Required)
     *     }
     *     created_at: long (Required)
     *     expired_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     usage (Optional): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of run steps from a thread run as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listRunStepsAsync(String threadId, String runId, RequestOptions requestOptions) {
        return new PagedFlux<>(() -> listRunStepsSinglePageAsync(threadId, runId, requestOptions));
    }

    /**
     * Gets a list of run steps from a thread run.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content` to fetch the
     * file search result content. In the form of "," separated string.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     type: String(message_creation/tool_calls) (Required)
     *     assistant_id: String (Required)
     *     thread_id: String (Required)
     *     run_id: String (Required)
     *     status: String(in_progress/cancelled/failed/completed/expired) (Required)
     *     step_details (Required): {
     *         type: String(message_creation/tool_calls) (Required)
     *     }
     *     last_error (Required): {
     *         code: String(server_error/rate_limit_exceeded) (Required)
     *         message: String (Required)
     *     }
     *     created_at: long (Required)
     *     expired_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     usage (Optional): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of run steps from a thread run along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listRunStepsSinglePage(String threadId, String runId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listRunStepsSync(this.getEndpoint(), threadId, runId,
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "data"), null, null);
    }

    /**
     * Gets a list of run steps from a thread run.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content` to fetch the
     * file search result content. In the form of "," separated string.</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     type: String(message_creation/tool_calls) (Required)
     *     assistant_id: String (Required)
     *     thread_id: String (Required)
     *     run_id: String (Required)
     *     status: String(in_progress/cancelled/failed/completed/expired) (Required)
     *     step_details (Required): {
     *         type: String(message_creation/tool_calls) (Required)
     *     }
     *     last_error (Required): {
     *         code: String(server_error/rate_limit_exceeded) (Required)
     *         message: String (Required)
     *     }
     *     created_at: long (Required)
     *     expired_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     usage (Optional): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of run steps from a thread run as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listRunSteps(String threadId, String runId, RequestOptions requestOptions) {
        return new PagedIterable<>(() -> listRunStepsSinglePage(threadId, runId, requestOptions));
    }

    /**
     * Retrieves a single run step from a thread run.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content` to fetch the
     * file search result content. In the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     type: String(message_creation/tool_calls) (Required)
     *     assistant_id: String (Required)
     *     thread_id: String (Required)
     *     run_id: String (Required)
     *     status: String(in_progress/cancelled/failed/completed/expired) (Required)
     *     step_details (Required): {
     *         type: String(message_creation/tool_calls) (Required)
     *     }
     *     last_error (Required): {
     *         code: String(server_error/rate_limit_exceeded) (Required)
     *         message: String (Required)
     *     }
     *     created_at: long (Required)
     *     expired_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     usage (Optional): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param stepId Identifier of the run step.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed information about a single step of an agent thread run along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRunStepWithResponseAsync(String threadId, String runId, String stepId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getRunStep(this.getEndpoint(),
            this.getServiceVersion().getVersion(), threadId, runId, stepId, accept, requestOptions, context));
    }

    /**
     * Retrieves a single run step from a thread run.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>include[]</td><td>List&lt;String&gt;</td><td>No</td><td>A list of additional fields to include in the
     * response.
     * Currently the only supported value is `step_details.tool_calls[*].file_search.results[*].content` to fetch the
     * file search result content. In the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     type: String(message_creation/tool_calls) (Required)
     *     assistant_id: String (Required)
     *     thread_id: String (Required)
     *     run_id: String (Required)
     *     status: String(in_progress/cancelled/failed/completed/expired) (Required)
     *     step_details (Required): {
     *         type: String(message_creation/tool_calls) (Required)
     *     }
     *     last_error (Required): {
     *         code: String(server_error/rate_limit_exceeded) (Required)
     *         message: String (Required)
     *     }
     *     created_at: long (Required)
     *     expired_at: Long (Required)
     *     completed_at: Long (Required)
     *     cancelled_at: Long (Required)
     *     failed_at: Long (Required)
     *     usage (Optional): {
     *         completion_tokens: long (Required)
     *         prompt_tokens: long (Required)
     *         total_tokens: long (Required)
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param runId Identifier of the run.
     * @param stepId Identifier of the run step.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed information about a single step of an agent thread run along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getRunStepWithResponse(String threadId, String runId, String stepId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getRunStepSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId,
            stepId, accept, requestOptions, Context.NONE);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            List<?> values = (List<?>) obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        } catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            return (String) obj.get(path);
        } catch (RuntimeException e) {
            return null;
        }
    }
}
