// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.agents.persistent.implementation;

import com.azure.ai.agents.persistent.PersistentAgentsServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the Threads type.
 */
public final class ThreadsImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ThreadsService service;

    /**
     * Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     */
    private final String endpoint;

    /**
     * Gets Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Service version.
     */
    private final PersistentAgentsServiceVersion serviceVersion;

    /**
     * Gets Service version.
     * 
     * @return the serviceVersion value.
     */
    public PersistentAgentsServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of Threads client.
     * 
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public ThreadsImpl(String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of Threads client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public ThreadsImpl(HttpPipeline httpPipeline, String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of Threads client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public ThreadsImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint,
        PersistentAgentsServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = RestProxy.create(ThreadsService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for Threads to be used by the proxy service to perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "Threads")
    public interface ThreadsService {
        @Post("/threads")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> createThread(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData createThreadRequest,
            RequestOptions requestOptions, Context context);

        @Post("/threads")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> createThreadSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData createThreadRequest,
            RequestOptions requestOptions, Context context);

        @Get("/threads")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listThreads(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/threads")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listThreadsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getThread(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/threads/{threadId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getThreadSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/threads/{threadId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> updateThread(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData updateThreadRequest, RequestOptions requestOptions,
            Context context);

        @Post("/threads/{threadId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> updateThreadSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData updateThreadRequest, RequestOptions requestOptions,
            Context context);

        @Delete("/threads/{threadId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> deleteThreadInternal(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/threads/{threadId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> deleteThreadInternalSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("threadId") String threadId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);
    }

    /**
     * Creates a new thread. Threads contain messages and can be run by agents.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     messages (Optional): [
     *          (Optional){
     *             role: String(user/assistant) (Required)
     *             content: BinaryData (Required)
     *             attachments (Optional): [
     *                  (Optional){
     *                     file_id: String (Optional)
     *                     data_source (Optional): {
     *                         uri: String (Required)
     *                         type: String(uri_asset/id_asset) (Required)
     *                     }
     *                     tools (Required): [
     *                         BinaryData (Required)
     *                     ]
     *                 }
     *             ]
     *             metadata (Optional): {
     *                 String: String (Required)
     *             }
     *         }
     *     ]
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                 (recursive schema, see above)
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     tool_resources (Required): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param createThreadRequest The createThreadRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return information about a single thread associated with an agent along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createThreadWithResponseAsync(BinaryData createThreadRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.createThread(this.getEndpoint(),
            this.getServiceVersion().getVersion(), contentType, accept, createThreadRequest, requestOptions, context));
    }

    /**
     * Creates a new thread. Threads contain messages and can be run by agents.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     messages (Optional): [
     *          (Optional){
     *             role: String(user/assistant) (Required)
     *             content: BinaryData (Required)
     *             attachments (Optional): [
     *                  (Optional){
     *                     file_id: String (Optional)
     *                     data_source (Optional): {
     *                         uri: String (Required)
     *                         type: String(uri_asset/id_asset) (Required)
     *                     }
     *                     tools (Required): [
     *                         BinaryData (Required)
     *                     ]
     *                 }
     *             ]
     *             metadata (Optional): {
     *                 String: String (Required)
     *             }
     *         }
     *     ]
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                 (recursive schema, see above)
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     tool_resources (Required): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param createThreadRequest The createThreadRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return information about a single thread associated with an agent along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createThreadWithResponse(BinaryData createThreadRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.createThreadSync(this.getEndpoint(), this.getServiceVersion().getVersion(), contentType, accept,
            createThreadRequest, requestOptions, Context.NONE);
    }

    /**
     * Gets a list of threads that were previously created.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     tool_resources (Required): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of threads that were previously created along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listThreadsSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listThreads(this.getEndpoint(), this.getServiceVersion().getVersion(),
                accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "data"), null, null));
    }

    /**
     * Gets a list of threads that were previously created.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     tool_resources (Required): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of threads that were previously created as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listThreadsAsync(RequestOptions requestOptions) {
        return new PagedFlux<>(() -> listThreadsSinglePageAsync(requestOptions));
    }

    /**
     * Gets a list of threads that were previously created.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     tool_resources (Required): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of threads that were previously created along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listThreadsSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listThreadsSync(this.getEndpoint(), this.getServiceVersion().getVersion(),
            accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "data"), null, null);
    }

    /**
     * Gets a list of threads that were previously created.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     tool_resources (Required): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a list of threads that were previously created as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listThreads(RequestOptions requestOptions) {
        return new PagedIterable<>(() -> listThreadsSinglePage(requestOptions));
    }

    /**
     * Gets information about an existing thread.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     tool_resources (Required): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return information about an existing thread along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getThreadWithResponseAsync(String threadId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getThread(this.getEndpoint(),
            this.getServiceVersion().getVersion(), threadId, accept, requestOptions, context));
    }

    /**
     * Gets information about an existing thread.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     tool_resources (Required): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return information about an existing thread along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getThreadWithResponse(String threadId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getThreadSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, accept,
            requestOptions, Context.NONE);
    }

    /**
     * Modifies an existing thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     tool_resources (Required): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId The ID of the thread to modify.
     * @param updateThreadRequest The updateThreadRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return information about a single thread associated with an agent along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateThreadWithResponseAsync(String threadId, BinaryData updateThreadRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateThread(this.getEndpoint(), this.getServiceVersion().getVersion(),
                threadId, contentType, accept, updateThreadRequest, requestOptions, context));
    }

    /**
     * Modifies an existing thread.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     tool_resources (Optional): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     tool_resources (Required): {
     *         code_interpreter (Optional): {
     *             file_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             data_sources (Optional): [
     *                  (Optional){
     *                     uri: String (Required)
     *                     type: String(uri_asset/id_asset) (Required)
     *                 }
     *             ]
     *         }
     *         file_search (Optional): {
     *             vector_store_ids (Optional): [
     *                 String (Optional)
     *             ]
     *             vector_stores (Optional): [
     *                  (Optional){
     *                     name: String (Required)
     *                     configuration (Required): {
     *                         data_sources (Required): [
     *                             (recursive schema, see above)
     *                         ]
     *                     }
     *                 }
     *             ]
     *         }
     *         azure_ai_search (Optional): {
     *             indexes (Optional): [
     *                  (Optional){
     *                     index_connection_id: String (Optional)
     *                     index_name: String (Optional)
     *                     query_type: String(simple/semantic/vector/vector_simple_hybrid/vector_semantic_hybrid) (Optional)
     *                     top_k: Integer (Optional)
     *                     filter: String (Optional)
     *                     index_asset_id: String (Optional)
     *                 }
     *             ]
     *         }
     *     }
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param threadId The ID of the thread to modify.
     * @param updateThreadRequest The updateThreadRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return information about a single thread associated with an agent along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> updateThreadWithResponse(String threadId, BinaryData updateThreadRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.updateThreadSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId,
            contentType, accept, updateThreadRequest, requestOptions, Context.NONE);
    }

    /**
     * Deletes an existing thread.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     deleted: boolean (Required)
     *     object: String (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a thread deletion operation along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteThreadInternalWithResponseAsync(String threadId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteThreadInternal(this.getEndpoint(),
            this.getServiceVersion().getVersion(), threadId, accept, requestOptions, context));
    }

    /**
     * Deletes an existing thread.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     deleted: boolean (Required)
     *     object: String (Required)
     * }
     * }
     * </pre>
     * 
     * @param threadId Identifier of the thread.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the status of a thread deletion operation along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> deleteThreadInternalWithResponse(String threadId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteThreadInternalSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId,
            accept, requestOptions, Context.NONE);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            List<?> values = (List<?>) obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        } catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            return (String) obj.get(path);
        } catch (RuntimeException e) {
            return null;
        }
    }
}
