// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.agents.persistent.implementation;

import com.azure.ai.agents.persistent.PersistentAgentsServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the VectorStores type.
 */
public final class VectorStoresImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final VectorStoresService service;

    /**
     * Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     */
    private final String endpoint;

    /**
     * Gets Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Service version.
     */
    private final PersistentAgentsServiceVersion serviceVersion;

    /**
     * Gets Service version.
     * 
     * @return the serviceVersion value.
     */
    public PersistentAgentsServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of VectorStores client.
     * 
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public VectorStoresImpl(String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of VectorStores client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public VectorStoresImpl(HttpPipeline httpPipeline, String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of VectorStores client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint Project endpoint in the form of:
     * https://&lt;aiservices-id&gt;.services.ai.azure.com/api/projects/&lt;project-name&gt;.
     * @param serviceVersion Service version.
     */
    public VectorStoresImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint,
        PersistentAgentsServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = RestProxy.create(VectorStoresService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for VectorStores to be used by the proxy service to perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "VectorStores")
    public interface VectorStoresService {
        @Post("/vector_stores")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> createVectorStore(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData createVectorStoreRequest,
            RequestOptions requestOptions, Context context);

        @Post("/vector_stores")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> createVectorStoreSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData createVectorStoreRequest,
            RequestOptions requestOptions, Context context);

        @Get("/vector_stores/{vectorStoreId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getVectorStore(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/vector_stores/{vectorStoreId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getVectorStoreSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/vector_stores/{vectorStoreId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> modifyVectorStore(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData modifyVectorStoreRequest, RequestOptions requestOptions,
            Context context);

        @Post("/vector_stores/{vectorStoreId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> modifyVectorStoreSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData modifyVectorStoreRequest, RequestOptions requestOptions,
            Context context);

        @Get("/vector_stores")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listVectorStores(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/vector_stores")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listVectorStoresSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Delete("/vector_stores/{vectorStoreId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> deleteVectorStoreInternal(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/vector_stores/{vectorStoreId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> deleteVectorStoreInternalSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/vector_stores/{vectorStoreId}/files")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> createVectorStoreFile(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData createVectorStoreFileRequest, RequestOptions requestOptions,
            Context context);

        @Post("/vector_stores/{vectorStoreId}/files")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> createVectorStoreFileSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData createVectorStoreFileRequest, RequestOptions requestOptions,
            Context context);

        @Get("/vector_stores/{vectorStoreId}/files/{fileId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getVectorStoreFile(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @PathParam("fileId") String fileId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("/vector_stores/{vectorStoreId}/files/{fileId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getVectorStoreFileSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @PathParam("fileId") String fileId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Delete("/vector_stores/{vectorStoreId}/files/{fileId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> deleteVectorStoreFileInternal(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @PathParam("fileId") String fileId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Delete("/vector_stores/{vectorStoreId}/files/{fileId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> deleteVectorStoreFileInternalSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @PathParam("fileId") String fileId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("/vector_stores/{vectorStoreId}/files")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listVectorStoreFiles(@HostParam("endpoint") String endpoint,
            @PathParam("vectorStoreId") String vectorStoreId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/vector_stores/{vectorStoreId}/files")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listVectorStoreFilesSync(@HostParam("endpoint") String endpoint,
            @PathParam("vectorStoreId") String vectorStoreId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Post("/vector_stores/{vectorStoreId}/file_batches")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> createVectorStoreFileBatch(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData createVectorStoreFileBatchRequest, RequestOptions requestOptions,
            Context context);

        @Post("/vector_stores/{vectorStoreId}/file_batches")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> createVectorStoreFileBatchSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData createVectorStoreFileBatchRequest, RequestOptions requestOptions,
            Context context);

        @Get("/vector_stores/{vectorStoreId}/file_batches/{batchId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getVectorStoreFileBatch(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @PathParam("batchId") String batchId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("/vector_stores/{vectorStoreId}/file_batches/{batchId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getVectorStoreFileBatchSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @PathParam("batchId") String batchId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Post("/vector_stores/{vectorStoreId}/file_batches/{batchId}/cancel")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> cancelVectorStoreFileBatch(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @PathParam("batchId") String batchId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Post("/vector_stores/{vectorStoreId}/file_batches/{batchId}/cancel")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> cancelVectorStoreFileBatchSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("vectorStoreId") String vectorStoreId,
            @PathParam("batchId") String batchId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("/vector_stores/{vectorStoreId}/file_batches/{batchId}/files")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listVectorStoreFileBatchFiles(@HostParam("endpoint") String endpoint,
            @PathParam("vectorStoreId") String vectorStoreId, @PathParam("batchId") String batchId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/vector_stores/{vectorStoreId}/file_batches/{batchId}/files")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listVectorStoreFileBatchFilesSync(@HostParam("endpoint") String endpoint,
            @PathParam("vectorStoreId") String vectorStoreId, @PathParam("batchId") String batchId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);
    }

    /**
     * Creates a vector store.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     file_ids (Optional): [
     *         String (Optional)
     *     ]
     *     name: String (Optional)
     *     configuration (Optional): {
     *         data_sources (Required): [
     *              (Required){
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *         ]
     *     }
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     chunking_strategy (Optional): {
     *         type: String(auto/static) (Required)
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     name: String (Required)
     *     usage_bytes: int (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     *     status: String(expired/in_progress/completed) (Required)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     expires_at: Long (Optional)
     *     last_active_at: Long (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param createVectorStoreRequest The createVectorStoreRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a vector store is a collection of processed files can be used by the `file_search` tool along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createVectorStoreWithResponseAsync(BinaryData createVectorStoreRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createVectorStore(this.getEndpoint(), this.getServiceVersion().getVersion(),
                contentType, accept, createVectorStoreRequest, requestOptions, context));
    }

    /**
     * Creates a vector store.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     file_ids (Optional): [
     *         String (Optional)
     *     ]
     *     name: String (Optional)
     *     configuration (Optional): {
     *         data_sources (Required): [
     *              (Required){
     *                 uri: String (Required)
     *                 type: String(uri_asset/id_asset) (Required)
     *             }
     *         ]
     *     }
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     chunking_strategy (Optional): {
     *         type: String(auto/static) (Required)
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     name: String (Required)
     *     usage_bytes: int (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     *     status: String(expired/in_progress/completed) (Required)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     expires_at: Long (Optional)
     *     last_active_at: Long (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param createVectorStoreRequest The createVectorStoreRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a vector store is a collection of processed files can be used by the `file_search` tool along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createVectorStoreWithResponse(BinaryData createVectorStoreRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.createVectorStoreSync(this.getEndpoint(), this.getServiceVersion().getVersion(), contentType,
            accept, createVectorStoreRequest, requestOptions, Context.NONE);
    }

    /**
     * Returns the vector store object matching the specified ID.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     name: String (Required)
     *     usage_bytes: int (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     *     status: String(expired/in_progress/completed) (Required)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     expires_at: Long (Optional)
     *     last_active_at: Long (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a vector store is a collection of processed files can be used by the `file_search` tool along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getVectorStoreWithResponseAsync(String vectorStoreId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getVectorStore(this.getEndpoint(),
            this.getServiceVersion().getVersion(), vectorStoreId, accept, requestOptions, context));
    }

    /**
     * Returns the vector store object matching the specified ID.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     name: String (Required)
     *     usage_bytes: int (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     *     status: String(expired/in_progress/completed) (Required)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     expires_at: Long (Optional)
     *     last_active_at: Long (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a vector store is a collection of processed files can be used by the `file_search` tool along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getVectorStoreWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getVectorStoreSync(this.getEndpoint(), this.getServiceVersion().getVersion(), vectorStoreId,
            accept, requestOptions, Context.NONE);
    }

    /**
     * Modifies an existing vector store.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     name: String (Optional)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     name: String (Required)
     *     usage_bytes: int (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     *     status: String(expired/in_progress/completed) (Required)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     expires_at: Long (Optional)
     *     last_active_at: Long (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param modifyVectorStoreRequest The modifyVectorStoreRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a vector store is a collection of processed files can be used by the `file_search` tool along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> modifyVectorStoreWithResponseAsync(String vectorStoreId,
        BinaryData modifyVectorStoreRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.modifyVectorStore(this.getEndpoint(), this.getServiceVersion().getVersion(),
                vectorStoreId, contentType, accept, modifyVectorStoreRequest, requestOptions, context));
    }

    /**
     * Modifies an existing vector store.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     name: String (Optional)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     metadata (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     name: String (Required)
     *     usage_bytes: int (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     *     status: String(expired/in_progress/completed) (Required)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     expires_at: Long (Optional)
     *     last_active_at: Long (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param modifyVectorStoreRequest The modifyVectorStoreRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a vector store is a collection of processed files can be used by the `file_search` tool along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> modifyVectorStoreWithResponse(String vectorStoreId, BinaryData modifyVectorStoreRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.modifyVectorStoreSync(this.getEndpoint(), this.getServiceVersion().getVersion(), vectorStoreId,
            contentType, accept, modifyVectorStoreRequest, requestOptions, Context.NONE);
    }

    /**
     * Returns a list of vector stores.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     name: String (Required)
     *     usage_bytes: int (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     *     status: String(expired/in_progress/completed) (Required)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     expires_at: Long (Optional)
     *     last_active_at: Long (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listVectorStoresSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listVectorStores(this.getEndpoint(), this.getServiceVersion().getVersion(),
                accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "data"), null, null));
    }

    /**
     * Returns a list of vector stores.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     name: String (Required)
     *     usage_bytes: int (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     *     status: String(expired/in_progress/completed) (Required)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     expires_at: Long (Optional)
     *     last_active_at: Long (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listVectorStoresAsync(RequestOptions requestOptions) {
        return new PagedFlux<>(() -> listVectorStoresSinglePageAsync(requestOptions));
    }

    /**
     * Returns a list of vector stores.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     name: String (Required)
     *     usage_bytes: int (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     *     status: String(expired/in_progress/completed) (Required)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     expires_at: Long (Optional)
     *     last_active_at: Long (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listVectorStoresSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listVectorStoresSync(this.getEndpoint(),
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "data"), null, null);
    }

    /**
     * Returns a list of vector stores.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     name: String (Required)
     *     usage_bytes: int (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     *     status: String(expired/in_progress/completed) (Required)
     *     expires_after (Optional): {
     *         anchor: String(last_active_at) (Required)
     *         days: int (Required)
     *     }
     *     expires_at: Long (Optional)
     *     last_active_at: Long (Required)
     *     metadata (Required): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listVectorStores(RequestOptions requestOptions) {
        return new PagedIterable<>(() -> listVectorStoresSinglePage(requestOptions));
    }

    /**
     * Deletes the vector store object matching the specified ID.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     deleted: boolean (Required)
     *     object: String (Required)
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return response object for deleting a vector store along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteVectorStoreInternalWithResponseAsync(String vectorStoreId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteVectorStoreInternal(this.getEndpoint(),
            this.getServiceVersion().getVersion(), vectorStoreId, accept, requestOptions, context));
    }

    /**
     * Deletes the vector store object matching the specified ID.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     deleted: boolean (Required)
     *     object: String (Required)
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return response object for deleting a vector store along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> deleteVectorStoreInternalWithResponse(String vectorStoreId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteVectorStoreInternalSync(this.getEndpoint(), this.getServiceVersion().getVersion(),
            vectorStoreId, accept, requestOptions, Context.NONE);
    }

    /**
     * Create a vector store file by attaching a file to a vector store.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     file_id: String (Optional)
     *     data_source (Optional): {
     *         uri: String (Required)
     *         type: String(uri_asset/id_asset) (Required)
     *     }
     *     chunking_strategy (Optional): {
     *         type: String(auto/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param createVectorStoreFileRequest The createVectorStoreFileRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return description of a file attached to a vector store along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createVectorStoreFileWithResponseAsync(String vectorStoreId,
        BinaryData createVectorStoreFileRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.createVectorStoreFile(this.getEndpoint(), this.getServiceVersion().getVersion(),
                vectorStoreId, contentType, accept, createVectorStoreFileRequest, requestOptions, context));
    }

    /**
     * Create a vector store file by attaching a file to a vector store.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     file_id: String (Optional)
     *     data_source (Optional): {
     *         uri: String (Required)
     *         type: String(uri_asset/id_asset) (Required)
     *     }
     *     chunking_strategy (Optional): {
     *         type: String(auto/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param createVectorStoreFileRequest The createVectorStoreFileRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return description of a file attached to a vector store along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createVectorStoreFileWithResponse(String vectorStoreId,
        BinaryData createVectorStoreFileRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.createVectorStoreFileSync(this.getEndpoint(), this.getServiceVersion().getVersion(),
            vectorStoreId, contentType, accept, createVectorStoreFileRequest, requestOptions, Context.NONE);
    }

    /**
     * Retrieves a vector store file.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param fileId Identifier of the file.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return description of a file attached to a vector store along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getVectorStoreFileWithResponseAsync(String vectorStoreId, String fileId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getVectorStoreFile(this.getEndpoint(),
            this.getServiceVersion().getVersion(), vectorStoreId, fileId, accept, requestOptions, context));
    }

    /**
     * Retrieves a vector store file.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param fileId Identifier of the file.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return description of a file attached to a vector store along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getVectorStoreFileWithResponse(String vectorStoreId, String fileId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getVectorStoreFileSync(this.getEndpoint(), this.getServiceVersion().getVersion(), vectorStoreId,
            fileId, accept, requestOptions, Context.NONE);
    }

    /**
     * Deletes a vector store file. This removes the file‐to‐store link (does not delete the file itself).
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     deleted: boolean (Required)
     *     object: String (Required)
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param fileId Identifier of the file.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return response object for deleting a vector store file relationship along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> deleteVectorStoreFileInternalWithResponseAsync(String vectorStoreId,
        String fileId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteVectorStoreFileInternal(this.getEndpoint(),
            this.getServiceVersion().getVersion(), vectorStoreId, fileId, accept, requestOptions, context));
    }

    /**
     * Deletes a vector store file. This removes the file‐to‐store link (does not delete the file itself).
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     deleted: boolean (Required)
     *     object: String (Required)
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param fileId Identifier of the file.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return response object for deleting a vector store file relationship along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> deleteVectorStoreFileInternalWithResponse(String vectorStoreId, String fileId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteVectorStoreFileInternalSync(this.getEndpoint(), this.getServiceVersion().getVersion(),
            vectorStoreId, fileId, accept, requestOptions, Context.NONE);
    }

    /**
     * Returns a list of vector store files.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>filter</td><td>String</td><td>No</td><td>Filter by file status. Allowed values: "in_progress",
     * "completed", "failed", "cancelled".</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listVectorStoreFilesSinglePageAsync(String vectorStoreId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listVectorStoreFiles(this.getEndpoint(), vectorStoreId,
                this.getServiceVersion().getVersion(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "data"), null, null));
    }

    /**
     * Returns a list of vector store files.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>filter</td><td>String</td><td>No</td><td>Filter by file status. Allowed values: "in_progress",
     * "completed", "failed", "cancelled".</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listVectorStoreFilesAsync(String vectorStoreId, RequestOptions requestOptions) {
        return new PagedFlux<>(() -> listVectorStoreFilesSinglePageAsync(vectorStoreId, requestOptions));
    }

    /**
     * Returns a list of vector store files.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>filter</td><td>String</td><td>No</td><td>Filter by file status. Allowed values: "in_progress",
     * "completed", "failed", "cancelled".</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listVectorStoreFilesSinglePage(String vectorStoreId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listVectorStoreFilesSync(this.getEndpoint(), vectorStoreId,
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "data"), null, null);
    }

    /**
     * Returns a list of vector store files.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>filter</td><td>String</td><td>No</td><td>Filter by file status. Allowed values: "in_progress",
     * "completed", "failed", "cancelled".</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listVectorStoreFiles(String vectorStoreId, RequestOptions requestOptions) {
        return new PagedIterable<>(() -> listVectorStoreFilesSinglePage(vectorStoreId, requestOptions));
    }

    /**
     * Create a vector store file batch.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     file_ids (Optional): [
     *         String (Optional)
     *     ]
     *     data_sources (Optional): [
     *          (Optional){
     *             uri: String (Required)
     *             type: String(uri_asset/id_asset) (Required)
     *         }
     *     ]
     *     chunking_strategy (Optional): {
     *         type: String(auto/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/cancelled/failed) (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param createVectorStoreFileBatchRequest The createVectorStoreFileBatchRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a batch of files attached to a vector store along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createVectorStoreFileBatchWithResponseAsync(String vectorStoreId,
        BinaryData createVectorStoreFileBatchRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.createVectorStoreFileBatch(this.getEndpoint(), this.getServiceVersion().getVersion(),
                vectorStoreId, contentType, accept, createVectorStoreFileBatchRequest, requestOptions, context));
    }

    /**
     * Create a vector store file batch.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     file_ids (Optional): [
     *         String (Optional)
     *     ]
     *     data_sources (Optional): [
     *          (Optional){
     *             uri: String (Required)
     *             type: String(uri_asset/id_asset) (Required)
     *         }
     *     ]
     *     chunking_strategy (Optional): {
     *         type: String(auto/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/cancelled/failed) (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param createVectorStoreFileBatchRequest The createVectorStoreFileBatchRequest parameter.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a batch of files attached to a vector store along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> createVectorStoreFileBatchWithResponse(String vectorStoreId,
        BinaryData createVectorStoreFileBatchRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.createVectorStoreFileBatchSync(this.getEndpoint(), this.getServiceVersion().getVersion(),
            vectorStoreId, contentType, accept, createVectorStoreFileBatchRequest, requestOptions, Context.NONE);
    }

    /**
     * Retrieve a vector store file batch.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/cancelled/failed) (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param batchId Identifier of the file batch.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a batch of files attached to a vector store along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getVectorStoreFileBatchWithResponseAsync(String vectorStoreId, String batchId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getVectorStoreFileBatch(this.getEndpoint(),
            this.getServiceVersion().getVersion(), vectorStoreId, batchId, accept, requestOptions, context));
    }

    /**
     * Retrieve a vector store file batch.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/cancelled/failed) (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param batchId Identifier of the file batch.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a batch of files attached to a vector store along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getVectorStoreFileBatchWithResponse(String vectorStoreId, String batchId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getVectorStoreFileBatchSync(this.getEndpoint(), this.getServiceVersion().getVersion(),
            vectorStoreId, batchId, accept, requestOptions, Context.NONE);
    }

    /**
     * Cancel a vector store file batch. This attempts to cancel the processing of files in this batch as soon as
     * possible.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/cancelled/failed) (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param batchId Identifier of the file batch.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a batch of files attached to a vector store along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> cancelVectorStoreFileBatchWithResponseAsync(String vectorStoreId, String batchId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.cancelVectorStoreFileBatch(this.getEndpoint(),
            this.getServiceVersion().getVersion(), vectorStoreId, batchId, accept, requestOptions, context));
    }

    /**
     * Cancel a vector store file batch. This attempts to cancel the processing of files in this batch as soon as
     * possible.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/cancelled/failed) (Required)
     *     file_counts (Required): {
     *         in_progress: int (Required)
     *         completed: int (Required)
     *         failed: int (Required)
     *         cancelled: int (Required)
     *         total: int (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param batchId Identifier of the file batch.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return a batch of files attached to a vector store along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> cancelVectorStoreFileBatchWithResponse(String vectorStoreId, String batchId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.cancelVectorStoreFileBatchSync(this.getEndpoint(), this.getServiceVersion().getVersion(),
            vectorStoreId, batchId, accept, requestOptions, Context.NONE);
    }

    /**
     * Returns a list of vector store files in a batch.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>filter</td><td>String</td><td>No</td><td>Filter by file status. Allowed values: "in_progress",
     * "completed", "failed", "cancelled".</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param batchId Identifier of the file batch.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listVectorStoreFileBatchFilesSinglePageAsync(String vectorStoreId,
        String batchId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listVectorStoreFileBatchFiles(this.getEndpoint(), vectorStoreId, batchId,
                this.getServiceVersion().getVersion(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "data"), null, null));
    }

    /**
     * Returns a list of vector store files in a batch.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>filter</td><td>String</td><td>No</td><td>Filter by file status. Allowed values: "in_progress",
     * "completed", "failed", "cancelled".</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param batchId Identifier of the file batch.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listVectorStoreFileBatchFilesAsync(String vectorStoreId, String batchId,
        RequestOptions requestOptions) {
        return new PagedFlux<>(
            () -> listVectorStoreFileBatchFilesSinglePageAsync(vectorStoreId, batchId, requestOptions));
    }

    /**
     * Returns a list of vector store files in a batch.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>filter</td><td>String</td><td>No</td><td>Filter by file status. Allowed values: "in_progress",
     * "completed", "failed", "cancelled".</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param batchId Identifier of the file batch.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listVectorStoreFileBatchFilesSinglePage(String vectorStoreId, String batchId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listVectorStoreFileBatchFilesSync(this.getEndpoint(), vectorStoreId, batchId,
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "data"), null, null);
    }

    /**
     * Returns a list of vector store files in a batch.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>filter</td><td>String</td><td>No</td><td>Filter by file status. Allowed values: "in_progress",
     * "completed", "failed", "cancelled".</td></tr>
     * <tr><td>limit</td><td>Integer</td><td>No</td><td>A limit on the number of objects to be returned. Limit can range
     * between 1 and 100, and the default is 20.</td></tr>
     * <tr><td>order</td><td>String</td><td>No</td><td>Sort order by the created_at timestamp of the objects. asc for
     * ascending order and desc for descending order. Allowed values: "asc", "desc".</td></tr>
     * <tr><td>after</td><td>String</td><td>No</td><td>A cursor for use in pagination. after is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.</td></tr>
     * <tr><td>before</td><td>String</td><td>No</td><td>A cursor for use in pagination. before is an object ID that
     * defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with
     * obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the
     * list.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     id: String (Required)
     *     object: String (Required)
     *     usage_bytes: int (Required)
     *     created_at: long (Required)
     *     vector_store_id: String (Required)
     *     status: String(in_progress/completed/failed/cancelled) (Required)
     *     last_error (Required): {
     *         code: String(server_error/invalid_file/unsupported_file) (Required)
     *         message: String (Required)
     *     }
     *     chunking_strategy (Required): {
     *         type: String(other/static) (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param vectorStoreId Identifier of the vector store.
     * @param batchId Identifier of the file batch.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the response data for a requested list of items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId,
        RequestOptions requestOptions) {
        return new PagedIterable<>(
            () -> listVectorStoreFileBatchFilesSinglePage(vectorStoreId, batchId, requestOptions));
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            List<?> values = (List<?>) obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        } catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            return (String) obj.get(path);
        } catch (RuntimeException e) {
            return null;
        }
    }
}
