// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.ThreadMessageOptions;
import com.azure.ai.agents.persistent.models.ToolDefinition;
import com.azure.ai.agents.persistent.models.TruncationObject;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The CreateRunRequest model.
 */
@Fluent
public final class CreateRunRequest implements JsonSerializable<CreateRunRequest> {

    /*
     * The ID of the agent that should run the thread.
     */
    @Generated
    private final String assistantId;

    /*
     * The overridden model name that the agent should use to run the thread.
     */
    @Generated
    private String model;

    /*
     * The overridden system instructions that the agent should use to run the thread.
     */
    @Generated
    private String instructions;

    /*
     * Additional instructions to append at the end of the instructions for the run. This is useful for modifying the
     * behavior
     * on a per-run basis without overriding other instructions.
     */
    @Generated
    private String additionalInstructions;

    /*
     * Adds additional messages to the thread before creating the run.
     */
    @Generated
    private List<ThreadMessageOptions> additionalMessages;

    /*
     * The overridden list of enabled tools that the agent should use to run the thread.
     */
    @Generated
    private List<ToolDefinition> tools;

    /*
     * If `true`, returns a stream of events that happen during the Run as server-sent events,
     * terminating when the Run enters a terminal state with a `data: [DONE]` message.
     */
    @Generated
    private Boolean stream;

    /*
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output
     * more random, while lower values like 0.2 will make it more focused and deterministic.
     */
    @Generated
    private Double temperature;

    /*
     * An alternative to sampling with temperature, called nucleus sampling, where the model
     * considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens
     * comprising the top 10% probability mass are considered.
     * 
     * We generally recommend altering this or temperature but not both.
     */
    @Generated
    private Double topP;

    /*
     * The maximum number of prompt tokens that may be used over the course of the run. The run will make a best effort
     * to use only
     * the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt
     * tokens specified,
     * the run will end with status `incomplete`. See `incomplete_details` for more info.
     */
    @Generated
    private Integer maxPromptTokens;

    /*
     * The maximum number of completion tokens that may be used over the course of the run. The run will make a best
     * effort
     * to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the
     * number of
     * completion tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.
     */
    @Generated
    private Integer maxCompletionTokens;

    /*
     * The strategy to use for dropping messages as the context windows moves forward.
     */
    @Generated
    private TruncationObject truncationStrategy;

    /*
     * Controls whether or not and which tool is called by the model.
     */
    @Generated
    private BinaryData toolChoice;

    /*
     * Specifies the format that the model must output.
     */
    @Generated
    private BinaryData responseFormat;

    /*
     * If `true` functions will run in parallel during tool use.
     */
    @Generated
    private Boolean parallelToolCalls;

    /*
     * A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
     * about that object in a structured format. Keys may be up to 64 characters in length and values may be up to 512
     * characters in length.
     */
    @Generated
    private Map<String, String> metadata;

    /**
     * Creates an instance of CreateRunRequest class.
     *
     * @param assistantId the assistantId value to set.
     */
    @Generated
    public CreateRunRequest(String assistantId) {
        this.assistantId = assistantId;
    }

    /**
     * Get the assistantId property: The ID of the agent that should run the thread.
     *
     * @return the assistantId value.
     */
    @Generated
    public String getAssistantId() {
        return this.assistantId;
    }

    /**
     * Get the model property: The overridden model name that the agent should use to run the thread.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Set the model property: The overridden model name that the agent should use to run the thread.
     *
     * @param model the model value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the instructions property: The overridden system instructions that the agent should use to run the thread.
     *
     * @return the instructions value.
     */
    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    /**
     * Set the instructions property: The overridden system instructions that the agent should use to run the thread.
     *
     * @param instructions the instructions value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setInstructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    /**
     * Get the additionalInstructions property: Additional instructions to append at the end of the instructions for the
     * run. This is useful for modifying the behavior
     * on a per-run basis without overriding other instructions.
     *
     * @return the additionalInstructions value.
     */
    @Generated
    public String getAdditionalInstructions() {
        return this.additionalInstructions;
    }

    /**
     * Set the additionalInstructions property: Additional instructions to append at the end of the instructions for the
     * run. This is useful for modifying the behavior
     * on a per-run basis without overriding other instructions.
     *
     * @param additionalInstructions the additionalInstructions value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setAdditionalInstructions(String additionalInstructions) {
        this.additionalInstructions = additionalInstructions;
        return this;
    }

    /**
     * Get the additionalMessages property: Adds additional messages to the thread before creating the run.
     *
     * @return the additionalMessages value.
     */
    @Generated
    public List<ThreadMessageOptions> getAdditionalMessages() {
        return this.additionalMessages;
    }

    /**
     * Set the additionalMessages property: Adds additional messages to the thread before creating the run.
     *
     * @param additionalMessages the additionalMessages value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setAdditionalMessages(List<ThreadMessageOptions> additionalMessages) {
        this.additionalMessages = additionalMessages;
        return this;
    }

    /**
     * Get the tools property: The overridden list of enabled tools that the agent should use to run the thread.
     *
     * @return the tools value.
     */
    @Generated
    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    /**
     * Set the tools property: The overridden list of enabled tools that the agent should use to run the thread.
     *
     * @param tools the tools value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setTools(List<ToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    /**
     * Get the stream property: If `true`, returns a stream of events that happen during the Run as server-sent events,
     * terminating when the Run enters a terminal state with a `data: [DONE]` message.
     *
     * @return the stream value.
     */
    @Generated
    public Boolean isStream() {
        return this.stream;
    }

    /**
     * Set the stream property: If `true`, returns a stream of events that happen during the Run as server-sent events,
     * terminating when the Run enters a terminal state with a `data: [DONE]` message.
     *
     * @param stream the stream value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    /**
     * Get the temperature property: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make
     * the output
     * more random, while lower values like 0.2 will make it more focused and deterministic.
     *
     * @return the temperature value.
     */
    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    /**
     * Set the temperature property: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make
     * the output
     * more random, while lower values like 0.2 will make it more focused and deterministic.
     *
     * @param temperature the temperature value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    /**
     * Get the topP property: An alternative to sampling with temperature, called nucleus sampling, where the model
     * considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens
     * comprising the top 10% probability mass are considered.
     *
     * We generally recommend altering this or temperature but not both.
     *
     * @return the topP value.
     */
    @Generated
    public Double getTopP() {
        return this.topP;
    }

    /**
     * Set the topP property: An alternative to sampling with temperature, called nucleus sampling, where the model
     * considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens
     * comprising the top 10% probability mass are considered.
     *
     * We generally recommend altering this or temperature but not both.
     *
     * @param topP the topP value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    /**
     * Get the maxPromptTokens property: The maximum number of prompt tokens that may be used over the course of the
     * run. The run will make a best effort to use only
     * the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt
     * tokens specified,
     * the run will end with status `incomplete`. See `incomplete_details` for more info.
     *
     * @return the maxPromptTokens value.
     */
    @Generated
    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    /**
     * Set the maxPromptTokens property: The maximum number of prompt tokens that may be used over the course of the
     * run. The run will make a best effort to use only
     * the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt
     * tokens specified,
     * the run will end with status `incomplete`. See `incomplete_details` for more info.
     *
     * @param maxPromptTokens the maxPromptTokens value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setMaxPromptTokens(Integer maxPromptTokens) {
        this.maxPromptTokens = maxPromptTokens;
        return this;
    }

    /**
     * Get the maxCompletionTokens property: The maximum number of completion tokens that may be used over the course of
     * the run. The run will make a best effort
     * to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the
     * number of
     * completion tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.
     *
     * @return the maxCompletionTokens value.
     */
    @Generated
    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    /**
     * Set the maxCompletionTokens property: The maximum number of completion tokens that may be used over the course of
     * the run. The run will make a best effort
     * to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the
     * number of
     * completion tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.
     *
     * @param maxCompletionTokens the maxCompletionTokens value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
        return this;
    }

    /**
     * Get the truncationStrategy property: The strategy to use for dropping messages as the context windows moves
     * forward.
     *
     * @return the truncationStrategy value.
     */
    @Generated
    public TruncationObject getTruncationStrategy() {
        return this.truncationStrategy;
    }

    /**
     * Set the truncationStrategy property: The strategy to use for dropping messages as the context windows moves
     * forward.
     *
     * @param truncationStrategy the truncationStrategy value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setTruncationStrategy(TruncationObject truncationStrategy) {
        this.truncationStrategy = truncationStrategy;
        return this;
    }

    /**
     * Get the toolChoice property: Controls whether or not and which tool is called by the model.
     *
     * @return the toolChoice value.
     */
    @Generated
    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    /**
     * Set the toolChoice property: Controls whether or not and which tool is called by the model.
     *
     * @param toolChoice the toolChoice value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setToolChoice(BinaryData toolChoice) {
        this.toolChoice = toolChoice;
        return this;
    }

    /**
     * Get the responseFormat property: Specifies the format that the model must output.
     *
     * @return the responseFormat value.
     */
    @Generated
    public BinaryData getResponseFormat() {
        return this.responseFormat;
    }

    /**
     * Set the responseFormat property: Specifies the format that the model must output.
     *
     * @param responseFormat the responseFormat value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setResponseFormat(BinaryData responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    /**
     * Get the parallelToolCalls property: If `true` functions will run in parallel during tool use.
     *
     * @return the parallelToolCalls value.
     */
    @Generated
    public Boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    /**
     * Set the parallelToolCalls property: If `true` functions will run in parallel during tool use.
     *
     * @param parallelToolCalls the parallelToolCalls value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
        return this;
    }

    /**
     * Get the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @param metadata the metadata value to set.
     * @return the CreateRunRequest object itself.
     */
    @Generated
    public CreateRunRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("assistant_id", this.assistantId);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeStringField("additional_instructions", this.additionalInstructions);
        jsonWriter.writeArrayField("additional_messages", this.additionalMessages,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeNumberField("temperature", this.temperature);
        jsonWriter.writeNumberField("top_p", this.topP);
        jsonWriter.writeNumberField("max_prompt_tokens", this.maxPromptTokens);
        jsonWriter.writeNumberField("max_completion_tokens", this.maxCompletionTokens);
        jsonWriter.writeJsonField("truncation_strategy", this.truncationStrategy);
        if (this.toolChoice != null) {
            jsonWriter.writeFieldName("tool_choice");
            this.toolChoice.writeTo(jsonWriter);
        }
        if (this.responseFormat != null) {
            jsonWriter.writeFieldName("response_format");
            this.responseFormat.writeTo(jsonWriter);
        }
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CreateRunRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CreateRunRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CreateRunRequest.
     */
    @Generated
    public static CreateRunRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String assistantId = null;
            String model = null;
            String instructions = null;
            String additionalInstructions = null;
            List<ThreadMessageOptions> additionalMessages = null;
            List<ToolDefinition> tools = null;
            Boolean stream = null;
            Double temperature = null;
            Double topP = null;
            Integer maxPromptTokens = null;
            Integer maxCompletionTokens = null;
            TruncationObject truncationStrategy = null;
            BinaryData toolChoice = null;
            BinaryData responseFormat = null;
            Boolean parallelToolCalls = null;
            Map<String, String> metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("assistant_id".equals(fieldName)) {
                    assistantId = reader.getString();
                } else if ("model".equals(fieldName)) {
                    model = reader.getString();
                } else if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                } else if ("additional_instructions".equals(fieldName)) {
                    additionalInstructions = reader.getString();
                } else if ("additional_messages".equals(fieldName)) {
                    additionalMessages = reader.readArray(reader1 -> ThreadMessageOptions.fromJson(reader1));
                } else if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                } else if ("stream".equals(fieldName)) {
                    stream = reader.getNullable(JsonReader::getBoolean);
                } else if ("temperature".equals(fieldName)) {
                    temperature = reader.getNullable(JsonReader::getDouble);
                } else if ("top_p".equals(fieldName)) {
                    topP = reader.getNullable(JsonReader::getDouble);
                } else if ("max_prompt_tokens".equals(fieldName)) {
                    maxPromptTokens = reader.getNullable(JsonReader::getInt);
                } else if ("max_completion_tokens".equals(fieldName)) {
                    maxCompletionTokens = reader.getNullable(JsonReader::getInt);
                } else if ("truncation_strategy".equals(fieldName)) {
                    truncationStrategy = TruncationObject.fromJson(reader);
                } else if ("tool_choice".equals(fieldName)) {
                    toolChoice
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("response_format".equals(fieldName)) {
                    responseFormat
                        = reader.getNullable(nonNullReader -> BinaryData.fromObject(nonNullReader.readUntyped()));
                } else if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = reader.getNullable(JsonReader::getBoolean);
                } else if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            CreateRunRequest deserializedCreateRunRequest = new CreateRunRequest(assistantId);
            deserializedCreateRunRequest.model = model;
            deserializedCreateRunRequest.instructions = instructions;
            deserializedCreateRunRequest.additionalInstructions = additionalInstructions;
            deserializedCreateRunRequest.additionalMessages = additionalMessages;
            deserializedCreateRunRequest.tools = tools;
            deserializedCreateRunRequest.stream = stream;
            deserializedCreateRunRequest.temperature = temperature;
            deserializedCreateRunRequest.topP = topP;
            deserializedCreateRunRequest.maxPromptTokens = maxPromptTokens;
            deserializedCreateRunRequest.maxCompletionTokens = maxCompletionTokens;
            deserializedCreateRunRequest.truncationStrategy = truncationStrategy;
            deserializedCreateRunRequest.toolChoice = toolChoice;
            deserializedCreateRunRequest.responseFormat = responseFormat;
            deserializedCreateRunRequest.parallelToolCalls = parallelToolCalls;
            deserializedCreateRunRequest.metadata = metadata;
            return deserializedCreateRunRequest;
        });
    }
}
