// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.VectorStoreChunkingStrategyRequest;
import com.azure.ai.agents.persistent.models.VectorStoreDataSource;
import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The CreateVectorStoreFileBatchRequest model.
 */
@Fluent
public final class CreateVectorStoreFileBatchRequest implements JsonSerializable<CreateVectorStoreFileBatchRequest> {

    /*
     * List of file identifiers.
     */
    @Generated
    private List<String> fileIds;

    /*
     * List of Azure assets.
     */
    @Generated
    private List<VectorStoreDataSource> dataSources;

    /*
     * The chunking strategy used to chunk the file(s). If not set, will use the auto strategy.
     */
    @Generated
    private VectorStoreChunkingStrategyRequest chunkingStrategy;

    /**
     * Creates an instance of CreateVectorStoreFileBatchRequest class.
     */
    @Generated
    public CreateVectorStoreFileBatchRequest() {
    }

    /**
     * Get the fileIds property: List of file identifiers.
     *
     * @return the fileIds value.
     */
    @Generated
    public List<String> getFileIds() {
        return this.fileIds;
    }

    /**
     * Set the fileIds property: List of file identifiers.
     *
     * @param fileIds the fileIds value to set.
     * @return the CreateVectorStoreFileBatchRequest object itself.
     */
    @Generated
    public CreateVectorStoreFileBatchRequest setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
        return this;
    }

    /**
     * Get the dataSources property: List of Azure assets.
     *
     * @return the dataSources value.
     */
    @Generated
    public List<VectorStoreDataSource> getDataSources() {
        return this.dataSources;
    }

    /**
     * Set the dataSources property: List of Azure assets.
     *
     * @param dataSources the dataSources value to set.
     * @return the CreateVectorStoreFileBatchRequest object itself.
     */
    @Generated
    public CreateVectorStoreFileBatchRequest setDataSources(List<VectorStoreDataSource> dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    /**
     * Get the chunkingStrategy property: The chunking strategy used to chunk the file(s). If not set, will use the auto
     * strategy.
     *
     * @return the chunkingStrategy value.
     */
    @Generated
    public VectorStoreChunkingStrategyRequest getChunkingStrategy() {
        return this.chunkingStrategy;
    }

    /**
     * Set the chunkingStrategy property: The chunking strategy used to chunk the file(s). If not set, will use the auto
     * strategy.
     *
     * @param chunkingStrategy the chunkingStrategy value to set.
     * @return the CreateVectorStoreFileBatchRequest object itself.
     */
    @Generated
    public CreateVectorStoreFileBatchRequest setChunkingStrategy(VectorStoreChunkingStrategyRequest chunkingStrategy) {
        this.chunkingStrategy = chunkingStrategy;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("file_ids", this.fileIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("data_sources", this.dataSources, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("chunking_strategy", this.chunkingStrategy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CreateVectorStoreFileBatchRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of CreateVectorStoreFileBatchRequest if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CreateVectorStoreFileBatchRequest.
     */
    @Generated
    public static CreateVectorStoreFileBatchRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CreateVectorStoreFileBatchRequest deserializedCreateVectorStoreFileBatchRequest
                = new CreateVectorStoreFileBatchRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_ids".equals(fieldName)) {
                    List<String> fileIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedCreateVectorStoreFileBatchRequest.fileIds = fileIds;
                } else if ("data_sources".equals(fieldName)) {
                    List<VectorStoreDataSource> dataSources
                        = reader.readArray(reader1 -> VectorStoreDataSource.fromJson(reader1));
                    deserializedCreateVectorStoreFileBatchRequest.dataSources = dataSources;
                } else if ("chunking_strategy".equals(fieldName)) {
                    deserializedCreateVectorStoreFileBatchRequest.chunkingStrategy
                        = VectorStoreChunkingStrategyRequest.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedCreateVectorStoreFileBatchRequest;
        });
    }
}
